/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.dimension_sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import com.qouteall.immersive_portals.dimension_sync.DimensionIdRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveFormat;
import org.apache.commons.lang3.Validate;

public class DimensionIdManagement {
    private static Field fabric_activeTag_field;

    public static void onServerStarted() {
        DimensionIdRecord ipRecord = DimensionIdManagement.readIPDimensionRegistry();
        if (ipRecord == null) {
            Helper.log("Immersive Portals' dimension id record is missing");
            DimensionIdRecord fabricRecord = DimensionIdManagement.getFabricRecord();
            if (fabricRecord != null) {
                Helper.log("Found Fabric's dimension id record");
                Helper.log("\n" + fabricRecord);
                DimensionIdRecord.serverRecord = fabricRecord;
                fabricRecord = null;
            } else {
                Helper.log("Cannot retrieve Fabric's dimension id record.");
                Helper.log("If this is not a newly created world, existing portal data may be corrupted!!!");
                DimensionIdRecord.serverRecord = null;
            }
        } else {
            DimensionIdRecord.serverRecord = ipRecord;
            Helper.log("Successfully read IP's dimension id record");
        }
        DimensionIdManagement.completeServerIdRecord();
        try {
            File file = DimensionIdManagement.getIPDimIdFile();
            FileOutputStream fileInputStream = new FileOutputStream(file);
            CompoundNBT tag = DimensionIdRecord.recordToTag(DimensionIdRecord.serverRecord);
            CompressedStreamTools.func_74799_a((CompoundNBT)tag, (OutputStream)fileInputStream);
            Helper.log("Dimension Id Info Saved to File");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot Save Immersive Portals Dimension Id Info", e);
        }
    }

    private static DimensionIdRecord readIPDimensionRegistry() {
        File dataFile = DimensionIdManagement.getIPDimIdFile();
        if (!dataFile.exists()) {
            Helper.log("Immersive Portals' Dimension Id Record File Does Not Exist");
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(dataFile);
            CompoundNBT tag = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            fileInputStream.close();
            return DimensionIdRecord.tagToRecord(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File getIPDimIdFile() {
        MinecraftServer server = McHelper.getServer();
        Validate.notNull((Object)server);
        Path saveDir = server.field_71310_m.field_237279_c_;
        return new File(new File(saveDir.toFile(), "data"), "imm_ptl_dim_reg.dat");
    }

    private static void completeServerIdRecord() {
        if (DimensionIdRecord.serverRecord == null) {
            Helper.log("Dimension Id Record is Missing");
            DimensionIdRecord.serverRecord = new DimensionIdRecord((BiMap<RegistryKey<World>, Integer>)HashBiMap.create());
        }
        Helper.log("Start Completing Dimension Id Record");
        Helper.log("Before:\n" + DimensionIdRecord.serverRecord);
        Set keys = McHelper.getServer().func_240770_D_();
        BiMap<RegistryKey<World>, Integer> bimap = DimensionIdRecord.serverRecord.idMap;
        if (!bimap.containsKey((Object)World.field_234918_g_)) {
            bimap.put((Object)World.field_234918_g_, (Object)0);
        }
        if (!bimap.containsKey((Object)World.field_234919_h_)) {
            bimap.put((Object)World.field_234919_h_, (Object)-1);
        }
        if (!bimap.containsKey((Object)World.field_234920_i_)) {
            bimap.put((Object)World.field_234920_i_, (Object)1);
        }
        ArrayList<RegistryKey> keysList = new ArrayList<RegistryKey>(keys);
        keysList.sort(Comparator.comparing(RegistryKey::toString));
        Helper.log("Server Loaded Dimensions:\n" + Helper.myToString(keysList.stream().map(RegistryKey::func_240901_a_)));
        keysList.forEach(dim -> {
            if (!bimap.containsKey(dim)) {
                int newid = bimap.values().stream().mapToInt(i -> i).max().orElse(1) + 1;
                bimap.put(dim, (Object)newid);
            }
        });
        Helper.log("After:\n" + DimensionIdRecord.serverRecord);
    }

    @Nullable
    private static DimensionIdRecord getFabricRecord() {
        if (O_O.isForge()) {
            return null;
        }
        try {
            SaveFormat.LevelSave session;
            CompoundNBT tag;
            if (fabric_activeTag_field == null) {
                fabric_activeTag_field = SaveFormat.LevelSave.class.getDeclaredField("fabric_activeTag");
                fabric_activeTag_field.setAccessible(true);
            }
            if ((tag = (CompoundNBT)fabric_activeTag_field.get(session = McHelper.getServer().field_71310_m)) == null) {
                return null;
            }
            return DimensionIdManagement.readIdsFromFabricRegistryRecord(tag);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get Fabric registry info", e);
        }
    }

    private static DimensionIdRecord readIdsFromFabricRegistryRecord(CompoundNBT fabricRegistryRecord) {
        CompoundNBT dimensionTypeTag = fabricRegistryRecord.func_74775_l("minecraft:dimension_type");
        if (dimensionTypeTag.isEmpty()) {
            Helper.err("Missing 'minecraft:dimension_type' " + fabricRegistryRecord);
            return null;
        }
        HashBiMap bimap = HashBiMap.create();
        dimensionTypeTag.func_150296_c().forEach(dim -> {
            INBT t = dimensionTypeTag.func_74781_a(dim);
            if (t instanceof IntNBT) {
                int data = ((IntNBT)t).func_150287_d();
                bimap.put(DimId.idToKey(dim), (Object)(data - 1));
            } else {
                Helper.err(String.format("Non-int tag in fabric registry data %s %s %s", t, dim, fabricRegistryRecord));
            }
        });
        return new DimensionIdRecord((BiMap<RegistryKey<World>, Integer>)bimap);
    }
}

