/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.dimension_sync;

import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.dimension_sync.DimensionIdRecord;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class DimId {
    private static final boolean useIntegerId = true;

    public static void writeWorldId(PacketBuffer buf, RegistryKey<World> dimension, boolean isClient) {
        DimensionIdRecord record = isClient ? DimensionIdRecord.clientRecord : DimensionIdRecord.serverRecord;
        int intId = record.getIntId(dimension);
        buf.writeInt(intId);
    }

    public static RegistryKey<World> readWorldId(PacketBuffer buf, boolean isClient) {
        if (isClient && O_O.isDedicatedServer()) {
            throw new IllegalStateException("oops");
        }
        DimensionIdRecord record = isClient ? DimensionIdRecord.clientRecord : DimensionIdRecord.serverRecord;
        int intId = buf.readInt();
        return record.getDim(intId);
    }

    public static RegistryKey<World> idToKey(ResourceLocation identifier) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)identifier);
    }

    public static RegistryKey<World> idToKey(String str) {
        return DimId.idToKey(new ResourceLocation(str));
    }

    public static void putWorldId(CompoundNBT tag, String tagName, RegistryKey<World> dim) {
        tag.func_74778_a(tagName, dim.func_240901_a_().toString());
    }

    public static RegistryKey<World> getWorldId(CompoundNBT tag, String tagName, boolean isClient) {
        INBT term = tag.func_74781_a(tagName);
        if (term instanceof IntNBT) {
            int intId = ((IntNBT)term).func_150287_d();
            DimensionIdRecord record = isClient ? DimensionIdRecord.clientRecord : DimensionIdRecord.serverRecord;
            return record.getDim(intId);
        }
        if (term instanceof StringNBT) {
            String id = ((StringNBT)term).func_150285_a_();
            return DimId.idToKey(id);
        }
        throw new RuntimeException("Invalid Dimension Record " + term);
    }
}

