/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.commands;

import com.google.common.collect.Streams;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.commands.ClientDebugCommand;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.GeometryPortalShape;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import com.qouteall.immersive_portals.portal.global_portals.BorderBarrierFiller;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import com.qouteall.immersive_portals.portal.global_portals.VerticalConnectingPortal;
import com.qouteall.immersive_portals.portal.global_portals.WorldWrappingPortal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.command.arguments.ComponentArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PortalCommand {
    public static void registerClientDebugCommand(CommandDispatcher<CommandSource> dispatcher) {
        ClientDebugCommand.register(dispatcher);
    }

    private static void registerGlobalPortalCommands(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"create_inward_wrapping").then(Commands.func_197056_a((String)"p1", (ArgumentType)ColumnPosArgument.func_212603_a()).then(Commands.func_197056_a((String)"p2", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(context -> {
            ColumnPos p1 = ColumnPosArgument.func_218101_a((CommandContext)context, (String)"p1");
            ColumnPos p2 = ColumnPosArgument.func_218101_a((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((CommandSource)context.getSource()).func_197023_e(), p1.field_219439_a, p1.field_219440_b, p2.field_219439_a, p2.field_219440_b, true, text -> ((CommandSource)context.getSource()).func_197030_a(text, false));
            return 0;
        }))));
        builder.then(Commands.func_197057_a((String)"create_outward_wrapping").then(Commands.func_197056_a((String)"p1", (ArgumentType)ColumnPosArgument.func_212603_a()).then(Commands.func_197056_a((String)"p2", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(context -> {
            ColumnPos p1 = ColumnPosArgument.func_218101_a((CommandContext)context, (String)"p1");
            ColumnPos p2 = ColumnPosArgument.func_218101_a((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((CommandSource)context.getSource()).func_197023_e(), p1.field_219439_a, p1.field_219440_b, p2.field_219439_a, p2.field_219440_b, false, text -> ((CommandSource)context.getSource()).func_197030_a(text, false));
            return 0;
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove_wrapping_zone").executes(context -> {
            WorldWrappingPortal.invokeRemoveWrappingZone(((CommandSource)context.getSource()).func_197023_e(), ((CommandSource)context.getSource()).func_197036_d(), text -> ((CommandSource)context.getSource()).func_197030_a(text, false));
            return 0;
        })).then(Commands.func_197056_a((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            WorldWrappingPortal.invokeRemoveWrappingZone(((CommandSource)context.getSource()).func_197023_e(), id, text -> ((CommandSource)context.getSource()).func_197030_a(text, false));
            return 0;
        })));
        builder.then(Commands.func_197057_a((String)"view_wrapping_zones").executes(context -> {
            WorldWrappingPortal.invokeViewWrappingZones(((CommandSource)context.getSource()).func_197023_e(), text -> ((CommandSource)context.getSource()).func_197030_a(text, false));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear_wrapping_border").executes(context -> {
            BorderBarrierFiller.onCommandExecuted(((CommandSource)context.getSource()).func_197035_h());
            return 0;
        })).then(Commands.func_197056_a((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            BorderBarrierFiller.onCommandExecuted(((CommandSource)context.getSource()).func_197035_h(), id);
            return 0;
        })));
        builder.then(Commands.func_197057_a((String)"connect_floor").then(Commands.func_197056_a((String)"from", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"to", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> {
            RegistryKey from = DimensionArgument.func_212592_a((CommandContext)context, (String)"from").func_234923_W_();
            RegistryKey to = DimensionArgument.func_212592_a((CommandContext)context, (String)"to").func_234923_W_();
            VerticalConnectingPortal.connect((RegistryKey<World>)from, VerticalConnectingPortal.ConnectorType.floor, (RegistryKey<World>)to);
            return 0;
        }))));
        builder.then(Commands.func_197057_a((String)"connect_ceil").then(Commands.func_197056_a((String)"from", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"to", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> {
            RegistryKey from = DimensionArgument.func_212592_a((CommandContext)context, (String)"from").func_234923_W_();
            RegistryKey to = DimensionArgument.func_212592_a((CommandContext)context, (String)"to").func_234923_W_();
            VerticalConnectingPortal.connect((RegistryKey<World>)from, VerticalConnectingPortal.ConnectorType.ceil, (RegistryKey<World>)to);
            return 0;
        }))));
        builder.then(Commands.func_197057_a((String)"connection_floor_remove").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> {
            RegistryKey dim = DimensionArgument.func_212592_a((CommandContext)context, (String)"dim").func_234923_W_();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.floor, (RegistryKey<World>)dim);
            return 0;
        })));
        builder.then(Commands.func_197057_a((String)"connection_ceil_remove").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> {
            RegistryKey dim = DimensionArgument.func_212592_a((CommandContext)context, (String)"dim").func_234923_W_();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.ceil, (RegistryKey<World>)dim);
            return 0;
        })));
        builder.then(Commands.func_197057_a((String)"view_global_portals").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            PortalCommand.sendMessage((CommandContext<CommandSource>)context, Helper.myToString(McHelper.getGlobalPortals(player.field_70170_p).stream()));
            return 0;
        }));
    }

    private static void registerPortalTargetedCommands(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"view_portal_data").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.sendPortalInfo((CommandContext<CommandSource>)context, portal))));
        builder.then(Commands.func_197057_a((String)"set_portal_custom_name").then(Commands.func_197056_a((String)"name", (ArgumentType)ComponentArgument.func_197067_a()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            ITextComponent name = ComponentArgument.func_197068_a((CommandContext)context, (String)"name");
            portal.func_200203_b(name);
        }))));
        builder.then(Commands.func_197057_a((String)"delete_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            PortalCommand.sendMessage((CommandContext<CommandSource>)context, "deleted " + (Object)((Object)portal));
            portal.func_70106_y();
        })));
        builder.then(Commands.func_197057_a((String)"set_portal_nbt").then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            CompoundNBT newNbt = NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"nbt");
            PortalCommand.setPortalNbt(portal, newNbt);
            PortalCommand.sendPortalInfo((CommandContext<CommandSource>)context, portal);
        }))));
        builder.then(Commands.func_197057_a((String)"set_portal_destination").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeSetPortalDestination((CommandContext<CommandSource>)context, portal))))));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "set_portal_rotation", (p, r) -> {
            p.rotation = r;
        });
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_body", (p, r) -> {
            if (r != null) {
                PortalManipulation.rotatePortalBody(p, r);
            }
        });
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_rotation", (portal, rot) -> {
            if (rot != null) {
                if (portal.rotation == null) {
                    portal.rotation = rot;
                } else {
                    portal.rotation.func_195890_a(rot);
                }
            }
        });
        builder.then(Commands.func_197057_a((String)"complete_bi_way_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeCompleteBiWayPortal((CommandContext<CommandSource>)context, portal))));
        builder.then(Commands.func_197057_a((String)"complete_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeCompleteBiFacedPortal((CommandContext<CommandSource>)context, portal))));
        builder.then(Commands.func_197057_a((String)"complete_bi_way_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeCompleteBiWayBiFacedPortal((CommandContext<CommandSource>)context, portal))));
        builder.then(Commands.func_197057_a((String)"remove_connected_portals").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSource>)context, "Removed " + (Object)p)))));
        builder.then(Commands.func_197057_a((String)"eradicate_portal_clutter").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSource>)context, "Removed " + (Object)p));
            portal.func_70106_y();
            PortalCommand.sendMessage((CommandContext<CommandSource>)context, "Deleted " + (Object)((Object)portal));
        })));
        builder.then(Commands.func_197057_a((String)"move_portal").then(Commands.func_197056_a((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            try {
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
                Vector3d viewVector = player.func_70040_Z();
                Direction facing = Direction.func_210769_a((double)viewVector.field_72450_a, (double)viewVector.field_72448_b, (double)viewVector.field_72449_c);
                Vector3d offset = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(distance);
                portal.func_70107_b(portal.func_226277_ct_() + offset.field_72450_a, portal.func_226278_cu_() + offset.field_72448_b, portal.func_226281_cx_() + offset.field_72449_c);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<CommandSource>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(Commands.func_197057_a((String)"move_portal_destination").then(Commands.func_197056_a((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            try {
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
                Vector3d viewVector = player.func_70040_Z();
                Direction facing = Direction.func_210769_a((double)viewVector.field_72450_a, (double)viewVector.field_72448_b, (double)viewVector.field_72449_c);
                Vector3d offset = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(distance);
                portal.destination = portal.destination.func_178787_e(portal.transformLocalVecNonScale(offset));
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<CommandSource>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set_portal_specific_accessor").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.removeSpecificAccessor((CommandContext<CommandSource>)context, portal)))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.setSpecificAccessor((CommandContext<CommandSource>)context, portal, EntityArgument.func_197088_a((CommandContext)context, (String)"player"))))));
        builder.then(Commands.func_197057_a((String)"multidest").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.removeMultidestEntry((CommandContext<CommandSource>)context, portal, EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"destination", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"isBiFaced", (ArgumentType)BoolArgumentType.bool()).then(Commands.func_197056_a((String)"isBiWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.setMultidestEntry((CommandContext<CommandSource>)context, portal, EntityArgument.func_197089_d((CommandContext)context, (String)"player"), (RegistryKey<World>)DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension").func_234923_W_(), Vec3Argument.func_197300_a((CommandContext)context, (String)"destination"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiFaced"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiWay"))))))))));
        builder.then(Commands.func_197057_a((String)"make_portal_round").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            PortalCommand.makePortalRound(portal);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(Commands.func_197057_a((String)"set_portal_scale").then(Commands.func_197056_a((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            double scale;
            portal.scaling = scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            PortalCommand.reloadPortal(portal);
        }))));
    }

    private static void registerPortalTargetedCommandWithRotationArgument(LiteralArgumentBuilder<CommandSource> builder, String literal, BiConsumer<Portal, Quaternion> func) {
        builder.then(Commands.func_197057_a((String)literal).then(Commands.func_197056_a((String)"rotatingAxis", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            Vector3d rotatingAxis = Vec3Argument.func_197300_a((CommandContext)context, (String)"rotatingAxis").func_72432_b();
            double angleDegrees = DoubleArgumentType.getDouble((CommandContext)context, (String)"angleDegrees");
            Quaternion rot = angleDegrees != 0.0 ? new Quaternion(new Vector3f(rotatingAxis), (float)angleDegrees, true) : null;
            func.accept(portal, rot);
            PortalCommand.reloadPortal(portal);
        })))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)(literal + "_along")).then(Commands.func_197057_a((String)"x").then(Commands.func_197056_a((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
            double angleDegrees = DoubleArgumentType.getDouble((CommandContext)context, (String)"angleDegrees");
            Quaternion rot = angleDegrees != 0.0 ? new Quaternion(axis, (float)angleDegrees, true) : null;
            func.accept(portal, rot);
            PortalCommand.reloadPortal(portal);
        }))))).then(Commands.func_197057_a((String)"y").then(Commands.func_197056_a((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
            double angleDegrees = DoubleArgumentType.getDouble((CommandContext)context, (String)"angleDegrees");
            Quaternion rot = angleDegrees != 0.0 ? new Quaternion(axis, (float)angleDegrees, true) : null;
            func.accept(portal, rot);
            PortalCommand.reloadPortal(portal);
        }))))).then(Commands.func_197057_a((String)"z").then(Commands.func_197056_a((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSource>)context, portal -> {
            Vector3f axis = new Vector3f(0.0f, 0.0f, 1.0f);
            double angleDegrees = DoubleArgumentType.getDouble((CommandContext)context, (String)"angleDegrees");
            Quaternion rot = angleDegrees != 0.0 ? new Quaternion(axis, (float)angleDegrees, true) : null;
            func.accept(portal, rot);
            PortalCommand.reloadPortal(portal);
        })))));
    }

    private static void setPortalRotation(Portal portal, Vector3f axis, double angleDegrees) {
        portal.rotation = angleDegrees != 0.0 ? new Quaternion(axis, (float)angleDegrees, true) : null;
        PortalCommand.reloadPortal(portal);
    }

    private static void setPortalNbt(Portal portal, CompoundNBT newNbt) {
        CompoundNBT portalNbt = portal.func_189511_e(new CompoundNBT());
        newNbt.func_150296_c().forEach(key -> portalNbt.func_218657_a(key, newNbt.func_74781_a(key)));
        UUID uuid = portal.func_110124_au();
        portal.func_70020_e(portalNbt);
        portal.func_184221_a(uuid);
        PortalCommand.reloadPortal(portal);
    }

    private static void registerCBPortalCommands(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"cb_set_portal_destination").then(Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(context -> PortalCommand.processPortalArgumentedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeSetPortalDestination((CommandContext<CommandSource>)context, portal)))))));
        builder.then(Commands.func_197057_a((String)"cb_complete_bi_way_portal").then(Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> PortalCommand.processPortalArgumentedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeCompleteBiWayPortal((CommandContext<CommandSource>)context, portal)))));
        builder.then(Commands.func_197057_a((String)"cb_complete_bi_faced_portal").then(Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> PortalCommand.processPortalArgumentedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeCompleteBiFacedPortal((CommandContext<CommandSource>)context, portal)))));
        builder.then(Commands.func_197057_a((String)"cb_complete_bi_way_bi_faced_portal").then(Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> PortalCommand.processPortalArgumentedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeCompleteBiWayBiFacedPortal((CommandContext<CommandSource>)context, portal)))));
        builder.then(Commands.func_197057_a((String)"cb_remove_connected_portals").then(Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> PortalCommand.processPortalArgumentedCommand((CommandContext<CommandSource>)context, portal -> PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSource>)context, "Removed " + (Object)p))))));
        builder.then(Commands.func_197057_a((String)"cb_set_portal_specific_accessor").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            EntityArgument.func_197097_b((CommandContext)context, (String)"portal").stream().filter(e -> e instanceof Portal).forEach(p -> PortalCommand.removeSpecificAccessor((CommandContext<CommandSource>)context, (Portal)((Object)((Object)p))));
            return 0;
        })).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> {
            Entity player = EntityArgument.func_197088_a((CommandContext)context, (String)"player");
            EntityArgument.func_197097_b((CommandContext)context, (String)"portal").stream().filter(e -> e instanceof Portal).forEach(p -> PortalCommand.setSpecificAccessor((CommandContext<CommandSource>)context, (Portal)((Object)((Object)p)), player));
            return 0;
        }))));
        builder.then(Commands.func_197057_a((String)"cb_make_portal").then(Commands.func_197056_a((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.func_197056_a((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.func_197056_a((String)"from", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"to", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            Entity fromEntity = EntityArgument.func_197088_a((CommandContext)context, (String)"from");
            Entity toEntity = EntityArgument.func_197088_a((CommandContext)context, (String)"to");
            Portal portal = (Portal)Portal.entityType.func_200721_a(fromEntity.field_70170_p);
            portal.func_70107_b(fromEntity.func_226277_ct_(), fromEntity.func_226278_cu_(), fromEntity.func_226281_cx_());
            portal.dimensionTo = toEntity.field_70170_p.func_234923_W_();
            portal.destination = toEntity.func_213303_ch();
            portal.width = width;
            portal.height = height;
            Vector3d normal = fromEntity.func_70676_i(1.0f);
            Vector3d rightVec = PortalCommand.getRightVec(fromEntity);
            Vector3d axisH = rightVec.func_72431_c(normal).func_72432_b();
            portal.axisW = rightVec;
            portal.axisH = axisH;
            McHelper.spawnServerEntityToUnloadedArea(portal);
            return 0;
        }))))));
        builder.then(Commands.func_197057_a((String)"cb_set_portal_nbt").then(Commands.func_197056_a((String)"portal", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> PortalCommand.processPortalArgumentedCommand((CommandContext<CommandSource>)context, portal -> PortalCommand.invokeSetPortalNBT((CommandContext<CommandSource>)context, portal))))));
    }

    private static void registerUtilityCommands(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpme").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            Entity entity = EntityArgument.func_197088_a((CommandContext)context, (String)"target");
            Global.serverTeleportationManager.invokeTpmeCommand(((CommandSource)context.getSource()).func_197035_h(), (RegistryKey<World>)entity.field_70170_p.func_234923_W_(), entity.func_213303_ch());
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("imm_ptl.command.tpme.success", new Object[]{entity.func_145748_c_()}), true);
            return 1;
        }))).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> {
            Vector3d dest = Vec3Argument.func_197300_a((CommandContext)context, (String)"dest");
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            Global.serverTeleportationManager.invokeTpmeCommand(player, (RegistryKey<World>)player.field_70170_p.func_234923_W_(), dest);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("imm_ptl.command.tpme.success", new Object[]{dest.toString()}), true);
            return 1;
        }))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> {
            RegistryKey dim = DimensionArgument.func_212592_a((CommandContext)context, (String)"dim").func_234923_W_();
            Vector3d dest = Vec3Argument.func_197300_a((CommandContext)context, (String)"dest");
            Global.serverTeleportationManager.invokeTpmeCommand(((CommandSource)context.getSource()).func_197035_h(), (RegistryKey<World>)dim, dest);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("imm_ptl.command.tpme.success", new Object[]{McHelper.dimensionTypeId((RegistryKey<World>)dim).toString() + dest.toString()}), true);
            return 1;
        }))));
        builder.then(Commands.func_197057_a((String)"tp").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"from", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"to", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            Collection entities = EntityArgument.func_197097_b((CommandContext)context, (String)"from");
            Entity target = EntityArgument.func_197088_a((CommandContext)context, (String)"to");
            int numTeleported = PortalCommand.teleport(entities, (RegistryKey<World>)target.field_70170_p.func_234923_W_(), target.func_213303_ch());
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("imm_ptl.command.tp.success", new Object[]{numTeleported, target.func_145748_c_()}), true);
            return numTeleported;
        }))).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> {
            Collection entities = EntityArgument.func_197097_b((CommandContext)context, (String)"from");
            Vector3d dest = Vec3Argument.func_197300_a((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (RegistryKey<World>)((CommandSource)context.getSource()).func_197023_e().func_234923_W_(), dest);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("imm_ptl.command.tp.success", new Object[]{numTeleported, dest.toString()}), true);
            return numTeleported;
        }))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> {
            Collection entities = EntityArgument.func_197097_b((CommandContext)context, (String)"from");
            RegistryKey dim = DimensionArgument.func_212592_a((CommandContext)context, (String)"dim").func_234923_W_();
            Vector3d dest = Vec3Argument.func_197300_a((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (RegistryKey<World>)((CommandSource)context.getSource()).func_197023_e().func_234923_W_(), dest);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("imm_ptl.command.tp.success", new Object[]{numTeleported, McHelper.dimensionTypeId((RegistryKey<World>)dim).toString() + dest.toString()}), true);
            return numTeleported;
        })))));
        builder.then(Commands.func_197057_a((String)"make_portal").then(Commands.func_197056_a((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.func_197056_a((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"to", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"dest", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(PortalCommand::placePortalAbsolute))).then(Commands.func_197057_a((String)"shift").then(Commands.func_197056_a((String)"dist", (ArgumentType)DoubleArgumentType.doubleArg()).executes(PortalCommand::placePortalShift)))))));
        builder.then(Commands.func_197057_a((String)"goback").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            Tuple<RegistryKey<World>, Vector3d> lastPos = Global.serverTeleportationManager.lastPosition.get(player);
            if (lastPos == null) {
                PortalCommand.sendMessage((CommandContext<CommandSource>)context, "You haven't teleported");
            } else {
                Global.serverTeleportationManager.invokeTpmeCommand(player, (RegistryKey<World>)((RegistryKey)lastPos.func_76341_a()), (Vector3d)lastPos.func_76340_b());
            }
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"create_small_inward_wrapping").then(Commands.func_197056_a((String)"p1", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"p2", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(context -> {
            Vector3d p1 = Vec3Argument.func_197300_a((CommandContext)context, (String)"p1");
            Vector3d p2 = Vec3Argument.func_197300_a((CommandContext)context, (String)"p2");
            AxisAlignedBB box = new AxisAlignedBB(p1, p2);
            ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
            PortalCommand.addSmallWorldWrappingPortals(box, world, true);
            return 0;
        }))));
        builder.then(Commands.func_197057_a((String)"create_small_outward_wrapping").then(Commands.func_197056_a((String)"p1", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"p2", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(context -> {
            Vector3d p1 = Vec3Argument.func_197300_a((CommandContext)context, (String)"p1");
            Vector3d p2 = Vec3Argument.func_197300_a((CommandContext)context, (String)"p2");
            AxisAlignedBB box = new AxisAlignedBB(p1, p2);
            ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
            PortalCommand.addSmallWorldWrappingPortals(box, world, false);
            return 0;
        }))));
        builder.then(Commands.func_197057_a((String)"create_scaled_box_view").then(Commands.func_197056_a((String)"p1", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"p2", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.func_197056_a((String)"placeTargetEntity", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"biWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            BlockPos bp1 = BlockPosArgument.func_197274_b((CommandContext)context, (String)"p1");
            BlockPos bp2 = BlockPosArgument.func_197274_b((CommandContext)context, (String)"p2");
            IntBox intBox = new IntBox(bp1, bp2);
            Entity placeTargetEntity = EntityArgument.func_197088_a((CommandContext)context, (String)"placeTargetEntity");
            ServerWorld boxWorld = (ServerWorld)placeTargetEntity.field_70170_p;
            Vector3d boxBottomCenter = placeTargetEntity.func_213303_ch();
            AxisAlignedBB area = intBox.toRealNumberBox();
            ServerWorld areaWorld = ((CommandSource)context.getSource()).func_197023_e();
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            boolean biWay = BoolArgumentType.getBool((CommandContext)context, (String)"biWay");
            PortalCommand.createScaledBoxView(areaWorld, area, boxWorld, boxBottomCenter, scale, biWay);
            return 0;
        })))))));
    }

    private static void createScaledBoxView(ServerWorld areaWorld, AxisAlignedBB area, ServerWorld boxWorld, Vector3d boxBottomCenter, double scale, boolean biWay) {
        Vector3d viewBoxSize = Helper.getBoxSize(area).func_186678_a(1.0 / scale);
        AxisAlignedBB viewBox = new AxisAlignedBB(boxBottomCenter.func_178786_a(viewBoxSize.field_72450_a / 2.0, 0.0, viewBoxSize.field_72449_c / 2.0), boxBottomCenter.func_72441_c(viewBoxSize.field_72450_a / 2.0, viewBoxSize.field_72448_b, viewBoxSize.field_72449_c / 2.0));
        for (Direction direction : Direction.values()) {
            Portal portal = PortalManipulation.createOrthodoxPortal(Portal.entityType, boxWorld, areaWorld, direction, Helper.getBoxSurface(viewBox, direction), Helper.getBoxSurface(area, direction).func_189972_c());
            portal.scaling = scale;
            portal.teleportChangesScale = false;
            portal.extension.adjustPositionAfterTeleport = true;
            McHelper.spawnServerEntityToUnloadedArea(portal);
            if (!biWay) continue;
            PortalManipulation.completeBiWayPortal(portal, Portal.entityType);
        }
    }

    private static void addSmallWorldWrappingPortals(AxisAlignedBB box, ServerWorld world, boolean isInward) {
        for (Direction direction : Direction.values()) {
            Portal portal = (Portal)Portal.entityType.func_200721_a((World)world);
            WorldWrappingPortal.initWrappingPortal(world, box, direction, isInward, portal);
            McHelper.spawnServerEntityToUnloadedArea(portal);
        }
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"portal").requires(commandSource -> commandSource.func_197034_c(2));
        PortalCommand.registerPortalTargetedCommands((LiteralArgumentBuilder<CommandSource>)builder);
        PortalCommand.registerCBPortalCommands((LiteralArgumentBuilder<CommandSource>)builder);
        PortalCommand.registerUtilityCommands((LiteralArgumentBuilder<CommandSource>)builder);
        LiteralArgumentBuilder global = Commands.func_197057_a((String)"global");
        PortalCommand.registerGlobalPortalCommands((LiteralArgumentBuilder<CommandSource>)global);
        builder.then((ArgumentBuilder)global);
        dispatcher.register(builder);
    }

    public static int processPortalArgumentedCommand(CommandContext<CommandSource> context, PortalConsumerThrowsCommandSyntaxException invoker) throws CommandSyntaxException {
        Collection entities = EntityArgument.func_197097_b(context, (String)"portal");
        for (Entity portalEntity : entities) {
            if (portalEntity instanceof Portal) {
                Portal portal = (Portal)portalEntity;
                invoker.accept(portal);
                continue;
            }
            PortalCommand.sendMessage(context, "The target should be portal");
        }
        return 0;
    }

    private static void invokeSetPortalDestination(CommandContext<CommandSource> context, Portal portal) throws CommandSyntaxException {
        portal.dimensionTo = DimensionArgument.func_212592_a(context, (String)"dim").func_234923_W_();
        portal.destination = Vec3Argument.func_197300_a(context, (String)"dest");
        PortalCommand.reloadPortal(portal);
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void invokeCompleteBiWayBiFacedPortal(CommandContext<CommandSource> context, Portal portal) {
        PortalManipulation.completeBiWayBiFacedPortal(portal, p -> PortalCommand.sendMessage(context, "Removed " + (Object)p), p -> PortalCommand.sendMessage(context, "Added " + (Object)p), Portal.entityType);
    }

    private static void invokeCompleteBiFacedPortal(CommandContext<CommandSource> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((World)((ServerWorld)portal.field_70170_p), portal.func_213303_ch(), portal.getNormal().func_186678_a(-1.0), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + (Object)p));
        Portal result = PortalManipulation.completeBiFacedPortal(portal, Portal.entityType);
        PortalCommand.sendMessage(context, "Added " + (Object)((Object)result));
    }

    private static void invokeCompleteBiWayPortal(CommandContext<CommandSource> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((World)McHelper.getServer().func_71218_a(portal.dimensionTo), portal.destination, portal.transformLocalVecNonScale(portal.getNormal().func_186678_a(-1.0)), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + (Object)p));
        Portal result = PortalManipulation.completeBiWayPortal(portal, Portal.entityType);
        PortalCommand.sendMessage(context, "Added " + (Object)((Object)result));
    }

    private static void removeSpecificAccessor(CommandContext<CommandSource> context, Portal portal) {
        portal.specificPlayerId = null;
        PortalCommand.sendMessage(context, "This portal can be accessed by all players now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void setSpecificAccessor(CommandContext<CommandSource> context, Portal portal, Entity player) {
        portal.specificPlayerId = player.func_110124_au();
        PortalCommand.sendMessage(context, "This portal can only be accessed by " + player.func_200200_C_().func_150261_e() + " now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void invokeSetPortalNBT(CommandContext<CommandSource> context, Portal portal) throws CommandSyntaxException {
        CompoundNBT newNbt = NBTCompoundTagArgument.func_218042_a(context, (String)"nbt");
        PortalCommand.setPortalNbt(portal, newNbt);
        PortalCommand.sendPortalInfo(context, portal);
    }

    private static void removeMultidestEntry(CommandContext<CommandSource> context, Portal pointedPortal, ServerPlayerEntity player) {
        PortalManipulation.getPortalClutter(pointedPortal.field_70170_p, pointedPortal.func_213303_ch(), pointedPortal.getNormal(), p -> true).stream().filter(portal -> player.func_110124_au().equals(portal.specificPlayerId) || portal.specificPlayerId == null).forEach(portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage(context, "removed " + p.toString()));
            PortalCommand.sendMessage(context, "removed " + portal.toString());
            portal.func_70106_y();
        });
    }

    private static void setMultidestEntry(CommandContext<CommandSource> context, Portal pointedPortal, ServerPlayerEntity player, RegistryKey<World> dimension, Vector3d destination, boolean biFaced, boolean biWay) {
        Portal newPortal = PortalManipulation.copyPortal(pointedPortal, Portal.entityType);
        PortalCommand.removeMultidestEntry(context, pointedPortal, player);
        newPortal.dimensionTo = dimension;
        newPortal.destination = destination;
        newPortal.specificPlayerId = player.func_110124_au();
        McHelper.spawnServerEntityToUnloadedArea(newPortal);
        PortalCommand.configureBiWayBiFaced(newPortal, biWay, biFaced);
    }

    private static void configureBiWayBiFaced(Portal newPortal, boolean biWay, boolean biFaced) {
        if (biFaced && biWay) {
            PortalManipulation.completeBiWayBiFacedPortal(newPortal, p -> {}, p -> {}, Portal.entityType);
        } else if (biFaced) {
            PortalManipulation.completeBiFacedPortal(newPortal, Portal.entityType);
        } else if (biWay) {
            PortalManipulation.completeBiWayPortal(newPortal, Portal.entityType);
        }
    }

    public static void sendPortalInfo(CommandContext<CommandSource> context, Portal portal) {
        ((CommandSource)context.getSource()).func_197030_a(portal.func_189511_e(new CompoundNBT()).func_197637_c(), false);
        PortalCommand.sendMessage(context, "\n\n" + portal.toString());
    }

    public static void reloadPortal(Portal portal) {
        portal.updateCache();
        McHelper.getIEStorage((RegistryKey<World>)portal.field_70170_p.func_234923_W_()).resendSpawnPacketToTrackers(portal);
    }

    public static void sendMessage(CommandContext<CommandSource> context, String message) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(message), false);
    }

    private static ITextComponent getMakePortalSuccess(Portal portal) {
        return new TranslationTextComponent("imm_ptl.command.make_portal.success", new Object[]{Double.toString(portal.width), Double.toString(portal.height), McHelper.dimensionTypeId((RegistryKey<World>)portal.field_70170_p.func_234923_W_()).toString(), portal.func_213303_ch().toString(), McHelper.dimensionTypeId(portal.dimensionTo).toString(), portal.destination.toString()});
    }

    private static int placePortalAbsolute(CommandContext<CommandSource> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        RegistryKey to = DimensionArgument.func_212592_a(context, (String)"to").func_234923_W_();
        Vector3d dest = Vec3Argument.func_197300_a(context, (String)"dest");
        Portal portal = Helper.placePortal(width, height, (Entity)((CommandSource)context.getSource()).func_197035_h());
        if (portal == null) {
            return 0;
        }
        portal.dimensionTo = to;
        portal.destination = dest;
        McHelper.spawnServerEntityToUnloadedArea(portal);
        ((CommandSource)context.getSource()).func_197030_a(PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    private static int placePortalShift(CommandContext<CommandSource> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        RegistryKey to = DimensionArgument.func_212592_a(context, (String)"to").func_234923_W_();
        double dist = DoubleArgumentType.getDouble(context, (String)"dist");
        Portal portal = Helper.placePortal(width, height, (Entity)((CommandSource)context.getSource()).func_197035_h());
        if (portal == null) {
            return 0;
        }
        portal.dimensionTo = to;
        portal.destination = portal.func_213303_ch().func_178787_e(portal.axisW.func_72431_c(portal.axisH).func_186678_a(-dist));
        McHelper.spawnServerEntityToUnloadedArea(portal);
        ((CommandSource)context.getSource()).func_197030_a(PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    private static int teleport(Collection<? extends Entity> entities, RegistryKey<World> targetDim, Vector3d targetPos) {
        ServerWorld targetWorld = McHelper.getServer().func_71218_a(targetDim);
        int numTeleported = 0;
        for (Entity entity : entities) {
            if (entity instanceof ServerPlayerEntity) {
                Global.serverTeleportationManager.invokeTpmeCommand((ServerPlayerEntity)entity, targetDim, targetPos);
            } else if (targetWorld == entity.field_70170_p) {
                entity.func_70012_b(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
                entity.func_70034_d(entity.field_70177_z);
            } else {
                Global.serverTeleportationManager.changeEntityDimension(entity, targetDim, targetPos.func_72441_c(0.0, (double)entity.func_70047_e(), 0.0), true);
            }
            ++numTeleported;
        }
        return numTeleported;
    }

    public static int processPortalTargetedCommand(CommandContext<CommandSource> context, PortalConsumerThrowsCommandSyntaxException processCommand) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        Entity entity = source.func_197022_f();
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            Portal portal = PortalCommand.getPlayerPointingPortal(player);
            if (portal == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("You are not pointing to any portal"), true);
                return 0;
            }
            processCommand.accept(portal);
        } else if (entity instanceof Portal) {
            processCommand.accept((Portal)entity);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("The command executor should be either a player or a portal entity"), false);
        }
        return 0;
    }

    public static Portal getPlayerPointingPortal(ServerPlayerEntity player) {
        return PortalCommand.getPlayerPointingPortalRaw((PlayerEntity)player, 1.0f, 100.0, false).map(Pair::getFirst).orElse(null);
    }

    public static Optional<Pair<Portal, Vector3d>> getPlayerPointingPortalRaw(PlayerEntity player, float tickDelta, double maxDistance, boolean includeGlobalPortal) {
        Vector3d from = player.func_174824_e(tickDelta);
        Vector3d to = from.func_178787_e(player.func_70676_i(tickDelta).func_186678_a(maxDistance));
        World world = player.field_70170_p;
        return PortalCommand.raytracePortals(world, from, to, includeGlobalPortal);
    }

    public static Optional<Pair<Portal, Vector3d>> raytracePortals(World world, Vector3d from, Vector3d to, boolean includeGlobalPortal) {
        Stream portalStream = McHelper.getEntitiesNearby(world, from, Portal.class, from.func_72438_d(to));
        if (includeGlobalPortal) {
            List<GlobalTrackedPortal> globalPortals = McHelper.getGlobalPortals(world);
            portalStream = Streams.concat((Stream[])new Stream[]{portalStream, globalPortals.stream()});
        }
        return portalStream.map(portal -> new Pair((Object)portal, (Object)portal.rayTrace(from, to))).filter(portalAndHitPos -> portalAndHitPos.getSecond() != null).min(Comparator.comparingDouble(portalAndHitPos -> ((Vector3d)portalAndHitPos.getSecond()).func_72436_e(from)));
    }

    private static void makePortalRound(Portal portal) {
        GeometryPortalShape shape = new GeometryPortalShape();
        int triangleNum = 30;
        double twoPi = Math.PI * 2;
        shape.triangles = IntStream.range(0, 30).mapToObj(i -> new GeometryPortalShape.TriangleInPlane(0.0, 0.0, portal.width * 0.5 * Math.cos(twoPi * (double)i / 30.0), portal.height * 0.5 * Math.sin(twoPi * (double)i / 30.0), portal.width * 0.5 * Math.cos(twoPi * ((double)i + 1.0) / 30.0), portal.height * 0.5 * Math.sin(twoPi * ((double)i + 1.0) / 30.0))).collect(Collectors.toList());
        portal.specialShape = shape;
        portal.cullableXStart = 0.0;
        portal.cullableXEnd = 0.0;
        portal.cullableYStart = 0.0;
        portal.cullableYEnd = 0.0;
    }

    private static Vector3d getRightVec(Entity entity) {
        float yaw = entity.field_70177_z + 90.0f;
        float radians = -yaw * ((float)Math.PI / 180);
        return new Vector3d(Math.sin(radians), 0.0, Math.cos(radians));
    }

    public static interface PortalConsumerThrowsCommandSyntaxException {
        public void accept(Portal var1) throws CommandSyntaxException;
    }
}

