/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.altius_world.AltiusInfo;
import com.qouteall.immersive_portals.chunk_loading.ChunkVisibilityManager;
import com.qouteall.immersive_portals.chunk_loading.MyClientChunkManager;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.ducks.IEEntity;
import com.qouteall.immersive_portals.ducks.IEWorldRenderer;
import com.qouteall.immersive_portals.optifine_compatibility.UniformReport;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.MyBuiltChunkStorage;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.lang.ref.Reference;
import java.net.URLClassLoader;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientDebugCommand {
    private static Consumer<ServerPlayerEntity> originalAddPortalFunctionality = player -> {
        Vector3d fromPos = player.func_213303_ch();
        Vector3d fromNormal = player.func_70040_Z().func_186678_a(-1.0);
        ServerWorld fromWorld = (ServerWorld)player.field_70170_p;
        addPortalFunctionality = playerEntity -> {
            Vector3d toPos = playerEntity.func_213303_ch();
            RegistryKey toDimension = player.field_70170_p.func_234923_W_();
            Portal portal = new Portal(Portal.entityType, (World)fromWorld);
            portal.func_226288_n_(fromPos.field_72450_a, fromPos.field_72448_b, fromPos.field_72449_c);
            portal.axisH = new Vector3d(0.0, 1.0, 0.0);
            portal.axisW = portal.axisH.func_72431_c(fromNormal).func_72432_b();
            portal.dimensionTo = toDimension;
            portal.destination = toPos;
            portal.width = 4.0;
            portal.height = 4.0;
            assert (portal.isPortalValid());
            fromWorld.func_217376_c((Entity)portal);
            addPortalFunctionality = originalAddPortalFunctionality;
        };
    };
    private static Consumer<ServerPlayerEntity> addPortalFunctionality = originalAddPortalFunctionality;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"immersive_portals_debug").requires(commandSource -> true)).then(Commands.func_197057_a((String)"set_max_portal_layer").then(Commands.func_197056_a((String)"argMaxPortalLayer", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ClientDebugCommand.setMaxPortalLayer(IntegerArgumentType.getInteger((CommandContext)context, (String)"argMaxPortalLayer")))));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"list_portals").executes(context -> ClientDebugCommand.listPortals((CommandContext<CommandSource>)context)));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"is_client_chunk_loaded").then(Commands.func_197056_a((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.func_197056_a((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(ClientDebugCommand::isClientChunkLoaded))));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"is_server_chunk_loaded").then(Commands.func_197056_a((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.func_197056_a((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int chunkX = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkX");
            int chunkZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkZ");
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            IChunk chunk = McHelper.getServer().func_71218_a(player.field_70170_p.func_234923_W_()).func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false);
            McHelper.serverLog(player, chunk != null && !(chunk instanceof EmptyChunk) ? "yes" : "no");
            return 0;
        }))));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"add_portal").executes(context -> ClientDebugCommand.addPortal((CommandContext<CommandSource>)context)));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"report_player_status").executes(context -> ClientDebugCommand.reportPlayerStatus((CommandContext<CommandSource>)context)));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"client_remote_ticking_enable").executes(context -> {
            CGlobal.isClientRemoteTickingEnabled = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"client_remote_ticking_disable").executes(context -> {
            CGlobal.isClientRemoteTickingEnabled = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"advanced_frustum_culling_enable").executes(context -> {
            CGlobal.doUseAdvancedFrustumCulling = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"advanced_frustum_culling_disable").executes(context -> {
            CGlobal.doUseAdvancedFrustumCulling = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"hacked_chunk_render_dispatcher_enable").executes(context -> {
            CGlobal.useHackedChunkRenderDispatcher = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"hacked_chunk_render_dispatcher_disable").executes(context -> {
            CGlobal.useHackedChunkRenderDispatcher = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"front_culling_enable").executes(context -> {
            CGlobal.useFrontCulling = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"front_culling_disable").executes(context -> {
            CGlobal.useFrontCulling = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"report_server_entities").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            List entities = player.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(player.func_213303_ch(), player.func_213303_ch()).func_186662_g(32.0), e -> true);
            McHelper.serverLog(player, entities.toString());
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"report_resource_consumption").executes(ClientDebugCommand::reportResourceConsumption));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"report_render_info_num").executes(context -> {
            String str = Helper.myToString(CGlobal.renderInfoNumMap.entrySet().stream());
            ((CommandSource)context.getSource()).func_197035_h().func_146105_b((ITextComponent)new StringTextComponent(str), false);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"get_player_colliding_portal_client").executes(context -> {
            Portal collidingPortal = ((IEEntity)Minecraft.func_71410_x().field_71439_g).getCollidingPortal();
            McHelper.serverLog(((CommandSource)context.getSource()).func_197035_h(), collidingPortal != null ? collidingPortal.toString() : "null");
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"report_rendering").executes(context -> {
            String str = RenderStates.lastPortalRenderInfos.stream().map(list -> list.stream().map(Reference::get).collect(Collectors.toList())).collect(Collectors.toList()).toString();
            McHelper.serverLog(((CommandSource)context.getSource()).func_197035_h(), str);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"vanilla_chunk_culling_enable").executes(context -> {
            Minecraft.func_71410_x().field_175612_E = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"vanilla_chunk_culling_disable").executes(context -> {
            Minecraft.func_71410_x().field_175612_E = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"render_mode_normal").executes(context -> {
            Global.renderMode = Global.RenderMode.normal;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"render_mode_compatibility").executes(context -> {
            Global.renderMode = Global.RenderMode.compatibility;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"render_mode_debug").executes(context -> {
            Global.renderMode = Global.RenderMode.debug;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"render_mode_none").executes(context -> {
            Global.renderMode = Global.RenderMode.none;
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"report_chunk_loaders").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ChunkVisibilityManager.getChunkLoaders(player).forEach(loader -> McHelper.serverLog(player, loader.toString()));
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"check_light").executes(context -> {
            Minecraft client = Minecraft.func_71410_x();
            client.execute(() -> client.field_71441_e.func_72863_F().func_212863_j_().func_215566_a(SectionPos.func_218167_a((BlockPos)new BlockPos(client.field_71439_g.func_213303_ch())), false));
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"uniform_report_textured").executes(context -> {
            UniformReport.launchUniformReport(new String[]{"gbuffers_textured", "gbuffers_textured_lit"}, s -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(s), true));
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"uniform_report_terrain").executes(context -> {
            UniformReport.launchUniformReport(new String[]{"gbuffers_terrain", "gbuffers_terrain_solid"}, s -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(s), true));
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"uniform_report_shadow").executes(context -> {
            UniformReport.launchUniformReport(new String[]{"shadow_solid", "shadow"}, s -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(s), true));
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"erase_chunk").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ClientDebugCommand.eraseChunk(new ChunkPos(new BlockPos(player.func_213303_ch())), player.field_70170_p, 0, 256);
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"erase_chunk_large").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ChunkPos center = new ChunkPos(new BlockPos(player.func_213303_ch()));
            for (int dx = -4; dx <= 4; ++dx) {
                for (int dz = -4; dz <= 4; ++dz) {
                    ClientDebugCommand.eraseChunk(new ChunkPos(player.field_70176_ah + dx, player.field_70164_aj + dz), player.field_70170_p, 0, 256);
                }
            }
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"erase_chunk_large_middle").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ChunkPos center = new ChunkPos(new BlockPos(player.func_213303_ch()));
            for (int dx = -4; dx <= 4; ++dx) {
                for (int dz = -4; dz <= 4; ++dz) {
                    ClientDebugCommand.eraseChunk(new ChunkPos(player.field_70176_ah + dx, player.field_70164_aj + dz), player.field_70170_p, 64, 128);
                }
            }
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"report_rebuild_status").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            Minecraft.func_71410_x().execute(() -> CGlobal.clientWorldLoader.clientWorldMap.forEach((dim, world) -> {
                MyBuiltChunkStorage builtChunkStorage = (MyBuiltChunkStorage)((IEWorldRenderer)CGlobal.clientWorldLoader.getWorldRenderer((RegistryKey<World>)dim)).getBuiltChunkStorage();
                McHelper.serverLog(player, dim.toString() + builtChunkStorage.getDebugString());
            }));
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"is_altius").executes(context -> {
            boolean altius = AltiusInfo.isAltius();
            if (altius) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("yes"), false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("no"), false);
            }
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"print_generator_config").executes(context -> {
            McHelper.getServer().func_212370_w().forEach(world -> {
                ChunkGenerator generator = world.func_72863_F().func_201711_g();
                Helper.log(world.func_234923_W_().func_240901_a_());
                Helper.log(McHelper.serializeToJson(generator, ChunkGenerator.field_235948_a_));
                Helper.log(McHelper.serializeToJson(world.func_230315_m_(), DimensionType.field_235997_a_.stable()));
            });
            DimensionGeneratorSettings options = McHelper.getServer().func_240793_aU_().func_230418_z_();
            Helper.log(McHelper.serializeToJson(options, DimensionGeneratorSettings.field_236201_a_));
            return 0;
        }));
        builder.then(Commands.func_197057_a((String)"set_profiler_logging_threshold").then(Commands.func_197056_a((String)"ms", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int ms = IntegerArgumentType.getInteger((CommandContext)context, (String)"ms");
            Profiler.field_219907_a = Duration.ofMillis(ms).toNanos();
            return 0;
        })));
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "render_fewer_on_fast_graphic", cond -> {
            CGlobal.renderFewerInFastGraphic = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "gl_check_error", cond -> {
            Global.doCheckGlError = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "smooth_chunk_unload", cond -> {
            CGlobal.smoothChunkUnload = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "early_light_update", cond -> {
            CGlobal.earlyClientLightUpdate = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "super_advanced_frustum_culling", cond -> {
            CGlobal.useSuperAdvancedFrustumCulling = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "teleportation_debug", cond -> {
            Global.teleportationDebugEnabled = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "cross_portal_entity_rendering", cond -> {
            Global.correctCrossPortalEntityRendering = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "loose_visible_chunk_iteration", cond -> {
            Global.looseVisibleChunkIteration = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "portal_placeholder_passthrough", cond -> {
            Global.portalPlaceholderPassthrough = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "early_cull_portal", cond -> {
            CGlobal.earlyFrustumCullingPortal = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "cache_gl_buffer", cond -> {
            Global.cacheGlBuffer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "add_custom_ticket_for_direct_loading_delayed", cond -> {
            NewChunkTrackingGraph.addCustomTicketForDirectLoadingDelayed = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSource>)builder, "server_smooth_loading", cond -> {
            Global.serverSmoothLoading = cond;
        });
        builder.then(Commands.func_197057_a((String)"print_class_path").executes(context -> {
            ClientDebugCommand.printClassPath();
            return 0;
        }));
        dispatcher.register(builder);
        Helper.log("Successfully initialized command /immersive_portals_debug");
    }

    public static void eraseChunk(ChunkPos chunkPos, World world, int yStart, int yEnd) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = yStart; y < yEnd; ++y) {
                    world.func_175656_a(new BlockPos(chunkPos.func_180334_c() + x, y, chunkPos.func_180333_d() + z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private static void printClassPath() {
        System.out.println(Arrays.stream(((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()).map(url -> "\"" + url.getFile().substring(1).replace("%20", " ") + "\"").collect(Collectors.joining(",\n")));
    }

    private static void registerSwitchCommand(LiteralArgumentBuilder<CommandSource> builder, String name, Consumer<Boolean> setFunction) {
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)(name + "_enable")).executes(context -> {
            setFunction.accept(true);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)(name + "_disable")).executes(context -> {
            setFunction.accept(false);
            return 0;
        }));
    }

    private static int reportResourceConsumption(CommandContext<CommandSource> context) throws CommandSyntaxException {
        StringBuilder str = new StringBuilder();
        str.append("Client Chunk:\n");
        CGlobal.clientWorldLoader.clientWorldMap.values().forEach(world -> str.append(String.format("%s %s\n", world.func_234923_W_(), ((MyClientChunkManager)world.func_72863_F()).func_217252_g())));
        str.append("Chunk Renderers:\n");
        CGlobal.clientWorldLoader.worldRendererMap.forEach((dimension, worldRenderer) -> str.append(String.format("%s %s\n", dimension, ((MyBuiltChunkStorage)((IEWorldRenderer)worldRenderer).getBuiltChunkStorage()).getManagedChunkNum())));
        str.append("Server Chunks:\n");
        McHelper.getServer().func_212370_w().forEach(world -> str.append(String.format("%s %s\n", world.func_234923_W_(), NewChunkTrackingGraph.getLoadedChunkNum((RegistryKey<World>)world.func_234923_W_()))));
        String result = str.toString();
        Helper.log(str);
        ((CommandSource)context.getSource()).func_197035_h().func_146105_b((ITextComponent)new StringTextComponent(result), false);
        return 0;
    }

    private static int isClientChunkLoaded(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int chunkX = IntegerArgumentType.getInteger(context, (String)"chunkX");
        int chunkZ = IntegerArgumentType.getInteger(context, (String)"chunkZ");
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(chunkX, chunkZ);
        McHelper.serverLog(((CommandSource)context.getSource()).func_197035_h(), chunk != null && !(chunk instanceof EmptyChunk) ? "yes" : "no");
        return 0;
    }

    private static int setMaxPortalLayer(int m) {
        Global.maxPortalLayer = m;
        return 0;
    }

    private static int listPortals(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity playerServer = ((CommandSource)context.getSource()).func_197035_h();
        ClientPlayerEntity playerClient = Minecraft.func_71410_x().field_71439_g;
        StringBuilder result = new StringBuilder();
        result.append("Server Portals\n");
        playerServer.func_184102_h().func_212370_w().forEach(world -> {
            result.append(world.func_234923_W_().func_240901_a_().toString() + "\n");
            for (Entity e : world.func_241136_z_()) {
                if (!(e instanceof Portal)) continue;
                result.append(e.toString());
                result.append("\n");
            }
        });
        result.append("Client Portals\n");
        CGlobal.clientWorldLoader.clientWorldMap.forEach((dim, world) -> {
            result.append(world.func_234923_W_().func_240901_a_().toString() + "\n");
            for (Entity e : world.func_217416_b()) {
                if (!(e instanceof Portal)) continue;
                result.append(e.toString());
                result.append("\n");
            }
        });
        McHelper.serverLog(playerServer, result.toString());
        return 0;
    }

    private static int addPortal(CommandContext<CommandSource> context) {
        try {
            addPortalFunctionality.accept(((CommandSource)context.getSource()).func_197035_h());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int reportPlayerStatus(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity playerMP = ((CommandSource)context.getSource()).func_197035_h();
        ClientPlayerEntity playerSP = Minecraft.func_71410_x().field_71439_g;
        McHelper.serverLog(playerMP, String.format("On Server %s %s removed:%s added:%s age:%s", playerMP.field_70170_p.func_234923_W_(), playerMP.func_213303_ch(), playerMP.field_70128_L, playerMP.field_70170_p.func_73045_a(playerMP.func_145782_y()) != null, playerMP.field_70173_aa));
        McHelper.serverLog(playerMP, String.format("On Client %s %s removed:%s added:%s age:%s", playerSP.field_70170_p.func_234923_W_(), playerSP.func_213303_ch(), playerMP.field_70128_L, playerMP.field_70170_p.func_73045_a(playerMP.func_145782_y()) != null, playerMP.field_70173_aa));
        return 0;
    }
}

