/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.chunk_loading.ChunkVisibilityManager;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldInfoSender {
    public static void init() {
        ModMain.postServerTickSignal.connect(() -> {
            if (McHelper.getServerGameTime() % 100L == 42L) {
                for (ServerPlayerEntity player : McHelper.getCopiedPlayerList()) {
                    Set<RegistryKey<World>> visibleDimensions = WorldInfoSender.getVisibleDimensions(player);
                    if (player.field_70170_p.func_234923_W_() != World.field_234918_g_) {
                        WorldInfoSender.sendWorldInfo(player, McHelper.getServer().func_71218_a(World.field_234918_g_));
                    }
                    McHelper.getServer().func_212370_w().forEach(thisWorld -> {
                        if (ModMain.isAlternateDimension((World)thisWorld) && visibleDimensions.contains(thisWorld.func_234923_W_())) {
                            WorldInfoSender.sendWorldInfo(player, thisWorld);
                        }
                    });
                }
            }
        });
    }

    public static void sendWorldInfo(ServerPlayerEntity player, ServerWorld world) {
        RegistryKey remoteDimension = world.func_234923_W_();
        player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)remoteDimension, (IPacket)new SUpdateTimePacket(world.func_82737_E(), world.func_72820_D(), world.func_82736_K().func_223586_b(GameRules.field_223607_j))));
        if (world.func_72896_J()) {
            player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)world.func_234923_W_(), (IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f)));
            player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)world.func_234923_W_(), (IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, world.func_72867_j(1.0f))));
            player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)world.func_234923_W_(), (IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, world.func_72819_i(1.0f))));
        }
    }

    public static Set<RegistryKey<World>> getVisibleDimensions(ServerPlayerEntity player) {
        return Stream.concat(ChunkVisibilityManager.getChunkLoaders(player).map(chunkLoader -> chunkLoader.center.dimension), Optional.of(McHelper.getGlobalPortals(player.field_70170_p)).map(p -> p.stream().map(p1 -> p1.dimensionTo)).orElse(Stream.empty())).collect(Collectors.toSet());
    }
}

