/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.chunk_loading.ChunkVisibilityManager;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.chunk_loading.MyLoadingTicket;
import com.qouteall.immersive_portals.my_util.SignalBiArged;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NewChunkTrackingGraph {
    public static final int updateInterval = 40;
    public static boolean addCustomTicketForDirectLoadingDelayed = true;
    private static final Map<RegistryKey<World>, Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>>> data = new HashMap<RegistryKey<World>, Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>>>();
    private static final ArrayList<WeakReference<ChunkVisibilityManager.ChunkLoader>> additionalChunkLoaders = new ArrayList();
    public static final SignalBiArged<ServerPlayerEntity, DimensionalChunkPos> beginWatchChunkSignal = new SignalBiArged();
    public static final SignalBiArged<ServerPlayerEntity, DimensionalChunkPos> endWatchChunkSignal = new SignalBiArged();

    private static void updateWatchingStatus(ArrayList<PlayerWatchRecord> records, ServerPlayerEntity player, long currGameTime, int distanceToSource, boolean isDirectLoading, Runnable addWatchInformer) {
        int i = Helper.indexOf(records, r -> r.player == player);
        if (i == -1) {
            records.add(new PlayerWatchRecord(player, currGameTime, distanceToSource, isDirectLoading));
            addWatchInformer.run();
        } else {
            PlayerWatchRecord record = records.get(i);
            if (record.lastWatchTime == currGameTime) {
                int newDistance;
                int oldDistance = record.distanceToSource;
                record.distanceToSource = newDistance = Math.min(oldDistance, distanceToSource);
                record.isDirectLoading = isDirectLoading;
            } else {
                record.distanceToSource = distanceToSource;
                record.lastWatchTime = currGameTime;
                record.isDirectLoading |= isDirectLoading;
            }
        }
    }

    private static void removeInactiveWatchers(ArrayList<PlayerWatchRecord> records, Predicate<PlayerWatchRecord> predicate, Consumer<ServerPlayerEntity> informer) {
        records.removeIf(r -> {
            boolean shouldRemove = predicate.test((PlayerWatchRecord)r);
            if (shouldRemove) {
                informer.accept(r.player);
            }
            return shouldRemove;
        });
    }

    private static boolean isBeingWatchedByAnyPlayer(ArrayList<PlayerWatchRecord> records) {
        return !records.isEmpty();
    }

    private static boolean shouldAddCustomTicket(ServerWorld world, long chunkPos, ArrayList<PlayerWatchRecord> records) {
        boolean isIndirectLoading = Helper.indexOf(records, r -> !r.isDirectLoading) != -1;
        return isIndirectLoading;
    }

    private static Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> getChunkRecordMap(RegistryKey<World> dimension) {
        return data.computeIfAbsent(dimension, k -> new Long2ObjectLinkedOpenHashMap());
    }

    public static void updateForPlayer(ServerPlayerEntity player) {
        long gameTime = McHelper.getOverWorldOnServer().func_82737_E();
        ChunkVisibilityManager.getChunkLoaders(player).forEach(chunkLoader -> chunkLoader.foreachChunkPos((dimension, x, z, distanceToSource) -> {
            ArrayList records = (ArrayList)NewChunkTrackingGraph.getChunkRecordMap((RegistryKey<World>)dimension).computeIfAbsent(ChunkPos.func_77272_a((int)x, (int)z), k -> new ArrayList());
            NewChunkTrackingGraph.updateWatchingStatus(records, player, gameTime, distanceToSource, chunkLoader.isDirectLoader, () -> beginWatchChunkSignal.emit(player, new DimensionalChunkPos((RegistryKey<World>)dimension, x, z)));
        }));
    }

    private static void updateAndPurge() {
        long unloadTimeValve = NewChunkTrackingGraph.getUnloadTimeValve();
        long currTime = McHelper.getOverWorldOnServer().func_82737_E();
        data.forEach((dimension, chunkRecords) -> chunkRecords.long2ObjectEntrySet().removeIf(entry -> {
            long chunkPosLong = entry.getLongKey();
            ArrayList records = (ArrayList)entry.getValue();
            NewChunkTrackingGraph.removeInactiveWatchers(records, r -> currTime - r.lastWatchTime > unloadTimeValve || r.player.field_70128_L, player -> {
                if (player.field_70128_L) {
                    return;
                }
                endWatchChunkSignal.emit((ServerPlayerEntity)player, new DimensionalChunkPos((RegistryKey<World>)dimension, ChunkPos.func_212578_a((long)chunkPosLong), ChunkPos.func_212579_b((long)chunkPosLong)));
            });
            return !NewChunkTrackingGraph.isBeingWatchedByAnyPlayer(records);
        }));
        McHelper.getServer().func_212370_w().forEach(world -> {
            Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> chunkRecordMap = NewChunkTrackingGraph.getChunkRecordMap((RegistryKey<World>)world.func_234923_W_());
            chunkRecordMap.long2ObjectEntrySet().forEach(entry -> {
                ArrayList records;
                long longChunkPos = entry.getLongKey();
                if (NewChunkTrackingGraph.shouldAddCustomTicket(world, longChunkPos, records = (ArrayList)entry.getValue())) {
                    MyLoadingTicket.addTicketIfNotLoaded(world, new ChunkPos(longChunkPos));
                }
            });
            LongLinkedOpenHashSet additionalLoadedChunks = new LongLinkedOpenHashSet();
            additionalChunkLoaders.forEach((Consumer<WeakReference<ChunkVisibilityManager.ChunkLoader>>)((Consumer<WeakReference>)arg_0 -> NewChunkTrackingGraph.lambda$null$14(world, (LongSortedSet)additionalLoadedChunks, arg_0)));
            additionalChunkLoaders.removeIf(ref -> ref.get() == null);
            LongArrayList chunksToUnload = new LongArrayList();
            MyLoadingTicket.getRecord(world).forEach(arg_0 -> NewChunkTrackingGraph.lambda$null$16(chunkRecordMap, (LongSortedSet)additionalLoadedChunks, (LongList)chunksToUnload, arg_0));
            chunksToUnload.forEach(longChunkPos -> MyLoadingTicket.removeTicket(world, new ChunkPos(longChunkPos)));
        });
    }

    private static long getUnloadTimeValve() {
        return 300L;
    }

    private static void tick() {
        McHelper.getServer().func_213185_aS().func_76320_a("portal_chunk_tracking");
        long gameTime = McHelper.getOverWorldOnServer().func_82737_E();
        McHelper.getCopiedPlayerList().forEach(player -> {
            if ((long)(player.func_145782_y() % 40) == gameTime % 40L) {
                NewChunkTrackingGraph.updateForPlayer(player);
            }
        });
        if (gameTime % 40L == 0L) {
            NewChunkTrackingGraph.updateAndPurge();
        }
        McHelper.getServer().func_213185_aS().func_76319_b();
    }

    private static void setIsLoadedByPortal(RegistryKey<World> dimension, ChunkPos chunkPos, boolean isLoadedNow) {
        ServerWorld world = McHelper.getServer().func_71218_a(dimension);
        world.func_217458_b(chunkPos.field_77276_a, chunkPos.field_77275_b, isLoadedNow);
    }

    public static void init() {
        ModMain.postServerTickSignal.connect(NewChunkTrackingGraph::tick);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayerEntity player, RegistryKey<World> dimension, int x, int z, Predicate<PlayerWatchRecord> predicate) {
        ArrayList record = (ArrayList)NewChunkTrackingGraph.getChunkRecordMap(dimension).get(ChunkPos.func_77272_a((int)x, (int)z));
        if (record == null) {
            return false;
        }
        int i = Helper.indexOf(record, r -> r.player == player);
        if (i == -1) {
            return false;
        }
        return predicate.test((PlayerWatchRecord)record.get(i));
    }

    public static boolean isPlayerWatchingChunk(ServerPlayerEntity player, RegistryKey<World> dimension, int x, int z) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> true);
    }

    public static boolean isPlayerWatchingChunkWithinRaidus(ServerPlayerEntity player, RegistryKey<World> dimension, int x, int z, int radiusBlocks) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> r.distanceToSource * 16 <= radiusBlocks);
    }

    public static void cleanup() {
        data.clear();
        additionalChunkLoaders.clear();
    }

    public static Stream<ServerPlayerEntity> getPlayersViewingChunk(RegistryKey<World> dimension, int x, int z) {
        ArrayList records = (ArrayList)NewChunkTrackingGraph.getChunkRecordMap(dimension).get(ChunkPos.func_77272_a((int)x, (int)z));
        if (records == null) {
            return Stream.empty();
        }
        return records.stream().map(r -> r.player);
    }

    public static Stream<ServerPlayerEntity> getFarWatchers(RegistryKey<World> dimension, int x, int z) {
        return NewChunkTrackingGraph.getPlayersViewingChunk(dimension, x, z).filter(player -> player.field_70170_p.func_234923_W_() != dimension || Helper.getChebyshevDistance(x, z, player.field_70176_ah, player.field_70164_aj) > 4);
    }

    public static void forceRemovePlayer(ServerPlayerEntity player) {
        data.forEach((dim, map) -> map.forEach((chunkPos, records) -> NewChunkTrackingGraph.removeInactiveWatchers(records, r -> r.player == player, p -> p.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)dim, (IPacket)new SUnloadChunkPacket(ChunkPos.func_212578_a((long)chunkPos), ChunkPos.func_212579_b((long)chunkPos)))))));
    }

    public static boolean shouldLoadDimension(RegistryKey<World> dimension) {
        if (!data.containsKey(dimension)) {
            return false;
        }
        Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> map = data.get(dimension);
        return !map.isEmpty();
    }

    public static void addAdditionalChunkLoader(ChunkVisibilityManager.ChunkLoader chunkLoader) {
        additionalChunkLoaders.add(new WeakReference<ChunkVisibilityManager.ChunkLoader>(chunkLoader));
        NewChunkTrackingGraph.updateAndPurge();
    }

    public static void removeAdditionalChunkLoader(ChunkVisibilityManager.ChunkLoader chunkLoader) {
        additionalChunkLoaders.removeIf(weakRef -> weakRef.get() == chunkLoader);
    }

    public static void addAdditionalDirectTickets(ServerPlayerEntity player) {
        ChunkVisibilityManager.playerDirectLoader(player).foreachChunkPos((dim, x, z, dis) -> {
            if (NewChunkTrackingGraph.isPlayerWatchingChunk(player, (RegistryKey<World>)dim, x, z)) {
                MyLoadingTicket.addTicketIfNotLoaded((ServerWorld)player.field_70170_p, new ChunkPos(x, z));
            }
        });
    }

    public static int getLoadedChunkNum(RegistryKey<World> dimension) {
        return NewChunkTrackingGraph.getChunkRecordMap(dimension).size();
    }

    private static /* synthetic */ void lambda$null$16(Long2ObjectLinkedOpenHashMap chunkRecordMap, LongSortedSet additionalLoadedChunks, LongList chunksToUnload, long longChunkPos) {
        if (!chunkRecordMap.containsKey(longChunkPos) && !additionalLoadedChunks.contains(longChunkPos)) {
            chunksToUnload.add(longChunkPos);
        }
    }

    private static /* synthetic */ void lambda$null$14(ServerWorld world, LongSortedSet additionalLoadedChunks, WeakReference weakRef) {
        ChunkVisibilityManager.ChunkLoader loader = (ChunkVisibilityManager.ChunkLoader)weakRef.get();
        if (loader == null) {
            return;
        }
        loader.foreachChunkPos((dim, x, z, dis) -> {
            if (world.func_234923_W_() == dim) {
                additionalLoadedChunks.add(ChunkPos.func_77272_a((int)x, (int)z));
                MyLoadingTicket.addTicketIfNotLoaded(world, new ChunkPos(x, z));
            }
        });
    }

    public static class PlayerWatchRecord {
        public ServerPlayerEntity player;
        public long lastWatchTime;
        public int distanceToSource;
        public boolean isDirectLoading;

        public PlayerWatchRecord(ServerPlayerEntity player, long lastWatchTime, int distanceToSource, boolean isDirectLoading) {
            this.player = player;
            this.lastWatchTime = lastWatchTime;
            this.distanceToSource = distanceToSource;
            this.isDirectLoading = isDirectLoading;
        }
    }
}

