/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.ducks.IEChunkTicketManager;
import com.qouteall.immersive_portals.ducks.IEServerChunkManager;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Comparator;
import java.util.WeakHashMap;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;

public class MyLoadingTicket {
    public static final TicketType<ChunkPos> ticketType = TicketType.func_219484_a((String)"imm_ptl", Comparator.comparingLong(ChunkPos::func_201841_a));
    public static final WeakHashMap<ServerWorld, LongSortedSet> loadedChunkRecord = new WeakHashMap();

    private static TicketManager getTicketManager(ServerWorld world) {
        return ((IEServerChunkManager)world.func_72863_F()).getTicketManager();
    }

    private static boolean hasOtherChunkTicket(ServerWorld world, ChunkPos chunkPos) {
        SortedArraySet<Ticket<?>> chunkTickets = ((IEChunkTicketManager)MyLoadingTicket.getTicketManager(world)).portal_getTicketSet(chunkPos.func_201841_a());
        return chunkTickets.stream().anyMatch(t -> t.func_219479_a() != ticketType);
    }

    public static void addTicketIfNotLoaded(ServerWorld world, ChunkPos chunkPos) {
        boolean isNewlyAdded = MyLoadingTicket.getRecord(world).add(chunkPos.func_201841_a());
        if (isNewlyAdded) {
            MyLoadingTicket.getTicketManager(world).func_219331_c(ticketType, chunkPos, MyLoadingTicket.getLoadingRadius(), (Object)chunkPos);
        }
    }

    public static void removeTicket(ServerWorld world, ChunkPos chunkPos) {
        boolean isNewlyRemoved = MyLoadingTicket.getRecord(world).remove(chunkPos.func_201841_a());
        if (isNewlyRemoved) {
            MyLoadingTicket.getTicketManager(world).func_219362_d(ticketType, chunkPos, MyLoadingTicket.getLoadingRadius(), (Object)chunkPos);
        }
    }

    public static int getLoadingRadius() {
        if (Global.activeLoading) {
            return 2;
        }
        return 1;
    }

    public static LongSortedSet getRecord(ServerWorld world) {
        return loadedChunkRecord.computeIfAbsent(world, k -> new LongLinkedOpenHashSet());
    }
}

