/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.render.context_management.RenderDimensionRedirect;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MyClientChunkManager
extends ClientChunkProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Chunk emptyChunk;
    protected final WorldLightManager lightingProvider;
    protected final ClientWorld field_73235_d;
    protected final Long2ObjectLinkedOpenHashMap<Chunk> chunkMap = new Long2ObjectLinkedOpenHashMap();

    public MyClientChunkManager(ClientWorld clientWorld, int loadDistance) {
        super(clientWorld, loadDistance);
        this.field_73235_d = clientWorld;
        this.emptyChunk = new EmptyChunk((World)clientWorld, new ChunkPos(0, 0));
        this.lightingProvider = new WorldLightManager((IChunkLightProvider)this, true, RenderDimensionRedirect.hasSkylight(clientWorld));
    }

    public WorldLightManager func_212863_j_() {
        return this.lightingProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73234_b(int int_1, int int_2) {
        Long2ObjectLinkedOpenHashMap<Chunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            ChunkPos chunkPos = new ChunkPos(int_1, int_2);
            Chunk worldChunk_1 = (Chunk)this.chunkMap.get(chunkPos.func_201841_a());
            if (MyClientChunkManager.positionEquals(worldChunk_1, int_1, int_2)) {
                this.chunkMap.remove(chunkPos.func_201841_a());
                O_O.postChunkUnloadEventForge(worldChunk_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_212849_a_(int int_1, int int_2, ChunkStatus chunkStatus_1, boolean boolean_1) {
        Long2ObjectLinkedOpenHashMap<Chunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            Chunk worldChunk_1 = (Chunk)this.chunkMap.get(ChunkPos.func_77272_a((int)int_1, (int)int_2));
            if (MyClientChunkManager.positionEquals(worldChunk_1, int_1, int_2)) {
                return worldChunk_1;
            }
            return boolean_1 ? this.emptyChunk : null;
        }
    }

    public IBlockReader func_212864_k_() {
        return this.field_73235_d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_228313_a_(int x, int z, BiomeContainer biomeArray, PacketBuffer packetByteBuf, CompoundNBT compoundTag, int k, boolean bl) {
        Chunk worldChunk;
        long chunkPosLong = ChunkPos.func_77272_a((int)x, (int)z);
        Long2ObjectLinkedOpenHashMap<Chunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            worldChunk = (Chunk)this.chunkMap.get(chunkPosLong);
            if (!bl && MyClientChunkManager.positionEquals(worldChunk, x, z)) {
                worldChunk.func_227073_a_(biomeArray, packetByteBuf, compoundTag, k);
            } else {
                if (biomeArray == null) {
                    LOGGER.error("Missing Biome Array: {} {} {} Client Biome May be Incorrect", (Object)this.field_73235_d.func_234923_W_().func_240901_a_(), (Object)x, (Object)z);
                    throw new RuntimeException("Null biome array");
                }
                worldChunk = new Chunk((World)this.field_73235_d, new ChunkPos(x, z), biomeArray);
                worldChunk.func_227073_a_(biomeArray, packetByteBuf, compoundTag, k);
                this.chunkMap.put(chunkPosLong, (Object)worldChunk);
            }
        }
        ChunkSection[] chunkSections = worldChunk.func_76587_i();
        WorldLightManager lightingProvider = this.func_212863_j_();
        lightingProvider.func_215571_a(new ChunkPos(x, z), true);
        for (int m = 0; m < chunkSections.length; ++m) {
            ChunkSection chunkSection = chunkSections[m];
            lightingProvider.func_215566_a(SectionPos.func_218154_a((int)x, (int)m, (int)z), ChunkSection.func_222628_a((ChunkSection)chunkSection));
        }
        this.field_73235_d.func_228323_e_(x, z);
        O_O.postChunkLoadEventForge(worldChunk);
        return worldChunk;
    }

    public static void updateLightStatus(Chunk chunk) {
        ChunkSection[] chunkSections_1 = chunk.func_76587_i();
        WorldLightManager lightingProvider = chunk.func_177412_p().func_225524_e_();
        for (int int_5 = 0; int_5 < chunkSections_1.length; ++int_5) {
            ChunkSection chunkSection_1 = chunkSections_1[int_5];
            lightingProvider.func_215566_a(SectionPos.func_218154_a((int)chunk.func_76632_l().field_77276_a, (int)int_5, (int)chunk.func_76632_l().field_77275_b), ChunkSection.func_222628_a((ChunkSection)chunkSection_1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Chunk> getCopiedChunkList() {
        Long2ObjectLinkedOpenHashMap<Chunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            return Arrays.asList(this.chunkMap.values().toArray((Object[])new Chunk[0]));
        }
    }

    public void func_217251_d(int int_1, int int_2) {
    }

    public void func_217248_a(int int_1) {
    }

    public String func_73148_d() {
        return "Client Chunks (ImmPtl) " + this.func_217252_g();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_217252_g() {
        Long2ObjectLinkedOpenHashMap<Chunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            return this.chunkMap.size();
        }
    }

    public void func_217201_a(LightType lightType_1, SectionPos chunkSectionPos_1) {
        CGlobal.clientWorldLoader.getWorldRenderer((RegistryKey<World>)this.field_73235_d.func_234923_W_()).func_215328_b(chunkSectionPos_1.func_218149_a(), chunkSectionPos_1.func_218163_b(), chunkSectionPos_1.func_218148_c());
    }

    public boolean func_222866_a(BlockPos blockPos_1) {
        return this.func_73149_a(blockPos_1.func_177958_n() >> 4, blockPos_1.func_177952_p() >> 4);
    }

    public boolean func_222865_a(ChunkPos chunkPos_1) {
        return this.func_73149_a(chunkPos_1.field_77276_a, chunkPos_1.field_77275_b);
    }

    public boolean func_217204_a(Entity entity_1) {
        return this.func_73149_a(MathHelper.func_76128_c((double)entity_1.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entity_1.func_226281_cx_()) >> 4);
    }

    protected static boolean positionEquals(Chunk worldChunk_1, int int_1, int int_2) {
        if (worldChunk_1 == null) {
            return false;
        }
        ChunkPos chunkPos_1 = worldChunk_1.func_76632_l();
        return chunkPos_1.field_77276_a == int_1 && chunkPos_1.field_77275_b == int_2;
    }
}

