/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ducks.IEEntityTracker;
import com.qouteall.immersive_portals.ducks.IEThreadedAnvilChunkStorage;
import com.qouteall.immersive_portals.my_util.LimitedLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;

public class EntitySync {
    private static final LimitedLogger limitedLogger = new LimitedLogger(100);
    @Nullable
    private static RegistryKey<World> forceRedirect = null;

    public static void init() {
        ModMain.postServerTickSignal.connect(EntitySync::tick);
    }

    private static void tick() {
        MinecraftServer server = McHelper.getServer();
        server.func_213185_aS().func_76320_a("ip_entity_tracking");
        List<ServerPlayerEntity> playerList = McHelper.getRawPlayerList();
        ArrayList<ServerPlayerEntity> dirtyPlayers = new ArrayList<ServerPlayerEntity>();
        for (ServerPlayerEntity player : playerList) {
            ChunkManager storage = ((ServerWorld)player.field_70170_p).func_72863_F().field_217237_a;
            Int2ObjectMap<ChunkManager.EntityTracker> entityTrackerMap = ((IEThreadedAnvilChunkStorage)storage).getEntityTrackerMap();
            ChunkManager.EntityTracker playerItselfTracker = (ChunkManager.EntityTracker)entityTrackerMap.get(player.func_145782_y());
            if (playerItselfTracker == null || !EntitySync.isDirty(playerItselfTracker)) continue;
            dirtyPlayers.add(player);
        }
        server.func_212370_w().forEach(world -> {
            ChunkManager storage = world.func_72863_F().field_217237_a;
            Int2ObjectMap<ChunkManager.EntityTracker> entityTrackerMap = ((IEThreadedAnvilChunkStorage)storage).getEntityTrackerMap();
            EntitySync.withForceRedirect((RegistryKey<World>)world.func_234923_W_(), () -> {
                for (ChunkManager.EntityTracker tracker : entityTrackerMap.values()) {
                    ((IEEntityTracker)tracker).tickEntry();
                    boolean dirty = EntitySync.isDirty(tracker);
                    List updatedPlayerList = dirty ? playerList : dirtyPlayers;
                    for (ServerPlayerEntity player : updatedPlayerList) {
                        ((IEEntityTracker)tracker).updateEntityTrackingStatus(player);
                    }
                    if (!dirty) continue;
                    EntitySync.markUnDirty(tracker);
                }
            });
        });
        server.func_213185_aS().func_76319_b();
    }

    private static boolean isDirty(ChunkManager.EntityTracker tracker) {
        SectionPos newPos = SectionPos.func_218157_a((Entity)((IEEntityTracker)tracker).getEntity_());
        return !((IEEntityTracker)tracker).getLastCameraPosition().equals((Object)newPos);
    }

    private static void markUnDirty(ChunkManager.EntityTracker tracker) {
        SectionPos currPos = SectionPos.func_218157_a((Entity)((IEEntityTracker)tracker).getEntity_());
        ((IEEntityTracker)tracker).setLastCameraPosition(currPos);
    }

    public static void withForceRedirect(RegistryKey<World> dimension, Runnable func) {
        RegistryKey<World> oldForceRedirect = forceRedirect;
        forceRedirect = dimension;
        func.run();
        forceRedirect = oldForceRedirect;
    }

    @Nullable
    public static RegistryKey<World> getForceRedirectDimension() {
        return forceRedirect;
    }

    public static void sendRedirectedPacket(ServerPlayNetHandler serverPlayNetworkHandler, IPacket<?> packet, RegistryKey<World> dimension) {
        if (EntitySync.getForceRedirectDimension() == dimension) {
            serverPlayNetworkHandler.func_147359_a(packet);
        } else {
            serverPlayNetworkHandler.func_147359_a(MyNetwork.createRedirectedMessage(dimension, packet));
        }
    }
}

