/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.google.common.collect.Streams;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;

public class ChunkVisibilityManager {
    private static final int portalLoadingRange = 48;
    public static final int secondaryPortalLoadingRange = 16;

    public static ChunkLoader playerDirectLoader(ServerPlayerEntity player) {
        return new ChunkLoader(new DimensionalChunkPos((RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.field_70176_ah, player.field_70164_aj), McHelper.getRenderDistanceOnServer(), true);
    }

    private static int getDirectLoadingDistance(int renderDistance, double distanceToPortal) {
        if (Global.loadFewerChunks) {
            return 1;
        }
        if (distanceToPortal < 5.0) {
            return renderDistance;
        }
        if (distanceToPortal < 15.0) {
            return renderDistance * 2 / 3;
        }
        return renderDistance / 3;
    }

    private static int getSmoothedLoadingDistance(Portal portal, ServerPlayerEntity player, int targetLoadingDistance) {
        int cappedLoadingDistance = Math.min(targetLoadingDistance, Global.indirectLoadingRadiusCap);
        if (!Global.serverSmoothLoading) {
            return cappedLoadingDistance;
        }
        int maxLoadDistance = portal.extension.refreshAndGetLoadDistanceCap(portal, player, cappedLoadingDistance);
        return Math.min(maxLoadDistance, cappedLoadingDistance);
    }

    private static ChunkLoader portalDirectLoader(Portal portal, ServerPlayerEntity player) {
        int renderDistance = McHelper.getRenderDistanceOnServer();
        double distance = portal.getDistanceToNearestPointInPortal(player.func_213303_ch());
        return new ChunkLoader(new DimensionalChunkPos(portal.dimensionTo, new ChunkPos(new BlockPos(portal.destination))), ChunkVisibilityManager.getSmoothedLoadingDistance(portal, player, ChunkVisibilityManager.getDirectLoadingDistance(renderDistance, distance)));
    }

    private static ChunkLoader portalIndirectLoader(Portal portal, ServerPlayerEntity player) {
        int renderDistance = McHelper.getRenderDistanceOnServer();
        return new ChunkLoader(new DimensionalChunkPos(portal.dimensionTo, new ChunkPos(new BlockPos(portal.destination))), ChunkVisibilityManager.getSmoothedLoadingDistance(portal, player, renderDistance / 4));
    }

    private static ChunkLoader globalPortalDirectLoader(ServerPlayerEntity player, GlobalTrackedPortal portal) {
        int renderDistance = Math.max(2, McHelper.getRenderDistanceOnServer() - Math.floorDiv((int)portal.getDistanceToNearestPointInPortal(player.func_213303_ch()), 16));
        return new ChunkLoader(new DimensionalChunkPos((RegistryKey<World>)portal.dimensionTo, new ChunkPos(new BlockPos(portal.transformPointRough(player.func_213303_ch())))), renderDistance);
    }

    private static ChunkLoader globalPortalIndirectLoader(ServerPlayerEntity player, GlobalTrackedPortal outerPortal, GlobalTrackedPortal remotePortal) {
        int renderDistance = McHelper.getRenderDistanceOnServer() / 2;
        return new ChunkLoader(new DimensionalChunkPos((RegistryKey<World>)remotePortal.dimensionTo, new ChunkPos(new BlockPos(remotePortal.transformPointRough(outerPortal.transformPointRough(player.func_213303_ch()))))), renderDistance);
    }

    private static Stream<GlobalTrackedPortal> getGlobalPortals(RegistryKey<World> dimension) {
        List<GlobalTrackedPortal> data = GlobalPortalStorage.get((ServerWorld)McHelper.getServer().func_71218_a(dimension)).data;
        if (data == null) {
            return Stream.empty();
        }
        return data.stream();
    }

    public static Stream<ChunkLoader> getChunkLoaders(ServerPlayerEntity player) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(ChunkVisibilityManager.playerDirectLoader(player)), McHelper.getServerEntitiesNearbyWithoutLoadingChunk(player.field_70170_p, player.func_213303_ch(), Portal.class, Global.loadFewerChunks ? 24.0 : 48.0).filter(portal -> portal.func_174827_a(player)).flatMap(portal -> Stream.concat(Stream.of(ChunkVisibilityManager.portalDirectLoader(portal, player)), Global.loadFewerChunks ? Stream.empty() : McHelper.getServerEntitiesNearbyWithoutLoadingChunk((World)McHelper.getServer().func_71218_a(portal.dimensionTo), portal.destination, Portal.class, 16.0).filter(remotePortal -> remotePortal.func_174827_a(player)).map(remotePortal -> ChunkVisibilityManager.portalIndirectLoader(remotePortal, player)))), ChunkVisibilityManager.getGlobalPortals((RegistryKey<World>)player.field_70170_p.func_234923_W_()).flatMap(portal -> Stream.concat(Stream.of(ChunkVisibilityManager.globalPortalDirectLoader(player, portal)), Global.loadFewerChunks ? Stream.empty() : ChunkVisibilityManager.getGlobalPortals((RegistryKey<World>)portal.dimensionTo).filter(remotePortal -> remotePortal.getDistanceToNearestPointInPortal(portal.transformPointRough(player.func_213303_ch())) < (double)(Global.loadFewerChunks ? 24 : 48)).map(remotePortal -> ChunkVisibilityManager.globalPortalIndirectLoader(player, portal, remotePortal))))}).distinct();
    }

    public static class ChunkLoader {
        public DimensionalChunkPos center;
        public int radius;
        public boolean isDirectLoader = false;

        public ChunkLoader(DimensionalChunkPos center, int radius) {
            this(center, radius, false);
        }

        public ChunkLoader(DimensionalChunkPos center, int radius, boolean isDirectLoader) {
            this.center = center;
            this.radius = radius;
            this.isDirectLoader = isDirectLoader;
        }

        public void foreachChunkPos(ChunkPosConsumer func) {
            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                for (int dz = -this.radius; dz <= this.radius; ++dz) {
                    func.consume(this.center.dimension, this.center.x + dx, this.center.z + dz, Math.max(Math.abs(dx), Math.abs(dz)));
                }
            }
        }

        public WorldGenRegion createChunkRegion() {
            ServerWorld world = McHelper.getServer().func_71218_a(this.center.dimension);
            int width = this.radius * 2 + 1;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            for (int z = this.center.z - this.radius; z <= this.center.z + this.radius; ++z) {
                for (int x = this.center.x - this.radius; x <= this.center.x + this.radius; ++x) {
                    chunks.add(world.func_212866_a_(x, z));
                }
            }
            return new WorldGenRegion(world, chunks);
        }

        public String toString() {
            return "{center=" + this.center + ", radius=" + this.radius + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkLoader that = (ChunkLoader)o;
            return this.radius == that.radius && this.center.equals(that.center);
        }

        public int hashCode() {
            return Objects.hash(this.center, this.radius);
        }
    }

    public static interface ChunkPosConsumer {
        public void consume(RegistryKey<World> var1, int var2, int var3, int var4);
    }
}

