/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.chunk_loading;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.ducks.IEThreadedAnvilChunkStorage;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;

public class ChunkDataSyncManager {
    private static final int unloadWaitingTickTime = 200;

    public ChunkDataSyncManager() {
        NewChunkTrackingGraph.beginWatchChunkSignal.connectWithWeakRef(this, ChunkDataSyncManager::onBeginWatch);
        NewChunkTrackingGraph.endWatchChunkSignal.connectWithWeakRef(this, ChunkDataSyncManager::onEndWatch);
    }

    private void onBeginWatch(ServerPlayerEntity player, DimensionalChunkPos chunkPos) {
        McHelper.getServer().func_213185_aS().func_76320_a("begin_watch");
        IEThreadedAnvilChunkStorage ieStorage = McHelper.getIEStorage(chunkPos.dimension);
        this.sendChunkDataPacketNow(player, chunkPos, ieStorage);
        McHelper.getServer().func_213185_aS().func_76319_b();
    }

    private void sendChunkDataPacketNow(ServerPlayerEntity player, DimensionalChunkPos chunkPos, IEThreadedAnvilChunkStorage ieStorage) {
        Chunk chunk;
        ChunkHolder chunkHolder = ieStorage.getChunkHolder_(chunkPos.getChunkPos().func_201841_a());
        if (chunkHolder != null && (chunk = chunkHolder.func_219298_c()) != null) {
            McHelper.getServer().func_213185_aS().func_76320_a("ptl_create_chunk_packet");
            player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage(chunkPos.dimension, (IPacket)new SChunkDataPacket(chunk, 65535)));
            player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage(chunkPos.dimension, (IPacket)new SUpdateLightPacket(chunkPos.getChunkPos(), (WorldLightManager)ieStorage.getLightingProvider(), true)));
            ieStorage.updateEntityTrackersAfterSendingChunkPacket(chunk, player);
            McHelper.getServer().func_213185_aS().func_76319_b();
        }
    }

    public void onChunkProvidedDeferred(Chunk chunk) {
        RegistryKey dimension = chunk.func_177412_p().func_234923_W_();
        IEThreadedAnvilChunkStorage ieStorage = McHelper.getIEStorage((RegistryKey<World>)dimension);
        McHelper.getServer().func_213185_aS().func_76320_a("ptl_create_chunk_packet");
        Supplier<IPacket> chunkDataPacketRedirected = Helper.cached(() -> MyNetwork.createRedirectedMessage((RegistryKey<World>)dimension, (IPacket)new SChunkDataPacket(chunk, 65535)));
        Supplier<IPacket> lightPacketRedirected = Helper.cached(() -> MyNetwork.createRedirectedMessage((RegistryKey<World>)dimension, (IPacket)new SUpdateLightPacket(chunk.func_76632_l(), (WorldLightManager)ieStorage.getLightingProvider(), true)));
        McHelper.getServer().func_213185_aS().func_76319_b();
        NewChunkTrackingGraph.getPlayersViewingChunk((RegistryKey<World>)dimension, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b).forEach(player -> {
            player.field_71135_a.func_147359_a((IPacket)chunkDataPacketRedirected.get());
            player.field_71135_a.func_147359_a((IPacket)lightPacketRedirected.get());
            ieStorage.updateEntityTrackersAfterSendingChunkPacket(chunk, (ServerPlayerEntity)player);
        });
    }

    private void onEndWatch(ServerPlayerEntity player, DimensionalChunkPos chunkPos) {
        player.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage(chunkPos.dimension, (IPacket)new SUnloadChunkPacket(chunkPos.x, chunkPos.z)));
    }

    public void onPlayerRespawn(ServerPlayerEntity oldPlayer) {
        McHelper.getServer().func_212370_w().forEach(world -> {
            ServerChunkProvider chunkManager = world.func_72863_F();
            IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.field_217237_a;
            storage.onPlayerRespawn(oldPlayer);
        });
        NewChunkTrackingGraph.forceRemovePlayer(oldPlayer);
    }
}

