/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.block_manipulation;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.block_manipulation.HandReachTweak;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockManipulationServer {
    public static void processBreakBlock(RegistryKey<World> dimension, CPlayerDiggingPacket packet, ServerPlayerEntity player) {
        if (BlockManipulationServer.shouldFinishMining(dimension, packet, player)) {
            if (BlockManipulationServer.canPlayerReach(dimension, player, packet.func_179715_a())) {
                BlockManipulationServer.doDestroyBlock(dimension, packet, player);
            } else {
                Helper.log("Rejected cross portal block breaking packet " + player);
            }
        }
    }

    private static boolean shouldFinishMining(RegistryKey<World> dimension, CPlayerDiggingPacket packet, ServerPlayerEntity player) {
        if (packet.func_180762_c() == CPlayerDiggingPacket.Action.START_DESTROY_BLOCK) {
            return BlockManipulationServer.canInstantMine(McHelper.getServer().func_71218_a(dimension), player, packet.func_179715_a());
        }
        return packet.func_180762_c() == CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK;
    }

    private static boolean canPlayerReach(RegistryKey<World> dimension, ServerPlayerEntity player, BlockPos requestPos) {
        Vector3d pos = Vector3d.func_237489_a_((Vector3i)requestPos);
        Vector3d playerPos = player.func_213303_ch();
        double multiplier = HandReachTweak.getActualHandReachMultiplier((PlayerEntity)player);
        double distanceSquare = 36.0 * multiplier * multiplier;
        if (player.field_70170_p.func_234923_W_() == dimension && playerPos.func_72436_e(pos) < distanceSquare) {
            return true;
        }
        return McHelper.getServerPortalsNearby((Entity)player, 20.0).anyMatch(portal -> portal.dimensionTo == dimension && portal.transformPointRough(playerPos).func_72436_e(pos) < distanceSquare);
    }

    private static void doDestroyBlock(RegistryKey<World> dimension, CPlayerDiggingPacket packet, ServerPlayerEntity player) {
        ServerWorld destWorld = McHelper.getServer().func_71218_a(dimension);
        ServerWorld oldWorld = player.field_71134_c.field_73092_a;
        player.field_71134_c.func_73080_a(destWorld);
        player.field_71134_c.func_180237_b(packet.func_179715_a());
        player.field_71134_c.func_73080_a(oldWorld);
    }

    private static boolean canInstantMine(ServerWorld world, ServerPlayerEntity player, BlockPos pos) {
        if (player.func_184812_l_()) {
            return true;
        }
        float progress = 1.0f;
        BlockState blockState = world.func_180495_p(pos);
        if (!blockState.func_196958_f()) {
            blockState.func_196942_a((World)world, pos, (PlayerEntity)player);
            progress = blockState.func_185903_a((PlayerEntity)player, (IBlockReader)world, pos);
        }
        return !blockState.func_196958_f() && progress >= 1.0f;
    }

    public static Tuple<BlockRayTraceResult, RegistryKey<World>> getHitResultForPlacing(World world, BlockRayTraceResult blockHitResult) {
        Direction side = blockHitResult.func_216354_b();
        Vector3d sideVec = Vector3d.func_237491_b_((Vector3i)side.func_176730_m());
        Vector3d hitCenter = Vector3d.func_237489_a_((Vector3i)blockHitResult.func_216350_a());
        List<GlobalTrackedPortal> globalPortals = McHelper.getGlobalPortals(world);
        GlobalTrackedPortal portal = globalPortals.stream().filter(p -> p.getContentDirection().func_72430_b(sideVec) > 0.9 && p.isPointInPortalProjection(hitCenter) && p.getDistanceToPlane(hitCenter) < 0.6).findFirst().orElse(null);
        if (portal == null) {
            return new Tuple((Object)blockHitResult, (Object)world.func_234923_W_());
        }
        Vector3d newCenter = portal.transformPoint(hitCenter.func_178787_e(sideVec));
        BlockPos placingBlockPos = new BlockPos(newCenter);
        BlockRayTraceResult newHitResult = new BlockRayTraceResult(Vector3d.field_186680_a, side.func_176734_d(), placingBlockPos, blockHitResult.func_216353_d());
        return new Tuple((Object)newHitResult, (Object)portal.dimensionTo);
    }

    public static void processRightClickBlock(RegistryKey<World> dimension, CPlayerTryUseItemOnBlockPacket packet, ServerPlayerEntity player) {
        Hand hand = packet.func_187022_c();
        BlockRayTraceResult blockHitResult = packet.func_218794_c();
        ServerWorld world = McHelper.getServer().func_71218_a(dimension);
        BlockManipulationServer.doProcessRightClick(dimension, player, hand, blockHitResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcessRightClick(RegistryKey<World> dimension, ServerPlayerEntity player, Hand hand, BlockRayTraceResult blockHitResult) {
        ItemStack itemStack = player.func_184586_b(hand);
        MinecraftServer server = McHelper.getServer();
        ServerWorld targetWorld = server.func_71218_a(dimension);
        BlockPos blockPos = blockHitResult.func_216350_a();
        Direction direction = blockHitResult.func_216354_b();
        player.func_143004_u();
        if (targetWorld.func_175660_a((PlayerEntity)player, blockPos)) {
            if (!BlockManipulationServer.canPlayerReach(dimension, player, blockPos)) {
                Helper.log("Reject cross portal block placing packet " + player);
                return;
            }
            World oldWorld = player.field_70170_p;
            player.field_70170_p = targetWorld;
            try {
                ActionResultType actionResult = player.field_71134_c.func_219441_a(player, (World)targetWorld, itemStack, hand, blockHitResult);
                if (actionResult.func_226247_b_()) {
                    player.func_226292_a_(hand, true);
                }
            }
            finally {
                player.field_70170_p = oldWorld;
            }
        }
        MyNetwork.sendRedirectedMessage(player, dimension, (IPacket)new SChangeBlockPacket((IBlockReader)targetWorld, blockPos));
        BlockPos offseted = blockPos.func_177972_a(direction);
        if (offseted.func_177956_o() >= 0 && offseted.func_177956_o() <= 256) {
            MyNetwork.sendRedirectedMessage(player, dimension, (IPacket)new SChangeBlockPacket((IBlockReader)targetWorld, offseted));
        }
    }
}

