/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.block_manipulation;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.block_manipulation.BlockManipulationServer;
import com.qouteall.immersive_portals.commands.PortalCommand;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalPlaceholderBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockManipulationClient {
    private static final Minecraft client = Minecraft.func_71410_x();
    public static RegistryKey<World> remotePointedDim;
    public static RayTraceResult remoteHitResult;
    public static boolean isContextSwitched;

    public static boolean isPointingToPortal() {
        return remotePointedDim != null;
    }

    private static BlockRayTraceResult createMissedHitResult(Vector3d from, Vector3d to) {
        Vector3d dir = to.func_178788_d(from).func_72432_b();
        return BlockRayTraceResult.func_216352_a((Vector3d)to, (Direction)Direction.func_210769_a((double)dir.field_72450_a, (double)dir.field_72448_b, (double)dir.field_72449_c), (BlockPos)new BlockPos(to));
    }

    private static boolean hitResultIsMissedOrNull(RayTraceResult bhr) {
        return bhr == null || bhr.func_216346_c() == RayTraceResult.Type.MISS;
    }

    public static void updatePointedBlock(float tickDelta) {
        if (BlockManipulationClient.client.field_71442_b == null || BlockManipulationClient.client.field_71441_e == null) {
            return;
        }
        remotePointedDim = null;
        remoteHitResult = null;
        Vector3d cameraPos = BlockManipulationClient.client.field_71460_t.func_215316_n().func_216785_c();
        float reachDistance = BlockManipulationClient.client.field_71442_b.func_78757_d();
        PortalCommand.getPlayerPointingPortalRaw((PlayerEntity)BlockManipulationClient.client.field_71439_g, tickDelta, reachDistance, true).ifPresent(pair -> {
            double distanceToPortalPointing;
            if (((Portal)((Object)((Object)pair.getFirst()))).isInteractable() && (distanceToPortalPointing = ((Vector3d)pair.getSecond()).func_72438_d(cameraPos)) < BlockManipulationClient.getCurrentTargetDistance() + 0.2) {
                BlockManipulationClient.client.field_71476_x = BlockManipulationClient.createMissedHitResult(cameraPos, (Vector3d)pair.getSecond());
                BlockManipulationClient.updateTargetedBlockThroughPortal(cameraPos, BlockManipulationClient.client.field_71439_g.func_70676_i(tickDelta), (RegistryKey<World>)BlockManipulationClient.client.field_71439_g.field_70170_p.func_234923_W_(), distanceToPortalPointing, reachDistance, (Portal)((Object)((Object)pair.getFirst())));
            }
        });
    }

    private static double getCurrentTargetDistance() {
        BlockPos hitPos;
        Vector3d cameraPos = BlockManipulationClient.client.field_71460_t.func_215316_n().func_216785_c();
        if (BlockManipulationClient.hitResultIsMissedOrNull(BlockManipulationClient.client.field_71476_x)) {
            return 23333.0;
        }
        if (BlockManipulationClient.client.field_71476_x instanceof BlockRayTraceResult && BlockManipulationClient.client.field_71441_e.func_180495_p(hitPos = ((BlockRayTraceResult)BlockManipulationClient.client.field_71476_x).func_216350_a()).func_177230_c() == PortalPlaceholderBlock.instance) {
            return 23333.0;
        }
        return cameraPos.func_72438_d(BlockManipulationClient.client.field_71476_x.func_216347_e());
    }

    private static void updateTargetedBlockThroughPortal(Vector3d cameraPos, Vector3d viewVector, RegistryKey<World> playerDimension, double beginDistance, double endDistance, Portal portal) {
        Vector3d from = portal.transformPoint(cameraPos.func_178787_e(viewVector.func_186678_a(beginDistance)));
        Vector3d to = portal.transformPoint(cameraPos.func_178787_e(viewVector.func_186678_a(endDistance)));
        RayTraceContext context = new RayTraceContext(from, to, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)BlockManipulationClient.client.field_71439_g);
        ClientWorld world = CGlobal.clientWorldLoader.getWorld(portal.dimensionTo);
        remoteHitResult = (RayTraceResult)IBlockReader.func_217300_a((RayTraceContext)context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            if (blockState.func_177230_c() == PortalPlaceholderBlock.instance) {
                return null;
            }
            if (blockState.func_177230_c() == Blocks.field_180401_cv) {
                return null;
            }
            FluidState fluidState = world.func_204610_c(blockPos);
            Vector3d start = rayTraceContext.func_222253_b();
            Vector3d end = rayTraceContext.func_222250_a();
            Vector3d correctedStart = start.func_178788_d(end.func_178788_d(start).func_186678_a(0.0015));
            VoxelShape solidShape = rayTraceContext.func_222251_a(blockState, (IBlockReader)world, blockPos);
            BlockRayTraceResult blockHitResult = world.func_217296_a(correctedStart, end, blockPos, solidShape, blockState);
            VoxelShape fluidShape = rayTraceContext.func_222252_a(fluidState, (IBlockReader)world, blockPos);
            BlockRayTraceResult blockHitResult2 = fluidShape.func_212433_a(start, end, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(blockHitResult.func_216347_e());
            double e = blockHitResult2 == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(blockHitResult2.func_216347_e());
            return d <= e ? blockHitResult : blockHitResult2;
        }, rayTraceContext -> {
            Vector3d vec3d = rayTraceContext.func_222253_b().func_178788_d(rayTraceContext.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.func_222250_a(), (Direction)Direction.func_210769_a((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c), (BlockPos)new BlockPos(rayTraceContext.func_222250_a()));
        });
        if (BlockManipulationClient.remoteHitResult.func_216347_e().field_72448_b < 0.1) {
            remoteHitResult = new BlockRayTraceResult(remoteHitResult.func_216347_e(), Direction.DOWN, ((BlockRayTraceResult)remoteHitResult).func_216350_a(), ((BlockRayTraceResult)remoteHitResult).func_216353_d());
        }
        if (remoteHitResult != null && !world.func_180495_p(((BlockRayTraceResult)remoteHitResult).func_216350_a()).func_196958_f()) {
            BlockManipulationClient.client.field_71476_x = BlockManipulationClient.createMissedHitResult(from, to);
            remotePointedDim = portal.dimensionTo;
        }
    }

    public static void myHandleBlockBreaking(boolean isKeyPressed) {
        if (!BlockManipulationClient.client.field_71439_g.func_184587_cr()) {
            if (isKeyPressed && BlockManipulationClient.isPointingToPortal()) {
                Direction direction;
                BlockRayTraceResult blockHitResult = (BlockRayTraceResult)remoteHitResult;
                BlockPos blockPos = blockHitResult.func_216350_a();
                ClientWorld remoteWorld = CGlobal.clientWorldLoader.getWorld(remotePointedDim);
                if (!remoteWorld.func_180495_p(blockPos).func_196958_f() && BlockManipulationClient.myUpdateBlockBreakingProgress(blockPos, direction = blockHitResult.func_216354_b())) {
                    BlockManipulationClient.client.field_71452_i.func_180532_a(blockPos, direction);
                    BlockManipulationClient.client.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                }
            } else {
                BlockManipulationClient.client.field_71442_b.func_78767_c();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean myUpdateBlockBreakingProgress(BlockPos blockPos, Direction direction) {
        ClientWorld oldWorld = BlockManipulationClient.client.field_71441_e;
        BlockManipulationClient.client.field_71441_e = CGlobal.clientWorldLoader.getWorld(remotePointedDim);
        isContextSwitched = true;
        try {
            boolean bl = BlockManipulationClient.client.field_71442_b.func_180512_c(blockPos, direction);
            return bl;
        }
        finally {
            BlockManipulationClient.client.field_71441_e = oldWorld;
            isContextSwitched = false;
        }
    }

    public static void myAttackBlock() {
        BlockPos blockPos;
        ClientWorld targetWorld = CGlobal.clientWorldLoader.getWorld(remotePointedDim);
        if (targetWorld.func_175623_d(blockPos = ((BlockRayTraceResult)remoteHitResult).func_216350_a())) {
            return;
        }
        ClientWorld oldWorld = BlockManipulationClient.client.field_71441_e;
        BlockManipulationClient.client.field_71441_e = targetWorld;
        isContextSwitched = true;
        try {
            BlockManipulationClient.client.field_71442_b.func_180511_b(blockPos, ((BlockRayTraceResult)remoteHitResult).func_216354_b());
        }
        finally {
            BlockManipulationClient.client.field_71441_e = oldWorld;
            isContextSwitched = false;
        }
        BlockManipulationClient.client.field_71439_g.func_184609_a(Hand.MAIN_HAND);
    }

    public static void myItemUse(Hand hand) {
        ActionResultType actionResult3;
        ClientWorld targetWorld = CGlobal.clientWorldLoader.getWorld(remotePointedDim);
        ItemStack itemStack = BlockManipulationClient.client.field_71439_g.func_184586_b(hand);
        BlockRayTraceResult blockHitResult = (BlockRayTraceResult)remoteHitResult;
        Tuple<BlockRayTraceResult, RegistryKey<World>> result = BlockManipulationServer.getHitResultForPlacing((World)targetWorld, blockHitResult);
        blockHitResult = (BlockRayTraceResult)result.func_76341_a();
        targetWorld = CGlobal.clientWorldLoader.getWorld((RegistryKey<World>)((RegistryKey)result.func_76340_b()));
        remoteHitResult = blockHitResult;
        remotePointedDim = (RegistryKey)result.func_76340_b();
        int i = itemStack.func_190916_E();
        ActionResultType actionResult2 = BlockManipulationClient.myInteractBlock(hand, targetWorld, blockHitResult);
        if (actionResult2.func_226246_a_()) {
            if (actionResult2.func_226247_b_()) {
                BlockManipulationClient.client.field_71439_g.func_184609_a(hand);
                if (!itemStack.func_190926_b() && (itemStack.func_190916_E() != i || BlockManipulationClient.client.field_71442_b.func_78758_h())) {
                    BlockManipulationClient.client.field_71460_t.field_78516_c.func_187460_a(hand);
                }
            }
            return;
        }
        if (actionResult2 == ActionResultType.FAIL) {
            return;
        }
        if (!itemStack.func_190926_b() && (actionResult3 = BlockManipulationClient.client.field_71442_b.func_187101_a((PlayerEntity)BlockManipulationClient.client.field_71439_g, (World)targetWorld, hand)).func_226246_a_()) {
            if (actionResult3.func_226247_b_()) {
                BlockManipulationClient.client.field_71439_g.func_184609_a(hand);
            }
            BlockManipulationClient.client.field_71460_t.field_78516_c.func_187460_a(hand);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionResultType myInteractBlock(Hand hand, ClientWorld targetWorld, BlockRayTraceResult blockHitResult) {
        ClientWorld oldWorld = BlockManipulationClient.client.field_71441_e;
        try {
            BlockManipulationClient.client.field_71439_g.field_70170_p = targetWorld;
            BlockManipulationClient.client.field_71441_e = targetWorld;
            isContextSwitched = true;
            ActionResultType actionResultType = BlockManipulationClient.client.field_71442_b.func_217292_a(BlockManipulationClient.client.field_71439_g, targetWorld, hand, blockHitResult);
            return actionResultType;
        }
        finally {
            BlockManipulationClient.client.field_71439_g.field_70170_p = oldWorld;
            BlockManipulationClient.client.field_71441_e = oldWorld;
            isContextSwitched = false;
        }
    }

    static {
        isContextSwitched = false;
    }
}

