/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.altius_world;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.altius_world.AltiusInfo;
import com.qouteall.immersive_portals.altius_world.DimListWidget;
import com.qouteall.immersive_portals.altius_world.DimTermWidget;
import com.qouteall.immersive_portals.altius_world.SelectDimensionScreen;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AltiusScreen
extends Screen {
    CreateWorldScreen parent;
    private Button backButton;
    private Button toggleButton;
    private Button addDimensionButton;
    private Button removeDimensionButton;
    private int titleY;
    public boolean isEnabled = false;
    private DimListWidget dimListWidget;

    public AltiusScreen(CreateWorldScreen parent) {
        super((ITextComponent)new TranslationTextComponent("imm_ptl.altius_screen"));
        this.parent = parent;
        this.toggleButton = new Button(0, 0, 150, 20, (ITextComponent)new TranslationTextComponent("imm_ptl.toggle_altius"), buttonWidget -> this.setEnabled(!this.isEnabled));
        this.backButton = new Button(0, 0, 72, 20, (ITextComponent)new TranslationTextComponent("imm_ptl.back_to_create_world"), buttonWidget -> Minecraft.func_71410_x().func_147108_a((Screen)parent));
        this.addDimensionButton = new Button(0, 0, 72, 20, (ITextComponent)new TranslationTextComponent("imm_ptl.add_dimension"), buttonWidget -> this.onAddDimension());
        this.removeDimensionButton = new Button(0, 0, 72, 20, (ITextComponent)new TranslationTextComponent("imm_ptl.remove_dimension"), buttonWidget -> this.onRemoveDimension());
        this.dimListWidget = new DimListWidget(this.field_230708_k_, this.field_230709_l_, 100, 200, 15, this);
        Consumer<DimTermWidget> callback = this.getElementSelectCallback();
        this.dimListWidget.terms.add(new DimTermWidget(ModMain.alternate4, this.dimListWidget, callback));
        this.dimListWidget.terms.add(new DimTermWidget(ModMain.alternate2, this.dimListWidget, callback));
        this.dimListWidget.terms.add(new DimTermWidget((RegistryKey<World>)World.field_234918_g_, this.dimListWidget, callback));
        this.dimListWidget.terms.add(new DimTermWidget((RegistryKey<World>)World.field_234919_h_, this.dimListWidget, callback));
    }

    public AltiusInfo getAltiusInfo() {
        if (this.isEnabled) {
            return new AltiusInfo(this.dimListWidget.terms.stream().map(w -> w.dimension).collect(Collectors.toList()));
        }
        return null;
    }

    protected void func_231160_c_() {
        this.func_230480_a_((Widget)this.toggleButton);
        this.func_230480_a_((Widget)this.backButton);
        this.func_230480_a_((Widget)this.addDimensionButton);
        this.func_230480_a_((Widget)this.removeDimensionButton);
        this.setEnabled(this.isEnabled);
        this.field_230705_e_.add(this.dimListWidget);
        this.dimListWidget.update();
        CHelper.layout(0, this.field_230709_l_, CHelper.LayoutElement.blankSpace(15), new CHelper.LayoutElement(true, 20, (from, to) -> {
            this.titleY = (from + to) / 2;
        }), CHelper.LayoutElement.blankSpace(10), new CHelper.LayoutElement(true, 20, (a, b) -> {
            this.toggleButton.field_230690_l_ = 20;
            this.toggleButton.field_230691_m_ = a;
        }), CHelper.LayoutElement.blankSpace(10), new CHelper.LayoutElement(false, 1, (from, to) -> this.dimListWidget.func_230940_a_(this.field_230708_k_, this.field_230709_l_, from, to)), CHelper.LayoutElement.blankSpace(15), new CHelper.LayoutElement(true, 20, (from, to) -> {
            this.backButton.field_230691_m_ = from;
            this.addDimensionButton.field_230691_m_ = from;
            this.removeDimensionButton.field_230691_m_ = from;
            CHelper.layout(0, this.field_230708_k_, CHelper.LayoutElement.blankSpace(20), CHelper.LayoutElement.layoutX(this.backButton, 1), CHelper.LayoutElement.blankSpace(10), CHelper.LayoutElement.layoutX(this.addDimensionButton, 1), CHelper.LayoutElement.blankSpace(10), CHelper.LayoutElement.layoutX(this.removeDimensionButton, 1), CHelper.LayoutElement.blankSpace(20));
        }), CHelper.LayoutElement.blankSpace(15));
    }

    private Consumer<DimTermWidget> getElementSelectCallback() {
        return w -> this.dimListWidget.func_241215_a_((AbstractList.AbstractListEntry)w);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseY, int i, float f) {
        this.func_230446_a_(matrixStack);
        if (this.isEnabled) {
            this.dimListWidget.func_230430_a_(matrixStack, mouseY, i, f);
        }
        super.func_230430_a_(matrixStack, mouseY, i, f);
        FontRenderer textRenderer = Minecraft.func_71410_x().field_71466_p;
        textRenderer.func_243246_a(matrixStack, this.field_230704_d_, 20.0f, 20.0f, -1);
    }

    private void setEnabled(boolean cond) {
        this.isEnabled = cond;
        if (this.isEnabled) {
            this.toggleButton.func_238482_a_((ITextComponent)new TranslationTextComponent("imm_ptl.altius_toggle_true"));
        } else {
            this.toggleButton.func_238482_a_((ITextComponent)new TranslationTextComponent("imm_ptl.altius_toggle_false"));
        }
        this.addDimensionButton.field_230694_p_ = this.isEnabled;
        this.removeDimensionButton.field_230694_p_ = this.isEnabled;
    }

    private void onAddDimension() {
        DimTermWidget selected = (DimTermWidget)this.dimListWidget.func_230958_g_();
        int position = selected == null ? 0 : this.dimListWidget.terms.indexOf((Object)selected);
        if (position < 0 || position > this.dimListWidget.terms.size()) {
            position = -1;
        }
        int insertingPosition = position + 1;
        Minecraft.func_71410_x().func_147108_a((Screen)new SelectDimensionScreen(this, dimensionType -> {
            this.dimListWidget.terms.add(insertingPosition, new DimTermWidget((RegistryKey<World>)dimensionType, this.dimListWidget, this.getElementSelectCallback()));
            this.removeDuplicate(insertingPosition);
            this.dimListWidget.update();
        }));
    }

    private void onRemoveDimension() {
        DimTermWidget selected = (DimTermWidget)this.dimListWidget.func_230958_g_();
        if (selected == null) {
            return;
        }
        int position = this.dimListWidget.terms.indexOf((Object)selected);
        if (position == -1) {
            return;
        }
        this.dimListWidget.terms.remove(position);
        this.dimListWidget.update();
    }

    private void removeDuplicate(int insertedIndex) {
        RegistryKey<World> inserted = this.dimListWidget.terms.get((int)insertedIndex).dimension;
        for (int i = this.dimListWidget.terms.size() - 1; i >= 0; --i) {
            if (this.dimListWidget.terms.get((int)i).dimension != inserted || i == insertedIndex) continue;
            this.dimListWidget.terms.remove(i);
        }
    }
}

