/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.altius_world;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import com.qouteall.immersive_portals.ducks.IELevelProperties;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.VerticalConnectingPortal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;

public class AltiusInfo {
    private List<ResourceLocation> dimsFromTopToDown;

    public AltiusInfo(List<RegistryKey<World>> dimsFromTopToDown) {
        this.dimsFromTopToDown = dimsFromTopToDown.stream().map(dimensionType -> dimensionType.func_240901_a_()).collect(Collectors.toList());
    }

    public static AltiusInfo getDummy() {
        return new AltiusInfo(new ArrayList<RegistryKey<World>>());
    }

    public static AltiusInfo fromTag(CompoundNBT tag) {
        ListNBT listTag = tag.func_150295_c("dimensions", 8);
        ArrayList<RegistryKey<World>> dimensionTypeList = new ArrayList<RegistryKey<World>>();
        listTag.forEach(t -> {
            StringNBT t1 = (StringNBT)t;
            String dimId = t1.func_150285_a_();
            RegistryKey<World> dimensionType = DimId.idToKey(dimId);
            if (dimensionType != null) {
                dimensionTypeList.add(dimensionType);
            } else {
                Helper.log("Unknown Dimension Id " + dimId);
            }
        });
        return new AltiusInfo(dimensionTypeList);
    }

    public CompoundNBT toTag() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT listTag = new ListNBT();
        this.dimsFromTopToDown.forEach(dimensionType -> listTag.add(listTag.size(), (INBT)StringNBT.func_229705_a_((String)dimensionType.toString())));
        tag.func_218657_a("dimensions", (INBT)listTag);
        return tag;
    }

    public static AltiusInfo getInfoFromServer() {
        IServerConfiguration saveProperties = McHelper.getServer().func_240793_aU_();
        return ((IELevelProperties)saveProperties).getAltiusInfo();
    }

    public static boolean isAltius() {
        return AltiusInfo.getInfoFromServer() != null;
    }

    public void createPortals() {
        if (this.dimsFromTopToDown.isEmpty()) {
            Helper.err("Dimension List is empty?");
            return;
        }
        RegistryKey<World> topDimension = DimId.idToKey(this.dimsFromTopToDown.get(0));
        if (topDimension == null) {
            Helper.err("Invalid Dimension " + this.dimsFromTopToDown.get(0));
            return;
        }
        ServerWorld world = McHelper.getServer().func_71218_a(topDimension);
        if (world == null) {
            Helper.err("Missing Dimension " + topDimension.func_240901_a_());
            return;
        }
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        if (gps.data == null || gps.data.isEmpty()) {
            Helper.wrapAdjacentAndMap(this.dimsFromTopToDown.stream(), (top, down) -> {
                VerticalConnectingPortal.connectMutually(DimId.idToKey(top), DimId.idToKey(down), 0, VerticalConnectingPortal.getHeight(DimId.idToKey(down)));
                return null;
            }).forEach(k -> {});
            Helper.log("Initialized Portals For Altius");
        }
    }
}

