/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.alternate_dimension;

import com.qouteall.immersive_portals.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Tuple;

public class RandomSelector<T> {
    private Object[] entries;
    private int[] subWeightSum;
    private int weightSum;

    public RandomSelector(List<Tuple<T, Integer>> data) {
        this.entries = data.stream().map(Tuple::func_76341_a).toArray();
        this.subWeightSum = Helper.mapReduce(data.stream(), (preSum, curr) -> preSum + (Integer)curr.func_76340_b(), new Helper.SimpleBox<Integer>(0)).mapToInt(i -> i).toArray();
        this.weightSum = this.subWeightSum[this.subWeightSum.length - 1];
    }

    public T select(Random random) {
        int randomValue = random.nextInt(this.weightSum);
        return this.selectByRandomValue(randomValue);
    }

    private T selectByRandomValue(int randomValue) {
        int result = Arrays.binarySearch(this.subWeightSum, 0, this.subWeightSum.length, randomValue);
        if (result >= 0) {
            return (T)this.entries[result + 1];
        }
        int firstEleGreaterThanValue = -(result + 1);
        return (T)this.entries[firstEleGreaterThanValue];
    }

    public static class Builder<A> {
        private ArrayList<Tuple<A, Integer>> data = new ArrayList();

        public Builder<A> add(int weight, A element) {
            this.data.add(new Tuple(element, (Object)weight));
            return this;
        }

        public RandomSelector<A> build() {
            return new RandomSelector(this.data);
        }
    }
}

