/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.alternate_dimension;

import com.qouteall.immersive_portals.alternate_dimension.RandomSelector;
import java.util.Random;
import java.util.function.Function;

public class FormulaGenerator {
    private static RandomSelector<Function<Random, UniNumFunction>> uniFuncSelector;
    private static RandomSelector<TriNumFunction> triFuncSelector;

    public static void init() {
        FormulaGenerator.initUniFuncSelector();
        FormulaGenerator.initTriFuncSelector();
    }

    private static void initUniFuncSelector() {
        RandomSelector.Builder<Function> builder = new RandomSelector.Builder<Function>();
        Function<Function, Function> applyRandomArg = arged -> random -> (UniNumFunction)arged.apply(random.nextDouble());
        Function<UniNumFunction, Function> noRandomArg = func -> random -> func;
        builder.add(30, noRandomArg.apply(x -> x));
        builder.add(30, noRandomArg.apply(x -> -x));
        builder.add(30, noRandomArg.apply(x -> x * x));
        builder.add(30, noRandomArg.apply(x -> x * x * x));
        builder.add(10, noRandomArg.apply(x -> Math.sin(x * 3.0)));
        builder.add(10, noRandomArg.apply(x -> Math.cos(x * 7.0)));
        builder.add(10, noRandomArg.apply(x -> Math.exp(x * 3.0)));
        builder.add(10, noRandomArg.apply(x -> Math.log(Math.abs(x) + 1.0)));
        builder.add(5, noRandomArg.apply(x -> Math.cosh(x)));
        builder.add(10, noRandomArg.apply(x -> Math.abs(x)));
        builder.add(5, noRandomArg.apply(x -> Math.round(x)));
        builder.add(10, noRandomArg.apply(x -> Math.sqrt(Math.abs(x))));
        builder.add(10, noRandomArg.apply(x -> FormulaGenerator.weirdSwap(x)));
        builder.add(100, applyRandomArg.apply(arg -> x -> x * arg));
        builder.add(50, applyRandomArg.apply(arg -> x -> x / Math.max(arg, 0.001)));
        builder.add(10, applyRandomArg.apply(arg -> x -> Math.max(x, arg)));
        builder.add(10, applyRandomArg.apply(arg -> x -> Math.floor(x * arg * 23.0)));
        builder.add(5, applyRandomArg.apply(arg -> x -> FormulaGenerator.weirdAnd(arg, x)));
        builder.add(10, applyRandomArg.apply(arg -> x -> FormulaGenerator.weirdXor(arg, x)));
        uniFuncSelector = builder.build();
    }

    private static int toInt(double d) {
        return (int)(d * 256.0);
    }

    private static double fromInt(int d) {
        return (double)d / 256.0;
    }

    private static double weirdAnd(double a, double b) {
        return FormulaGenerator.fromInt(FormulaGenerator.toInt(a) & FormulaGenerator.toInt(b));
    }

    private static double weirdXor(double a, double b) {
        return FormulaGenerator.fromInt(FormulaGenerator.toInt(a) ^ FormulaGenerator.toInt(b));
    }

    private static double weirdSwap(double a) {
        int i = FormulaGenerator.toInt(a);
        int r = (i & 0xF) << 4 | (i & 0xF0) >> 4;
        return FormulaGenerator.fromInt(r);
    }

    private static void initTriFuncSelector() {
        RandomSelector.Builder<TriNumFunction> builder = new RandomSelector.Builder<TriNumFunction>();
        builder.add(100, (x, y, z) -> x + y + z);
        builder.add(50, (x, y, z) -> x * y * z);
        builder.add(10, (x, y, z) -> x * y + z);
        builder.add(10, (x, y, z) -> x + y * z);
        builder.add(10, (x, y, z) -> x * z + y);
        builder.add(10, (x, y, z) -> x + y + z);
        builder.add(10, (x, y, z) -> x * x + y * y + z * z);
        builder.add(10, (x, y, z) -> x + y * y + z * z);
        builder.add(10, (x, y, z) -> x * x + y + z * z);
        builder.add(10, (x, y, z) -> x * x + y * y + z);
        builder.add(10, (x, y, z) -> -x * x + y * y + z * z);
        builder.add(10, (x, y, z) -> x * x - y * y + z * z);
        builder.add(10, (x, y, z) -> x * x + y * y - z * z);
        builder.add(3, (x, y, z) -> Math.pow(y, x + z));
        builder.add(3, (x, y, z) -> Math.pow(y, x - z));
        builder.add(3, (x, y, z) -> Math.pow(x * z, y));
        builder.add(20, (x, y, z) -> Math.log(Math.abs(x + y + z) + 0.5));
        triFuncSelector = builder.build();
    }

    public static UniNumFunction nestExpression(UniNumFunction inner, UniNumFunction outer) {
        return x -> outer.eval(inner.eval(x));
    }

    public static TriNumFunction nestExpression(TriNumFunction base, UniNumFunction a, UniNumFunction b, UniNumFunction c) {
        return (x, y, z) -> base.eval(a.eval(x), b.eval(y), c.eval(z));
    }

    public static UniNumFunction mergeExpression(TriNumFunction base, UniNumFunction a, UniNumFunction b, UniNumFunction c) {
        return x -> base.eval(a.eval(x), b.eval(x), c.eval(x));
    }

    public static UniNumFunction limitRange(UniNumFunction fun) {
        double v1 = fun.eval(0.0);
        double v3 = fun.eval(1.0);
        double tooBigThreshold = 233.0;
        if (Math.abs(v1) > 233.0 || Math.abs(v3) > 233.0) {
            return x -> Math.log(Math.abs(fun.eval(x)) + 1.0);
        }
        return fun;
    }

    public static UniNumFunction addConstant(UniNumFunction fun) {
        double v3;
        double v2;
        double v1 = fun.eval(0.0);
        double average = (v1 + (v2 = fun.eval(0.5)) + (v3 = fun.eval(1.0))) / 3.0;
        double offset = 0.5 - average;
        if (Math.abs(offset) < 0.1) {
            return fun;
        }
        return x -> fun.eval(x) + offset;
    }

    public static UniNumFunction processFunc(UniNumFunction fun) {
        return FormulaGenerator.addConstant(FormulaGenerator.limitRange(fun));
    }

    public static UniNumFunction getRandomUniExpressionOld(int seed) {
        int selector = seed % 80;
        if (selector < 10) {
            return x -> x;
        }
        if (selector < 20) {
            int factor = seed % 7 + 1;
            return x -> x * (double)factor;
        }
        if (selector < 30) {
            int factor = seed % 7 + 1;
            return x -> x * (double)(-factor);
        }
        if (selector < 38) {
            int divisor = seed % 7 + 1;
            return x -> x / (double)divisor;
        }
        if (selector < 42) {
            return x -> x * x;
        }
        if (selector < 48) {
            return x -> Math.sin(x * 3.0);
        }
        if (selector < 56) {
            return x -> Math.cos(x * 7.0);
        }
        if (selector < 60) {
            return Math::exp;
        }
        if (selector < 65) {
            return x -> Math.sqrt(Math.abs(x));
        }
        if (selector < 70) {
            return x -> Math.max(x, 0.5);
        }
        if (selector < 76) {
            return x -> Math.floor(x * 12.0);
        }
        return x -> x * x * x;
    }

    public static TriNumFunction getRandomTriExpressionOld(int seed) {
        int selector = seed % 90;
        if (selector < 30) {
            return (x, y, z) -> x + y + z;
        }
        if (selector < 37) {
            return (x, y, z) -> x - y + z;
        }
        if (selector < 45) {
            return (x, y, z) -> x * y - z;
        }
        if (selector < 50) {
            return (x, y, z) -> x * x - y * y + z * z;
        }
        if (selector < 55) {
            return (x, y, z) -> x * x + y * y + z * z;
        }
        if (selector < 60) {
            return (x, y, z) -> x + y * z;
        }
        if (selector < 67) {
            return (x, y, z) -> x - y * z;
        }
        if (selector < 75) {
            return (x, y, z) -> x * z + y * 2.0;
        }
        return (x, y, z) -> x * y * z;
    }

    public static UniNumFunction getComplexUniExpression(Random random, int nestingLayer) {
        if (nestingLayer == 0) {
            return FormulaGenerator.processFunc(FormulaGenerator.mergeExpression(triFuncSelector.select(random), FormulaGenerator.processFunc(uniFuncSelector.select(random).apply(random)), FormulaGenerator.processFunc(uniFuncSelector.select(random).apply(random)), FormulaGenerator.processFunc(uniFuncSelector.select(random).apply(random))));
        }
        return FormulaGenerator.mergeExpression(triFuncSelector.select(random), FormulaGenerator.getComplexUniExpression(random, nestingLayer - 1), FormulaGenerator.getComplexUniExpression(random, nestingLayer - 1), FormulaGenerator.getComplexUniExpression(random, nestingLayer - 1));
    }

    public static TriNumFunction getRandomTriCompositeExpression(Random random) {
        return FormulaGenerator.nestExpression(triFuncSelector.select(random), FormulaGenerator.getComplexUniExpression(random, 2), FormulaGenerator.getComplexUniExpression(random, 2), FormulaGenerator.getComplexUniExpression(random, 2));
    }

    public static interface UniNumFunction {
        public double eval(double var1);
    }

    public static interface TriNumFunction {
        public double eval(double var1, double var3, double var5);
    }
}

