/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.alternate_dimension.ChaosBiomeSource;
import com.qouteall.immersive_portals.alternate_dimension.RegionErrorTerrainGenerator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.EndCityStructure;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.StrongholdStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class ErrorTerrainGenerator
extends ChunkGenerator {
    public static final Codec<ErrorTerrainGenerator> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(g -> g.worldSeed), (App)ChaosBiomeSource.codec.fieldOf("biomeSource").stable().forGetter(o -> (ChaosBiomeSource)o.func_202090_b())).apply((Applicative)instance, instance.stable(ErrorTerrainGenerator::new)));
    private final BlockState air = Blocks.field_150350_a.func_176223_P();
    private final BlockState defaultBlock = Blocks.field_150348_b.func_176223_P();
    private final BlockState defaultFluid = Blocks.field_150355_j.func_176223_P();
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    private static final Blockreader verticalBlockSample = new Blockreader((BlockState[])Stream.concat(Stream.generate(() -> ((Block)Blocks.field_150348_b).func_176223_P()).limit(64L), Stream.generate(() -> ((Block)Blocks.field_150350_a).func_176223_P()).limit(192L)).toArray(BlockState[]::new));
    private long worldSeed;
    private final LoadingCache<ChunkPos, RegionErrorTerrainGenerator> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ChunkPos, RegionErrorTerrainGenerator>(){

        public RegionErrorTerrainGenerator load(ChunkPos key) {
            return new RegionErrorTerrainGenerator(key.field_77276_a, key.field_77275_b, ErrorTerrainGenerator.this.worldSeed);
        }
    });
    private final PerlinNoiseGenerator surfaceDepthNoise;

    public ErrorTerrainGenerator(long seed, BiomeProvider biomeSource) {
        super(biomeSource, new DimensionStructuresSettings(true));
        this.worldSeed = seed;
        this.surfaceDepthNoise = new PerlinNoiseGenerator(new SharedSeedRandom(seed), IntStream.rangeClosed(-3, 0));
    }

    private static double getProbability(Structure<?> structureFeature) {
        if (structureFeature instanceof StrongholdStructure) {
            return 7.0E-4;
        }
        if (structureFeature instanceof MineshaftStructure) {
            return 0.015;
        }
        if (structureFeature instanceof OceanMonumentStructure) {
            return 0.03;
        }
        if (structureFeature instanceof WoodlandMansionStructure) {
            return 0.08;
        }
        if (structureFeature instanceof EndCityStructure) {
            return 0.2;
        }
        return 0.15;
    }

    public void func_230354_a_(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(i, j).func_206849_h());
        SharedSeedRandom chunkRandom = new SharedSeedRandom();
        chunkRandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IServerWorld)region, (Biome)biome, (int)i, (int)j, (Random)chunkRandom);
    }

    public void func_230352_b_(IWorld world, StructureManager accessor, IChunk chunk) {
        ChunkPrimer protoChunk = (ChunkPrimer)chunk;
        ChunkPos pos = chunk.func_76632_l();
        Heightmap oceanFloorHeightMap = protoChunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap surfaceHeightMap = protoChunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int regionX = Math.floorDiv(pos.field_77276_a, 4);
        int regionZ = Math.floorDiv(pos.field_77275_b, 4);
        RegionErrorTerrainGenerator generator = Helper.noError(() -> (RegionErrorTerrainGenerator)this.cache.get((Object)new ChunkPos(regionX, regionZ)));
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            ChunkSection section = protoChunk.func_217332_a(sectionY);
            section.func_222635_a();
            for (int localX = 0; localX < 16; ++localX) {
                for (int localY = 0; localY < 16; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        int worldX = pos.field_77276_a * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.field_77275_b * 16 + localZ;
                        BlockState currBlockState = generator.getBlockComposition(worldX, worldY, worldZ);
                        if (currBlockState == this.air) continue;
                        section.func_177484_a(localX, localY, localZ, currBlockState, false);
                        oceanFloorHeightMap.func_202270_a(localX, worldY, localZ, currBlockState);
                        surfaceHeightMap.func_202270_a(localX, worldY, localZ, currBlockState);
                    }
                }
            }
            section.func_222637_b();
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return 64;
    }

    public int func_230355_e_() {
        return 128;
    }

    public int func_230356_f_() {
        return 0;
    }

    public IBlockReader func_230348_a_(int x, int z) {
        return verticalBlockSample;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return codec;
    }

    public ChunkGenerator func_230349_a_(long seed) {
        return new ErrorTerrainGenerator(seed, this.func_202090_b().func_230320_a_(seed));
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int i = chunkPos.field_77276_a;
        int j = chunkPos.field_77275_b;
        SharedSeedRandom chunkRandom = new SharedSeedRandom();
        chunkRandom.func_202422_a(i, j);
        ChunkPos chunkPos2 = chunk.func_76632_l();
        int k = chunkPos2.func_180334_c();
        int l = chunkPos2.func_180333_d();
        double d = 0.0625;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int m = 0; m < 16; ++m) {
            for (int n = 0; n < 16; ++n) {
                int o = k + m;
                int p = l + n;
                int q = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, m, n) + 1;
                double e = this.surfaceDepthNoise.func_215460_a((double)o * 0.0625, (double)p * 0.0625, 0.0625, (double)m * 0.0625) * 15.0;
                region.func_226691_t_((BlockPos)mutable.func_181079_c(k + m, q, l + n)).func_206854_a((Random)chunkRandom, chunk, o, p, q, e, this.defaultBlock, this.defaultFluid, this.func_230356_f_(), region.func_72905_C());
            }
        }
        ErrorTerrainGenerator.avoidSandLag(region);
    }

    private static void avoidSandLag(WorldGenRegion region) {
        IChunk centerChunk = region.func_212866_a_(region.func_201679_a(), region.func_201680_b());
        BlockPos.Mutable temp = new BlockPos.Mutable();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                boolean isLastAir = true;
                for (int y = 0; y < 100; ++y) {
                    temp.func_181079_c(x, y, z);
                    BlockState blockState = centerChunk.func_180495_p((BlockPos)temp);
                    Block block = blockState.func_177230_c();
                    if ((block == Blocks.field_150354_m || block == Blocks.field_150351_n) && isLastAir) {
                        centerChunk.func_177436_a((BlockPos)temp, Blocks.field_150322_A.func_176223_P(), true);
                    }
                    isLastAir = blockState.func_196958_f();
                }
            }
        }
    }
}

