/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.alternate_dimension;

import com.qouteall.immersive_portals.alternate_dimension.RandomSelector;
import com.qouteall.immersive_portals.alternate_dimension.RegionErrorTerrainGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.FastRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;

public class ErrorTerrainComposition {
    public static final BlockState air = Blocks.field_150350_a.func_176223_P();
    public static final BlockState stone = Blocks.field_150348_b.func_176223_P();
    public static final BlockState water = Blocks.field_150355_j.func_176223_P();
    public static final RegionErrorTerrainGenerator.Composition mountain = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        if (funcValue > middle) {
            if (funcValue > middle * middle) {
                return air;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition classicalSolid = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 32.0);
        if (funcValue > splitPoint) {
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition classicalHollow = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 32.0);
        if (funcValue > splitPoint) {
            if (funcValue > splitPoint + 2.0) {
                return air;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition classicalWatery = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 16.0);
        if (funcValue > splitPoint) {
            if ((int)funcValue % 23 == 0) {
                return water;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition newSolid = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint1 = Math.abs(middle);
        splitPoint1 *= Math.exp((double)Math.abs(worldY - 64) / 32.0 - 1.0);
        double splitPoint = splitPoint1 *= Math.max(1.0, 100.0 / (double)Math.max(1, Math.min(worldY, 128 - worldY)));
        if (funcValue > splitPoint) {
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition floatingSea = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 16.0);
        if (funcValue > splitPoint) {
            if (worldY > 63) {
                return water;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition treasured = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double upPoint = Math.max(middle, Math.max(upMiddle, downMiddle));
        double splitPoint = MathHelper.func_219803_d((double)((double)Math.abs(worldY - 32) / 32.0), (double)middle, (double)(worldY > 32 ? upMiddle : downMiddle));
        if (funcValue > splitPoint && (int)funcValue % 37 == 0) {
            Block randomBlock = (Block)Registry.field_212618_g.func_186801_a(new Random(FastRandom.func_226162_a_((long)worldX, (long)FastRandom.func_226162_a_((long)worldY, (long)worldZ))));
            if (randomBlock == Blocks.field_150461_bJ) {
                randomBlock = Blocks.field_150350_a;
            }
            return randomBlock.func_176223_P();
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition layeredHollow = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 32.0);
        if (funcValue > splitPoint) {
            double v = (funcValue - splitPoint) / 4.0;
            if (v > Math.floor(v) + 0.5) {
                return air;
            }
            return stone;
        }
        return air;
    };
    public static final RandomSelector<RegionErrorTerrainGenerator.Composition> selector = new RandomSelector.Builder<RegionErrorTerrainGenerator.Composition>().add(25, mountain).add(40, classicalSolid).add(50, classicalHollow).add(10, classicalWatery).add(10, newSolid).add(30, floatingSea).add(3, treasured).add(15, layeredHollow).build();

    private static double getSplitPointClassical(int worldY, double middle, double unitFactor) {
        double splitPoint = middle;
        splitPoint *= Math.exp((double)Math.abs(worldY - 64) / unitFactor);
        return splitPoint *= Math.max(0.7, 30.0 / (double)Math.max(1, Math.min(worldY, 128 - worldY)));
    }
}

