/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.alternate_dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.util.FastRandom;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;

public class ChaosBiomeSource
extends BiomeProvider {
    public static Codec<ChaosBiomeSource> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(o -> o.worldSeed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(o -> o.biomeRegistry)).apply((Applicative)instance, instance.stable(ChaosBiomeSource::new)));
    private long worldSeed;
    private Registry<Biome> biomeRegistry;

    public ChaosBiomeSource(long seed, Registry<Biome> biomeRegistry) {
        super(biomeRegistry.func_201756_e().collect(Collectors.toList()));
        this.worldSeed = seed;
        this.biomeRegistry = biomeRegistry;
    }

    private Biome getRandomBiome(int x, int z) {
        int biomeNum = this.field_226837_c_.size();
        int index = Math.abs((int)FastRandom.func_226162_a_((long)x, (long)z)) % biomeNum;
        return (Biome)this.field_226837_c_.get(index);
    }

    public Biome func_225526_b_(int biomeX, int biomeY, int biomeZ) {
        return FuzzedBiomeMagnifier.INSTANCE.func_225532_a_(this.worldSeed, biomeX / 2, 0, biomeZ / 2, (x, y, z) -> this.getRandomBiome(x, z));
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return codec;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new ChaosBiomeSource(seed, this.biomeRegistry);
    }
}

