/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.alternate_dimension;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.alternate_dimension.ChaosBiomeSource;
import com.qouteall.immersive_portals.alternate_dimension.ErrorTerrainGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class AlternateDimensions {
    public static ChunkGenerator createSkylandGenerator(long seed, DynamicRegistries rm) {
        MutableRegistry biomeRegistry = rm.func_243612_b(Registry.field_239720_u_);
        OverworldBiomeProvider biomeSource = new OverworldBiomeProvider(seed, false, false, (Registry)biomeRegistry);
        MutableRegistry settingsRegistry = rm.func_243612_b(Registry.field_243549_ar);
        DimensionSettings skylandSetting = (DimensionSettings)settingsRegistry.func_243576_d(DimensionSettings.field_242739_h);
        return new NoiseChunkGenerator((BiomeProvider)biomeSource, seed, () -> skylandSetting);
    }

    public static ChunkGenerator createErrorTerrainGenerator(long seed, DynamicRegistries rm) {
        MutableRegistry biomeRegistry = rm.func_243612_b(Registry.field_239720_u_);
        ChaosBiomeSource chaosBiomeSource = new ChaosBiomeSource(seed, (Registry<Biome>)biomeRegistry);
        return new ErrorTerrainGenerator(seed, chaosBiomeSource);
    }

    public static ChunkGenerator createVoidGenerator(DynamicRegistries rm) {
        MutableRegistry biomeRegistry = rm.func_243612_b(Registry.field_239720_u_);
        DimensionStructuresSettings structuresConfig = new DimensionStructuresSettings(Optional.of(DimensionStructuresSettings.field_236192_c_), (Map)Maps.newHashMap((Map)ImmutableMap.of()));
        FlatGenerationSettings flatChunkGeneratorConfig = new FlatGenerationSettings(structuresConfig, (Registry)biomeRegistry);
        flatChunkGeneratorConfig.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_150357_h));
        flatChunkGeneratorConfig.func_82650_c().add(new FlatLayerInfo(2, Blocks.field_150346_d));
        flatChunkGeneratorConfig.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_196658_i));
        flatChunkGeneratorConfig.func_82645_d();
        return new FlatChunkGenerator(flatChunkGeneratorConfig);
    }

    public static void addDimension(long argSeed, SimpleRegistry<Dimension> registry, RegistryKey<Dimension> key, Supplier<DimensionType> dimensionTypeSupplier, ChunkGenerator chunkGenerator) {
        if (!registry.func_148742_b().contains(key.func_240901_a_())) {
            registry.func_218381_a(key, (Object)new Dimension(dimensionTypeSupplier, chunkGenerator), Lifecycle.experimental());
        }
    }

    public static void addAlternateDimensions(SimpleRegistry<Dimension> registry, DynamicRegistries rm, long seed) {
        AlternateDimensions.addDimension(seed, registry, ModMain.alternate1Option, () -> ModMain.surfaceTypeObject, AlternateDimensions.createSkylandGenerator(seed, rm));
        AlternateDimensions.addDimension(seed, registry, ModMain.alternate2Option, () -> ModMain.surfaceTypeObject, AlternateDimensions.createSkylandGenerator(seed, rm));
        AlternateDimensions.addDimension(seed, registry, ModMain.alternate3Option, () -> ModMain.surfaceTypeObject, AlternateDimensions.createErrorTerrainGenerator(seed, rm));
        AlternateDimensions.addDimension(seed, registry, ModMain.alternate4Option, () -> ModMain.surfaceTypeObject, AlternateDimensions.createErrorTerrainGenerator(seed, rm));
        AlternateDimensions.addDimension(seed, registry, ModMain.alternate5Option, () -> ModMain.surfaceTypeObject, AlternateDimensions.createVoidGenerator(rm));
    }

    public static SimpleRegistry<Dimension> getAlternateDimensionsRemoved(SimpleRegistry<Dimension> registry) {
        return McHelper.filterAndCopyRegistry(registry, (key, obj) -> key != ModMain.alternate1Option && key != ModMain.alternate2Option && key != ModMain.alternate3Option && key != ModMain.alternate4Option && key != ModMain.alternate5Option);
    }
}

