/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals;

import com.qouteall.hiding_in_the_bushes.MyNetworkClient;
import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.ClientWorldLoader;
import com.qouteall.immersive_portals.DubiousThings;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.optifine_compatibility.OFBuiltChunkNeighborFix;
import com.qouteall.immersive_portals.optifine_compatibility.OFGlobal;
import com.qouteall.immersive_portals.optifine_compatibility.OFInterfaceInitializer;
import com.qouteall.immersive_portals.render.CrossPortalEntityRenderer;
import com.qouteall.immersive_portals.render.PortalRenderer;
import com.qouteall.immersive_portals.render.RendererUsingFrameBuffer;
import com.qouteall.immersive_portals.render.RendererUsingStencil;
import com.qouteall.immersive_portals.render.ShaderManager;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.lag_spike_fix.GlBufferCache;
import com.qouteall.immersive_portals.teleportation.ClientTeleportationManager;
import com.qouteall.immersive_portals.teleportation.CollisionHelper;
import net.minecraft.client.Minecraft;

public class ModMainClient {
    public static void switchToCorrectRenderer() {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (OFInterface.isShaders.getAsBoolean()) {
            switch (Global.renderMode) {
                case normal: {
                    ModMainClient.switchRenderer(OFGlobal.rendererMixed);
                    break;
                }
                case compatibility: {
                    ModMainClient.switchRenderer(OFGlobal.rendererDeferred);
                    break;
                }
                case debug: {
                    ModMainClient.switchRenderer(OFGlobal.rendererDebugWithShader);
                    break;
                }
                case none: {
                    ModMainClient.switchRenderer(CGlobal.rendererDummy);
                }
            }
        } else {
            switch (Global.renderMode) {
                case normal: {
                    ModMainClient.switchRenderer(CGlobal.rendererUsingStencil);
                    break;
                }
                case compatibility: {
                    ModMainClient.switchRenderer(CGlobal.rendererUsingFrameBuffer);
                    break;
                }
                case debug: {
                    ModMainClient.switchRenderer(CGlobal.rendererDebug);
                    break;
                }
                case none: {
                    ModMainClient.switchRenderer(CGlobal.rendererDummy);
                }
            }
        }
    }

    private static void switchRenderer(PortalRenderer renderer) {
        if (CGlobal.renderer != renderer) {
            Helper.log("switched to renderer " + renderer.getClass());
            CGlobal.renderer = renderer;
        }
    }

    public static void init() {
        Helper.log("initializing client");
        MyNetworkClient.init();
        Minecraft.func_71410_x().execute(() -> {
            CGlobal.rendererUsingStencil = new RendererUsingStencil();
            CGlobal.rendererUsingFrameBuffer = new RendererUsingFrameBuffer();
            CGlobal.renderer = CGlobal.rendererUsingStencil;
            CGlobal.clientWorldLoader = new ClientWorldLoader();
            CGlobal.clientTeleportationManager = new ClientTeleportationManager();
            if (CGlobal.shaderManager == null) {
                CGlobal.shaderManager = new ShaderManager();
            }
        });
        O_O.loadConfigFabric();
        DubiousThings.init();
        CrossPortalEntityRenderer.init();
        GlBufferCache.init();
        CollisionHelper.initClient();
        OFInterface.isOptifinePresent = O_O.detectOptiFine();
        if (OFInterface.isOptifinePresent) {
            OFInterfaceInitializer.init();
            OFBuiltChunkNeighborFix.init();
        }
        Helper.log(OFInterface.isOptifinePresent ? "Optifine is present" : "Optifine is not present");
    }
}

