/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ducks.IEThreadedAnvilChunkStorage;
import com.qouteall.immersive_portals.ducks.IEWorldChunk;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import com.qouteall.immersive_portals.render.CrossPortalEntityRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.Validate;

public class McHelper {
    public static WeakReference<MinecraftServer> refMinecraftServer = new WeakReference<Object>(null);

    public static IEThreadedAnvilChunkStorage getIEStorage(RegistryKey<World> dimension) {
        return (IEThreadedAnvilChunkStorage)McHelper.getServer().func_71218_a(dimension).func_72863_F().field_217237_a;
    }

    public static ArrayList<ServerPlayerEntity> getCopiedPlayerList() {
        return new ArrayList<ServerPlayerEntity>(McHelper.getServer().func_184103_al().func_181057_v());
    }

    public static List<ServerPlayerEntity> getRawPlayerList() {
        return McHelper.getServer().func_184103_al().func_181057_v();
    }

    public static Vector3d lastTickPosOf(Entity entity) {
        return new Vector3d(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s);
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)refMinecraftServer.get();
    }

    public static ServerWorld getOverWorldOnServer() {
        return McHelper.getServer().func_71218_a(World.field_234918_g_);
    }

    public static void serverLog(ServerPlayerEntity player, String text) {
        player.func_146105_b((ITextComponent)new StringTextComponent(text), false);
    }

    public static AxisAlignedBB getChunkBoundingBox(ChunkPos chunkPos) {
        return new AxisAlignedBB(chunkPos.func_206849_h(), chunkPos.func_206849_h().func_177982_a(16, 256, 16));
    }

    public static long getServerGameTime() {
        return McHelper.getOverWorldOnServer().func_82737_E();
    }

    public static <T> void performFindingTaskOnServer(boolean isMultithreaded, Stream<T> stream, Predicate<T> predicate, IntPredicate taskWatcher, Consumer<T> onFound, Runnable onNotFound, Runnable finalizer) {
        if (isMultithreaded) {
            McHelper.performMultiThreadedFindingTaskOnServer(stream, predicate, taskWatcher, onFound, onNotFound, finalizer);
        } else {
            McHelper.performSplittedFindingTaskOnServer(stream, predicate, taskWatcher, onFound, onNotFound, finalizer);
        }
    }

    public static <T> void performSplittedFindingTaskOnServer(Stream<T> stream, Predicate<T> predicate, IntPredicate taskWatcher, Consumer<T> onFound, Runnable onNotFound, Runnable finalizer) {
        long timeValve = 20000000L;
        int[] countStorage = new int[]{0};
        Iterator iterator = stream.iterator();
        ModMain.serverTaskList.addTask(() -> {
            long currTime;
            boolean shouldContinueRunning = taskWatcher.test(countStorage[0]);
            if (!shouldContinueRunning) {
                finalizer.run();
                return true;
            }
            long startTime = System.nanoTime();
            do {
                for (int i = 0; i < 300; ++i) {
                    if (iterator.hasNext()) {
                        Object next = iterator.next();
                        if (predicate.test(next)) {
                            onFound.accept(next);
                            finalizer.run();
                            return true;
                        }
                    } else {
                        onNotFound.run();
                        finalizer.run();
                        return true;
                    }
                    countStorage[0] = countStorage[0] + 1;
                }
            } while ((currTime = System.nanoTime()) - startTime <= 20000000L);
            return false;
        });
    }

    public static <T> void performMultiThreadedFindingTaskOnServer(Stream<T> stream, Predicate<T> predicate, IntPredicate taskWatcher, Consumer<T> onFound, Runnable onNotFound, Runnable finalizer) {
        int[] progress = new int[1];
        Helper.SimpleBox<Boolean> isAborted = new Helper.SimpleBox<Boolean>(false);
        Helper.SimpleBox<Runnable> finishBehavior = new Helper.SimpleBox<Runnable>(() -> Helper.err("Error Occured???"));
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = stream.peek(obj -> {
                    progress[0] = progress[0] + 1;
                }).filter(predicate).findFirst().orElse(null);
                finishBehavior.obj = result != null ? () -> onFound.accept(result) : onNotFound;
            }
            catch (Throwable t) {
                t.printStackTrace();
                finishBehavior.obj = () -> t.printStackTrace();
            }
        }, Util.func_215072_e());
        ModMain.serverTaskList.addTask(() -> {
            if (future.isDone()) {
                if (!((Boolean)isAborted.obj).booleanValue()) {
                    ((Runnable)finishBehavior.obj).run();
                    finalizer.run();
                } else {
                    Helper.log("Future done but the task is aborted");
                }
                return true;
            }
            if (future.isCancelled()) {
                Helper.err("The future is cancelled???");
                finalizer.run();
                return true;
            }
            if (future.isCompletedExceptionally()) {
                Helper.err("The future is completed exceptionally???");
                finalizer.run();
                return true;
            }
            boolean shouldContinue = taskWatcher.test(progress[0]);
            if (!shouldContinue) {
                isAborted.obj = true;
                future.cancel(true);
                finalizer.run();
                return true;
            }
            return false;
        });
    }

    public static <ENTITY extends Entity> Stream<ENTITY> getEntitiesNearby(World world, Vector3d center, Class<ENTITY> entityClass, double range) {
        AxisAlignedBB box = new AxisAlignedBB(center, center).func_186662_g(range);
        return world.func_175647_a(entityClass, box, e -> true).stream();
    }

    public static <ENTITY extends Entity> Stream<ENTITY> getEntitiesNearby(Entity center, Class<ENTITY> entityClass, double range) {
        return McHelper.getEntitiesNearby(center.field_70170_p, center.func_213303_ch(), entityClass, range);
    }

    public static void runWithTransformation(MatrixStack matrixStack, Runnable renderingFunc) {
        McHelper.transformationPush(matrixStack);
        renderingFunc.run();
        McHelper.transformationPop();
    }

    public static void transformationPop() {
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
    }

    public static void transformationPush(MatrixStack matrixStack) {
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
    }

    public static List<GlobalTrackedPortal> getGlobalPortals(World world) {
        List<GlobalTrackedPortal> result = world.func_201670_d() ? CHelper.getClientGlobalPortal(world) : (world instanceof ServerWorld ? GlobalPortalStorage.get((ServerWorld)((ServerWorld)world)).data : null);
        return result != null ? result : Collections.emptyList();
    }

    public static Stream<Portal> getServerPortalsNearby(Entity center, double range) {
        List<GlobalTrackedPortal> globalPortals = GlobalPortalStorage.get((ServerWorld)((ServerWorld)center.field_70170_p)).data;
        Stream<Portal> nearbyPortals = McHelper.getServerEntitiesNearbyWithoutLoadingChunk(center.field_70170_p, center.func_213303_ch(), Portal.class, range);
        if (globalPortals == null) {
            return nearbyPortals;
        }
        return Streams.concat((Stream[])new Stream[]{globalPortals.stream().filter(p -> p.getDistanceToNearestPointInPortal(center.func_213303_ch()) < range * 2.0), nearbyPortals});
    }

    public static int getRenderDistanceOnServer() {
        return McHelper.getIEStorage((RegistryKey<World>)World.field_234918_g_).getWatchDistance();
    }

    public static void setPosAndLastTickPos(Entity entity, Vector3d pos, Vector3d lastTickPos) {
        entity.func_226288_n_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entity.field_70142_S = lastTickPos.field_72450_a;
        entity.field_70137_T = lastTickPos.field_72448_b;
        entity.field_70136_U = lastTickPos.field_72449_c;
        entity.field_70169_q = lastTickPos.field_72450_a;
        entity.field_70167_r = lastTickPos.field_72448_b;
        entity.field_70166_s = lastTickPos.field_72449_c;
    }

    public static Vector3d getEyePos(Entity entity) {
        float eyeHeight = entity.func_70047_e();
        return entity.func_213303_ch().func_72441_c(0.0, (double)eyeHeight, 0.0);
    }

    public static Vector3d getLastTickEyePos(Entity entity) {
        float eyeHeight = entity.func_70047_e();
        return McHelper.lastTickPosOf(entity).func_72441_c(0.0, (double)eyeHeight, 0.0);
    }

    public static void setEyePos(Entity entity, Vector3d eyePos, Vector3d lastTickEyePos) {
        float eyeHeight = entity.func_70047_e();
        McHelper.setPosAndLastTickPos(entity, eyePos.func_72441_c(0.0, (double)(-eyeHeight), 0.0), lastTickEyePos.func_72441_c(0.0, (double)(-eyeHeight), 0.0));
    }

    public static double getVehicleY(Entity vehicle, Entity passenger) {
        return passenger.func_226278_cu_() - vehicle.func_70042_X() - passenger.func_70033_W();
    }

    public static void adjustVehicle(Entity entity) {
        Entity vehicle = entity.func_184187_bx();
        if (vehicle == null) {
            return;
        }
        vehicle.func_70107_b(entity.func_226277_ct_(), McHelper.getVehicleY(vehicle, entity), entity.func_226281_cx_());
    }

    public static Chunk getServerChunkIfPresent(RegistryKey<World> dimension, int x, int z) {
        ChunkHolder chunkHolder_ = McHelper.getIEStorage(dimension).getChunkHolder_(ChunkPos.func_77272_a((int)x, (int)z));
        if (chunkHolder_ == null) {
            return null;
        }
        return chunkHolder_.func_219298_c();
    }

    public static Chunk getServerChunkIfPresent(ServerWorld world, int x, int z) {
        ChunkHolder chunkHolder_ = ((IEThreadedAnvilChunkStorage)world.func_72863_F().field_217237_a).getChunkHolder_(ChunkPos.func_77272_a((int)x, (int)z));
        if (chunkHolder_ == null) {
            return null;
        }
        return chunkHolder_.func_219298_c();
    }

    public static <ENTITY extends Entity> Stream<ENTITY> getServerEntitiesNearbyWithoutLoadingChunk(World world, Vector3d center, Class<ENTITY> entityClass, double range) {
        return McHelper.findEntitiesRough(entityClass, world, center, (int)(range / 16.0), e -> true).stream();
    }

    public static void updateBoundingBox(Entity player) {
        player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
    }

    public static <T extends Entity> List<T> getEntitiesRegardingLargeEntities(World world, AxisAlignedBB box, double maxEntitySizeHalf, Class<T> entityClass, Predicate<T> predicate) {
        return McHelper.findEntitiesByBox(entityClass, world, box, maxEntitySizeHalf, predicate);
    }

    public static void onClientEntityTick(Entity entity) {
        CrossPortalEntityRenderer.onEntityTickClient(entity);
    }

    public static ChunkAccessor getChunkAccessor(World world) {
        if (world.func_201670_d()) {
            return (arg_0, arg_1) -> ((World)world).func_212866_a_(arg_0, arg_1);
        }
        return (x, z) -> McHelper.getServerChunkIfPresent((ServerWorld)world, x, z);
    }

    public static <T extends Entity> List<T> findEntities(Class<T> entityClass, ChunkAccessor chunkAccessor, int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Predicate<T> predicate) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                Chunk chunk = chunkAccessor.getChunk(x, z);
                if (chunk == null) continue;
                ClassInheritanceMultiMap<Entity>[] entitySections = ((IEWorldChunk)chunk).getEntitySections();
                for (int i = chunkYStart; i <= chunkYEnd; ++i) {
                    ClassInheritanceMultiMap<Entity> entitySection = entitySections[i];
                    for (Entity entity : entitySection.func_219790_a(entityClass)) {
                        if (!predicate.test(entity)) continue;
                        result.add(entity);
                    }
                }
            }
        }
        return result;
    }

    public static <T extends Entity> List<T> findEntitiesRough(Class<T> entityClass, World world, Vector3d center, int radiusChunks, Predicate<T> predicate) {
        if (radiusChunks == 0) {
            radiusChunks = 1;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(center));
        return McHelper.findEntities(entityClass, McHelper.getChunkAccessor(world), chunkPos.field_77276_a - radiusChunks, chunkPos.field_77276_a + radiusChunks, 0, 15, chunkPos.field_77275_b - radiusChunks, chunkPos.field_77275_b + radiusChunks, predicate);
    }

    public static <T extends Entity> List<T> findEntitiesByBox(Class<T> entityClass, World world, AxisAlignedBB box, double maxEntityRadius, Predicate<T> predicate) {
        int xMin = (int)Math.floor(box.field_72340_a - maxEntityRadius);
        int yMin = (int)Math.floor(box.field_72338_b - maxEntityRadius);
        int zMin = (int)Math.floor(box.field_72339_c - maxEntityRadius);
        int xMax = (int)Math.ceil(box.field_72336_d + maxEntityRadius);
        int yMax = (int)Math.ceil(box.field_72337_e + maxEntityRadius);
        int zMax = (int)Math.ceil(box.field_72334_f + maxEntityRadius);
        return McHelper.findEntities(entityClass, McHelper.getChunkAccessor(world), xMin >> 4, xMax >> 4, Math.max(0, yMin >> 4), Math.min(15, yMax >> 4), zMin >> 4, zMax >> 4, e -> e.func_174813_aQ().func_72326_a(box) && predicate.test(e));
    }

    public static ResourceLocation dimensionTypeId(RegistryKey<World> dimType) {
        return dimType.func_240901_a_();
    }

    public static <T> String serializeToJson(T object, Codec<T> codec) {
        DataResult r = codec.encode(object, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
        Either either = r.get();
        JsonElement result = either.left().orElse(null);
        if (result != null) {
            return Global.gson.toJson(result);
        }
        return either.right().map(DataResult.PartialResult::toString).orElse("");
    }

    public static Vector3d getCurrentCameraPos() {
        return Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
    }

    public static <T, Serialized> T decodeFailHard(Codec<T> codec, DynamicOps<Serialized> ops, Serialized target) {
        return (T)((Pair)codec.decode(ops, target).getOrThrow(false, s -> {
            throw new MyDecodeException("Cannot decode" + s + target);
        })).getFirst();
    }

    public static <Serialized> Serialized getElementFailHard(DynamicOps<Serialized> ops, Serialized target, String key) {
        return (Serialized)ops.get(target, key).getOrThrow(false, s -> {
            throw new MyDecodeException("Cannot find" + key + s + target);
        });
    }

    public static <T, Serialized> void encode(Codec<T> codec, DynamicOps<Serialized> ops, Serialized target, T object) {
        codec.encode(object, ops, target);
    }

    public static <Serialized, T> T decodeElementFailHard(DynamicOps<Serialized> ops, Serialized input, Codec<T> codec, String key) {
        return McHelper.decodeFailHard(codec, ops, McHelper.getElementFailHard(ops, input, key));
    }

    public static void sendMessageToFirstLoggedPlayer(ITextComponent text) {
        Helper.log(text.func_150261_e());
        ModMain.serverTaskList.addTask(() -> {
            MinecraftServer server = McHelper.getServer();
            if (server == null) {
                return false;
            }
            List playerList = server.func_184103_al().func_181057_v();
            if (playerList.isEmpty()) {
                return false;
            }
            for (ServerPlayerEntity player : playerList) {
                player.func_146105_b(text, false);
            }
            return true;
        });
    }

    public static Iterable<Entity> getWorldEntityList(World world) {
        if (world.func_201670_d()) {
            return CHelper.getWorldEntityList(world);
        }
        if (world instanceof ServerWorld) {
            return ((ServerWorld)world).func_241136_z_();
        }
        return (Iterable)((Object)Collections.emptyList().iterator());
    }

    public static void spawnServerEntityToUnloadedArea(Entity entity) {
        Validate.isTrue((!entity.field_70170_p.func_201670_d() ? 1 : 0) != 0);
        entity.field_98038_p = true;
        entity.field_70170_p.func_217376_c(entity);
        entity.field_98038_p = false;
    }

    public static void executeOnServerThread(Runnable runnable) {
        MinecraftServer server = McHelper.getServer();
        if (server.func_213162_bc()) {
            runnable.run();
        } else {
            server.execute(runnable);
        }
    }

    public static <T> SimpleRegistry<T> filterAndCopyRegistry(SimpleRegistry<T> registry, BiPredicate<RegistryKey<T>, T> predicate) {
        SimpleRegistry newRegistry = new SimpleRegistry(registry.func_243578_f(), registry.func_241875_b());
        for (Map.Entry entry : registry.func_239659_c_()) {
            Object object = entry.getValue();
            RegistryKey key = (RegistryKey)entry.getKey();
            if (!predicate.test((RegistryKey<RegistryKey>)key, (RegistryKey)object)) continue;
            newRegistry.func_218381_a(key, object, registry.func_241876_d(object));
        }
        return newRegistry;
    }

    public static ServerWorld getServerWorld(RegistryKey<World> dim) {
        ServerWorld world = McHelper.getServer().func_71218_a(dim);
        if (world == null) {
            throw new RuntimeException("Missing dimension " + dim.func_240901_a_());
        }
        return world;
    }

    public static class MyDecodeException
    extends RuntimeException {
        public MyDecodeException(String message) {
            super(message);
        }
    }

    public static interface ChunkAccessor {
        public Chunk getChunk(int var1, int var2);
    }
}

