/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals;

import com.google.common.collect.Streams;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.block_manipulation.BlockManipulationClient;
import com.qouteall.immersive_portals.ducks.IERayTraceContext;
import com.qouteall.immersive_portals.ducks.IEWorldChunk;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.Portal;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Helper {
    private static final Logger LOGGER = LogManager.getLogger((String)"Portal");

    public static FloatBuffer getModelViewMatrix() {
        return Helper.getMatrix(2982);
    }

    public static FloatBuffer getProjectionMatrix() {
        return Helper.getMatrix(2983);
    }

    public static FloatBuffer getTextureMatrix() {
        return Helper.getMatrix(2984);
    }

    public static FloatBuffer getMatrix(int matrixId) {
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)matrixId, (FloatBuffer)temp);
        return temp;
    }

    public static double getCollidingT(Vector3d planeCenter, Vector3d planeNormal, Vector3d lineCenter, Vector3d lineDirection) {
        return planeCenter.func_178788_d(lineCenter).func_72430_b(planeNormal) / lineDirection.func_72430_b(planeNormal);
    }

    public static boolean isInFrontOfPlane(Vector3d pos, Vector3d planePos, Vector3d planeNormal) {
        return pos.func_178788_d(planePos).func_72430_b(planeNormal) > 0.0;
    }

    public static Vector3d fallPointOntoPlane(Vector3d point, Vector3d planePos, Vector3d planeNormal) {
        double t = Helper.getCollidingT(planePos, planeNormal, point, planeNormal);
        return point.func_178787_e(planeNormal.func_186678_a(t));
    }

    public static Vector3i getUnitFromAxis(Direction.Axis axis) {
        return Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_176730_m();
    }

    public static int getCoordinate(Vector3i v, Direction.Axis axis) {
        return axis.func_196052_a(v.func_177958_n(), v.func_177956_o(), v.func_177952_p());
    }

    public static double getCoordinate(Vector3d v, Direction.Axis axis) {
        return axis.func_196051_a(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public static int getCoordinate(Vector3i v, Direction direction) {
        return Helper.getCoordinate(v, direction.func_176740_k()) * (direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : -1);
    }

    public static Vector3d putCoordinate(Vector3d v, Direction.Axis axis, double value) {
        if (axis == Direction.Axis.X) {
            return new Vector3d(value, v.field_72448_b, v.field_72449_c);
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3d(v.field_72450_a, value, v.field_72449_c);
        }
        return new Vector3d(v.field_72450_a, v.field_72448_b, value);
    }

    public static <A, B> Tuple<B, A> swaped(Tuple<A, B> p) {
        return new Tuple(p.func_76340_b(), p.func_76341_a());
    }

    public static <T> T uniqueOfThree(T a, T b, T c) {
        if (a.equals(b)) {
            return c;
        }
        if (b.equals(c)) {
            return a;
        }
        assert (a.equals(c));
        return b;
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.func_177958_n(), b.func_177958_n()), Math.max(a.func_177956_o(), b.func_177956_o()), Math.max(a.func_177952_p(), b.func_177952_p()));
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.func_177958_n(), b.func_177958_n()), Math.min(a.func_177956_o(), b.func_177956_o()), Math.min(a.func_177952_p(), b.func_177952_p()));
    }

    public static Tuple<Direction.Axis, Direction.Axis> getAnotherTwoAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return new Tuple((Object)Direction.Axis.Y, (Object)Direction.Axis.Z);
            }
            case Y: {
                return new Tuple((Object)Direction.Axis.Z, (Object)Direction.Axis.X);
            }
            case Z: {
                return new Tuple((Object)Direction.Axis.X, (Object)Direction.Axis.Y);
            }
        }
        throw new IllegalArgumentException();
    }

    public static BlockPos scale(Vector3i v, int m) {
        return new BlockPos(v.func_177958_n() * m, v.func_177956_o() * m, v.func_177952_p() * m);
    }

    public static BlockPos divide(Vector3i v, int d) {
        return new BlockPos(v.func_177958_n() / d, v.func_177956_o() / d, v.func_177952_p() / d);
    }

    public static Direction[] getAnotherFourDirections(Direction.Axis axisOfNormal) {
        Tuple<Direction.Axis, Direction.Axis> anotherTwoAxis = Helper.getAnotherTwoAxis(axisOfNormal);
        return new Direction[]{Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.func_76341_a())), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.func_76340_b())), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.func_76341_a())), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.func_76340_b()))};
    }

    @Deprecated
    public static Tuple<Direction.Axis, Direction.Axis> getPerpendicularAxis(Direction facing) {
        Tuple axises = Helper.getAnotherTwoAxis(facing.func_176740_k());
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            axises = new Tuple(axises.func_76340_b(), axises.func_76341_a());
        }
        return axises;
    }

    public static Tuple<Direction, Direction> getPerpendicularDirections(Direction facing) {
        Tuple axises = Helper.getAnotherTwoAxis(facing.func_176740_k());
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            axises = new Tuple(axises.func_76340_b(), axises.func_76341_a());
        }
        return new Tuple((Object)Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)axises.func_76341_a())), (Object)Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)axises.func_76340_b())));
    }

    public static Vector3d getBoxSize(AxisAlignedBB box) {
        return new Vector3d(box.func_216364_b(), box.func_216360_c(), box.func_216362_d());
    }

    public static AxisAlignedBB getBoxSurfaceInversed(AxisAlignedBB box, Direction direction) {
        double size = Helper.getCoordinate(Helper.getBoxSize(box), direction.func_176740_k());
        Vector3d shrinkVec = Vector3d.func_237491_b_((Vector3i)direction.func_176730_m()).func_186678_a(size);
        return box.func_191195_a(shrinkVec.field_72450_a, shrinkVec.field_72448_b, shrinkVec.field_72449_c);
    }

    public static AxisAlignedBB getBoxSurface(AxisAlignedBB box, Direction direction) {
        return Helper.getBoxSurfaceInversed(box, direction.func_176734_d());
    }

    public static IntBox expandRectangle(BlockPos startingPos, Predicate<BlockPos> blockPosPredicate, Direction.Axis axis) {
        IntBox wallArea = new IntBox(startingPos, startingPos);
        for (Direction direction : Helper.getAnotherFourDirections(axis)) {
            wallArea = Helper.expandArea(wallArea, blockPosPredicate, direction);
        }
        return wallArea;
    }

    public static int getChebyshevDistance(int x1, int z1, int x2, int z2) {
        return Math.max(Math.abs(x1 - x2), Math.abs(z1 - z2));
    }

    @Nullable
    public static <T> T getLastSatisfying(Stream<T> stream, Predicate<T> predicate) {
        T last = null;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (predicate.test(obj)) {
                last = obj;
                continue;
            }
            return last;
        }
        return last;
    }

    public static Runnable noException(Callable func) {
        return () -> {
            try {
                func.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
    }

    public static void doNotEatExceptionMessage(Runnable func) {
        try {
            func.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static <T> String myToString(Stream<T> stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stream.forEach(obj -> {
            stringBuilder.append(obj.toString());
            stringBuilder.append('\n');
        });
        return stringBuilder.toString();
    }

    public static <A, B> Stream<Tuple<A, B>> composeTwoStreamsWithEqualLength(Stream<A> a, Stream<B> b) {
        final Iterator aIterator = a.iterator();
        final Iterator bIterator = b.iterator();
        Iterator iterator = new Iterator<Tuple<A, B>>(){

            @Override
            public boolean hasNext() {
                assert (aIterator.hasNext() == bIterator.hasNext());
                return aIterator.hasNext();
            }

            @Override
            public Tuple<A, B> next() {
                return new Tuple(aIterator.next(), bIterator.next());
            }
        };
        return Streams.stream((Iterator)iterator);
    }

    public static void log(Object str) {
        LOGGER.info(str);
    }

    public static void err(Object str) {
        LOGGER.error(str);
    }

    public static void dbg(Object str) {
        LOGGER.debug(str);
    }

    public static Vector3d[] eightVerticesOf(AxisAlignedBB box) {
        return new Vector3d[]{new Vector3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new Vector3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), new Vector3d(box.field_72340_a, box.field_72337_e, box.field_72339_c), new Vector3d(box.field_72340_a, box.field_72337_e, box.field_72334_f), new Vector3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), new Vector3d(box.field_72336_d, box.field_72338_b, box.field_72334_f), new Vector3d(box.field_72336_d, box.field_72337_e, box.field_72339_c), new Vector3d(box.field_72336_d, box.field_72337_e, box.field_72334_f)};
    }

    public static void putVec3d(CompoundNBT compoundTag, String name, Vector3d vec3d) {
        compoundTag.func_74780_a(name + "X", vec3d.field_72450_a);
        compoundTag.func_74780_a(name + "Y", vec3d.field_72448_b);
        compoundTag.func_74780_a(name + "Z", vec3d.field_72449_c);
    }

    public static Vector3d getVec3d(CompoundNBT compoundTag, String name) {
        return new Vector3d(compoundTag.func_74769_h(name + "X"), compoundTag.func_74769_h(name + "Y"), compoundTag.func_74769_h(name + "Z"));
    }

    public static void putVec3i(CompoundNBT compoundTag, String name, Vector3i vec3i) {
        compoundTag.func_74768_a(name + "X", vec3i.func_177958_n());
        compoundTag.func_74768_a(name + "Y", vec3i.func_177956_o());
        compoundTag.func_74768_a(name + "Z", vec3i.func_177952_p());
    }

    public static BlockPos getVec3i(CompoundNBT compoundTag, String name) {
        return new BlockPos(compoundTag.func_74762_e(name + "X"), compoundTag.func_74762_e(name + "Y"), compoundTag.func_74762_e(name + "Z"));
    }

    public static <T> void compareOldAndNew(Set<T> oldSet, Set<T> newSet, Consumer<T> forRemoved, Consumer<T> forAdded) {
        oldSet.stream().filter(e -> !newSet.contains(e)).forEach(forRemoved);
        newSet.stream().filter(e -> !oldSet.contains(e)).forEach(forAdded);
    }

    public static long secondToNano(double second) {
        return (long)(second * 1.0E9);
    }

    public static double nanoToSecond(long nano) {
        return (double)nano / 1.0E9;
    }

    public static IntBox expandArea(IntBox originalArea, Predicate<BlockPos> predicate, Direction direction) {
        IntBox currentBox = originalArea;
        for (int i = 1; i < 42; ++i) {
            IntBox expanded = currentBox.getExpanded(direction, 1);
            if (!expanded.getSurfaceLayer(direction).stream().allMatch(predicate)) {
                return currentBox;
            }
            currentBox = expanded;
        }
        return currentBox;
    }

    public static <A, B> B reduce(B start, Stream<A> stream, BiFunction<B, A, B> func) {
        return stream.reduce(start, func, (a, b) -> {
            throw new IllegalStateException("combiner should only be used in parallel");
        });
    }

    public static <T> T noError(Callable<T> func) {
        try {
            return func.call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void noError(ExceptionalRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void removeIf(ObjectList<T> list, Predicate<T> predicate) {
        int placingIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object curr = list.get(i);
            if (predicate.test(curr)) continue;
            list.set(placingIndex, curr);
            ++placingIndex;
        }
        list.removeElements(placingIndex, list.size());
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap(Stream<T> stream, final BiFunction<T, T, S> function) {
        final Iterator iterator = stream.iterator();
        return Streams.stream((Iterator)new Iterator<S>(){
            private boolean isBuffered = false;
            private T buffer;

            private void fillBuffer() {
                if (!this.isBuffered) {
                    assert (iterator.hasNext());
                    this.isBuffered = true;
                    this.buffer = iterator.next();
                }
            }

            private T takeBuffer() {
                assert (this.isBuffered);
                this.isBuffered = false;
                return this.buffer;
            }

            @Override
            public boolean hasNext() {
                if (!iterator.hasNext()) {
                    return false;
                }
                this.fillBuffer();
                return iterator.hasNext();
            }

            @Override
            public S next() {
                this.fillBuffer();
                Object a = this.takeBuffer();
                this.fillBuffer();
                return function.apply(a, this.buffer);
            }
        });
    }

    public static <A, B> Stream<B> mapReduce(Stream<A> stream, BiFunction<B, A, B> func, SimpleBox<B> startValue) {
        return stream.map(a -> {
            startValue.obj = func.apply(startValue.obj, a);
            return startValue.obj;
        });
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap1(Stream<T> stream, BiFunction<T, T, S> function) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return Stream.empty();
        }
        Object firstValue = iterator.next();
        Stream newStream = Streams.stream(iterator);
        return Helper.mapReduce(newStream, (lastPair, curr) -> new Tuple(curr, function.apply(lastPair.func_76341_a(), curr)), new SimpleBox<Tuple>(new Tuple(firstValue, null))).map(pair -> pair.func_76340_b());
    }

    public static <T> T makeIntoExpression(T t, Consumer<T> func) {
        func.accept(t);
        return t;
    }

    public static void putUuid(CompoundNBT tag, String key, UUID uuid) {
        tag.func_74772_a(key + "Most", uuid.getMostSignificantBits());
        tag.func_74772_a(key + "Least", uuid.getLeastSignificantBits());
    }

    public static UUID getUuid(CompoundNBT tag, String key) {
        return new UUID(tag.func_74763_f(key + "Most"), tag.func_74763_f(key + "Least"));
    }

    public static Vector3d getFlippedVec(Vector3d vec, Vector3d flippingAxis) {
        Vector3d component = Helper.getProjection(vec, flippingAxis);
        return vec.func_178788_d(component).func_186678_a(-1.0).func_178787_e(component);
    }

    public static Vector3d getProjection(Vector3d vec, Vector3d direction) {
        return direction.func_186678_a(vec.func_72430_b(direction));
    }

    public static <T extends Entity> List<T> getNearbyEntities(World world, Vector3d pos, int chunkRadius, Class<T> entityClass) {
        ArrayList entities = new ArrayList();
        int chunkX = (int)pos.field_72450_a / 16;
        int chunkZ = (int)pos.field_72449_c / 16;
        for (int z = -chunkRadius + 1; z < chunkRadius; ++z) {
            for (int x = -chunkRadius + 1; x < chunkRadius; ++x) {
                ClassInheritanceMultiMap<Entity>[] entitySections;
                int aX = chunkX + x;
                int aZ = chunkZ + z;
                for (ClassInheritanceMultiMap<Entity> entitySection : entitySections = ((IEWorldChunk)world.func_212866_a_(aX, aZ)).getEntitySections()) {
                    entities.addAll(entitySection.func_219790_a(entityClass));
                }
            }
        }
        return entities;
    }

    public static List<Tuple<Portal, Vector3d>> rayTracePortals(World world, Vector3d start, Vector3d end, boolean includeGlobalPortals, Predicate<Portal> filter) {
        Vector3d middle = start.func_186678_a(0.5).func_178787_e(end.func_186678_a(0.5));
        int chunkRadius = (int)Math.ceil(Math.abs(start.func_72438_d(end) / 2.0) / 16.0);
        List<Portal> nearby = Helper.getNearbyEntities(world, middle, chunkRadius, Portal.class);
        if (includeGlobalPortals) {
            nearby.addAll(McHelper.getGlobalPortals(world));
        }
        ArrayList<Tuple<Portal, Vector3d>> hits = new ArrayList<Tuple<Portal, Vector3d>>();
        nearby.forEach(portal -> {
            Vector3d intersection;
            if ((filter == null || filter.test((Portal)((Object)portal))) && (intersection = portal.rayTrace(start, end)) != null) {
                hits.add(new Tuple((Object)portal, (Object)intersection));
            }
        });
        hits.sort((pair1, pair2) -> {
            Vector3d intersection1 = (Vector3d)pair1.func_76340_b();
            Vector3d intersection2 = (Vector3d)pair2.func_76340_b();
            return (int)Math.signum(intersection1.func_72436_e(start) - intersection2.func_72436_e(start));
        });
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    private static <T> T withSwitchedContextClient(ClientWorld world, Supplier<T> func) {
        boolean wasContextSwitched = BlockManipulationClient.isContextSwitched;
        Minecraft client = Minecraft.func_71410_x();
        ClientWorld lastWorld = client.field_71441_e;
        try {
            BlockManipulationClient.isContextSwitched = true;
            client.field_71441_e = world;
            T t = func.get();
            return t;
        }
        finally {
            client.field_71441_e = lastWorld;
            BlockManipulationClient.isContextSwitched = wasContextSwitched;
        }
    }

    private static <T> T withSwitchedContextServer(ServerWorld world, Supplier<T> func) {
        return func.get();
    }

    private static <T> T withSwitchedContext(World world, Supplier<T> func) {
        if (world.field_72995_K) {
            return Helper.withSwitchedContextClient((ClientWorld)world, func);
        }
        return Helper.withSwitchedContextServer((ServerWorld)world, func);
    }

    private static Tuple<BlockRayTraceResult, List<Portal>> rayTrace(World world, RayTraceContext context, boolean includeGlobalPortals, List<Portal> portals) {
        Vector3d start = context.func_222253_b();
        Vector3d end = context.func_222250_a();
        if (portals.size() > Global.maxPortalLayer) {
            Vector3d diff = end.func_178788_d(start);
            return new Tuple((Object)BlockRayTraceResult.func_216352_a((Vector3d)end, (Direction)Direction.func_210769_a((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c), (BlockPos)new BlockPos(end)), portals);
        }
        BlockRayTraceResult hitResult = world.func_217299_a(context);
        List rayTracedPortals = Helper.withSwitchedContext(world, () -> Helper.rayTracePortals(world, start, end, includeGlobalPortals, Portal::isInteractable));
        if (rayTracedPortals.isEmpty()) {
            return new Tuple((Object)hitResult, portals);
        }
        Tuple portalHit = (Tuple)rayTracedPortals.get(0);
        Portal portal = (Portal)((Object)portalHit.func_76341_a());
        Vector3d intersection = (Vector3d)portalHit.func_76340_b();
        if (hitResult.func_216347_e().func_72436_e(start) < intersection.func_72436_e(start)) {
            return new Tuple((Object)hitResult, portals);
        }
        IERayTraceContext betterContext = (IERayTraceContext)context;
        betterContext.setStart(portal.transformPoint(intersection)).setEnd(portal.transformPoint(end));
        portals.add(portal);
        World destWorld = portal.getDestinationWorld(world.field_72995_K);
        Tuple recursion = Helper.withSwitchedContext(destWorld, () -> Helper.rayTrace(destWorld, context, includeGlobalPortals, portals));
        betterContext.setStart(start).setEnd(end);
        return recursion;
    }

    public static Tuple<BlockRayTraceResult, List<Portal>> rayTrace(World world, RayTraceContext context, boolean includeGlobalPortals) {
        return Helper.rayTrace(world, context, includeGlobalPortals, new ArrayList<Portal>());
    }

    public static boolean hitResultIsMissedOrNull(RayTraceResult hitResult) {
        return hitResult == null || hitResult.func_216346_c() == RayTraceResult.Type.MISS;
    }

    public static Direction getFacingExcludingAxis(Vector3d vec, Direction.Axis axis) {
        return Arrays.stream(Direction.values()).filter(d -> d.func_176740_k() != axis).max(Comparator.comparingDouble(dir -> vec.field_72450_a * (double)dir.func_82601_c() + vec.field_72448_b * (double)dir.func_96559_d() + vec.field_72449_c * (double)dir.func_82599_e())).orElse(null);
    }

    public static Portal placePortal(double width, double height, Entity entity) {
        Vector3d playerLook = entity.func_70040_Z();
        Tuple<BlockRayTraceResult, List<Portal>> rayTrace = Helper.rayTrace(entity.field_70170_p, new RayTraceContext(entity.func_174824_e(1.0f), entity.func_174824_e(1.0f).func_178787_e(playerLook.func_186678_a(100.0)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, entity), true);
        BlockRayTraceResult hitResult = (BlockRayTraceResult)rayTrace.func_76341_a();
        List hitPortals = (List)rayTrace.func_76340_b();
        if (Helper.hitResultIsMissedOrNull((RayTraceResult)hitResult)) {
            return null;
        }
        for (Portal hitPortal : hitPortals) {
            playerLook = hitPortal.transformLocalVecNonScale(playerLook);
        }
        Direction lookingDirection = Helper.getFacingExcludingAxis(playerLook, hitResult.func_216354_b().func_176740_k());
        if (lookingDirection == null) {
            return null;
        }
        Vector3d axisH = Vector3d.func_237491_b_((Vector3i)hitResult.func_216354_b().func_176730_m());
        Vector3d axisW = axisH.func_72431_c(Vector3d.func_237491_b_((Vector3i)lookingDirection.func_176734_d().func_176730_m()));
        Vector3d pos = Vector3d.func_237489_a_((Vector3i)hitResult.func_216350_a()).func_178787_e(axisH.func_186678_a(0.5 + height / 2.0));
        World world = hitPortals.isEmpty() ? entity.field_70170_p : ((Portal)((Object)hitPortals.get(hitPortals.size() - 1))).getDestinationWorld(false);
        Portal portal = new Portal(Portal.entityType, world);
        portal.func_226288_n_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        portal.axisW = axisW;
        portal.axisH = axisH;
        portal.width = width;
        portal.height = height;
        return portal;
    }

    public static <T> Supplier<T> cached(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T cache = null;

            @Override
            public T get() {
                if (this.cache == null) {
                    this.cache = supplier.get();
                }
                return this.cache;
            }
        };
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            T ele = list.get(i);
            if (!predicate.test(ele)) continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitStringByLen(String str, int len) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i * len < str.length()) {
            result.add(str.substring(i * len, Math.min(str.length(), (i + 1) * len)));
            ++i;
        }
        return result;
    }

    public static interface ExceptionalRunnable {
        public void run() throws Throwable;
    }

    public static interface CallableWithoutException<T> {
        public T run();
    }

    public static class SimpleBox<T> {
        public T obj;

        public SimpleBox(T obj) {
            this.obj = obj;
        }
    }
}

