/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals;

import com.qouteall.immersive_portals.Helper;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class ClippedBlockView
implements IBlockReader {
    public IBlockReader delegate;
    public Vector3d clipPos;
    public Vector3d contentDirection;
    public Entity raytraceDefaultEntity;

    public ClippedBlockView(IBlockReader delegate, Vector3d clipPos, Vector3d contentDirection, Entity raytraceDefaultEntity) {
        this.delegate = delegate;
        this.clipPos = clipPos;
        this.contentDirection = contentDirection;
        this.raytraceDefaultEntity = raytraceDefaultEntity;
    }

    public boolean isClipped(BlockPos pos) {
        return Vector3d.func_237489_a_((Vector3i)pos).func_178788_d(this.clipPos).func_72430_b(this.contentDirection) < 0.0;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.delegate.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (this.isClipped(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.delegate.func_180495_p(pos);
    }

    public FluidState func_204610_c(BlockPos pos) {
        if (this.isClipped(pos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return this.delegate.func_204610_c(pos);
    }

    public int func_217298_h(BlockPos pos) {
        return this.delegate.func_217298_h(pos);
    }

    public int func_201572_C() {
        return this.delegate.func_201572_C();
    }

    public int func_217301_I() {
        return this.delegate.func_217301_I();
    }

    public Stream<BlockState> func_234853_a_(AxisAlignedBB box) {
        return this.delegate.func_234853_a_(box);
    }

    public BlockRayTraceResult func_217299_a(RayTraceContext context) {
        Vector3d delta = context.func_222250_a().func_178788_d(context.func_222253_b());
        double t = Helper.getCollidingT(this.clipPos, this.contentDirection, context.func_222253_b(), delta);
        Vector3d startPos = context.func_222253_b().func_178787_e(delta.func_186678_a(t));
        return this.func_217299_a(new RayTraceContext(startPos, context.func_222250_a(), RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, this.raytraceDefaultEntity));
    }

    @Nullable
    public BlockRayTraceResult func_217296_a(Vector3d start, Vector3d end, BlockPos pos, VoxelShape shape, BlockState state) {
        return this.delegate.func_217296_a(start, end, pos, shape, state);
    }
}

