/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals;

import com.mojang.authlib.GameProfile;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.dimension_sync.DimensionTypeSync;
import com.qouteall.immersive_portals.ducks.IEClientPlayNetworkHandler;
import com.qouteall.immersive_portals.ducks.IEClientWorld;
import com.qouteall.immersive_portals.ducks.IEParticleManager;
import com.qouteall.immersive_portals.ducks.IEWorld;
import com.qouteall.immersive_portals.render.context_management.DimensionRenderHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;

@OnlyIn(value=Dist.CLIENT)
public class ClientWorldLoader {
    public final Map<RegistryKey<World>, ClientWorld> clientWorldMap = new HashMap<RegistryKey<World>, ClientWorld>();
    public final Map<RegistryKey<World>, WorldRenderer> worldRendererMap = new HashMap<RegistryKey<World>, WorldRenderer>();
    public final Map<RegistryKey<World>, DimensionRenderHelper> renderHelperMap = new HashMap<RegistryKey<World>, DimensionRenderHelper>();
    private Set<DimensionalChunkPos> unloadedChunks = new HashSet<DimensionalChunkPos>();
    private Minecraft client = Minecraft.func_71410_x();
    private boolean isInitialized = false;
    private boolean isLoadingFakedWorld = false;
    private boolean isHardCore = false;
    public boolean isClientRemoteTicking = false;
    public int ticksSinceEnteringWorld = 0;
    private static int reportedErrorNum = 0;

    public ClientWorldLoader() {
        ModMain.postClientTickSignal.connectWithWeakRef(this, ClientWorldLoader::tick);
    }

    public boolean getIsLoadingFakedWorld() {
        return this.isLoadingFakedWorld;
    }

    private void tick() {
        if (CGlobal.isClientRemoteTickingEnabled) {
            this.isClientRemoteTicking = true;
            this.clientWorldMap.values().forEach(world -> {
                if (this.client.field_71441_e != world) {
                    this.tickRemoteWorld((ClientWorld)world);
                }
            });
            this.worldRendererMap.values().forEach(worldRenderer -> {
                if (worldRenderer != this.client.field_71438_f) {
                    worldRenderer.func_72734_e();
                }
            });
            this.isClientRemoteTicking = false;
        }
        boolean lightmapTextureConflict = false;
        for (DimensionRenderHelper helper : this.renderHelperMap.values()) {
            helper.tick();
            if (helper.world == this.client.field_71441_e || helper.lightmapTexture != this.client.field_71460_t.func_228384_l_()) continue;
            Helper.err(String.format("Lightmap Texture Conflict %s %s", helper.world.func_234923_W_(), this.client.field_71441_e.func_234923_W_()));
            lightmapTextureConflict = true;
        }
        if (lightmapTextureConflict) {
            this.renderHelperMap.values().forEach(DimensionRenderHelper::cleanUp);
            this.renderHelperMap.clear();
            Helper.log("Refreshed Lightmaps");
        }
        ++this.ticksSinceEnteringWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickRemoteWorld(ClientWorld newWorld) {
        ClientWorld oldWorld = this.client.field_71441_e;
        this.client.field_71441_e = newWorld;
        ((IEParticleManager)this.client.field_71452_i).mySetWorld(newWorld);
        try {
            newWorld.func_217419_d();
            newWorld.func_72835_b(() -> true);
        }
        catch (Throwable e) {
            if (reportedErrorNum < 200) {
                e.printStackTrace();
                ++reportedErrorNum;
            }
        }
        finally {
            this.client.field_71441_e = oldWorld;
            ((IEParticleManager)this.client.field_71452_i).mySetWorld(oldWorld);
        }
    }

    public void cleanUp() {
        this.worldRendererMap.values().forEach(worldRenderer -> worldRenderer.func_72732_a(null));
        this.clientWorldMap.clear();
        this.worldRendererMap.clear();
        this.renderHelperMap.values().forEach(DimensionRenderHelper::cleanUp);
        this.renderHelperMap.clear();
        this.isInitialized = false;
        ModMain.clientTaskList.forceClearTasks();
        this.ticksSinceEnteringWorld = 0;
    }

    public WorldRenderer getWorldRenderer(RegistryKey<World> dimension) {
        this.initializeIfNeeded();
        return this.worldRendererMap.get(dimension);
    }

    public ClientWorld getWorld(RegistryKey<World> dimension) {
        Validate.notNull(dimension);
        this.initializeIfNeeded();
        if (!this.clientWorldMap.containsKey(dimension)) {
            return this.createFakedClientWorld(dimension);
        }
        return this.clientWorldMap.get(dimension);
    }

    public DimensionRenderHelper getDimensionRenderHelper(RegistryKey<World> dimension) {
        this.initializeIfNeeded();
        DimensionRenderHelper result = this.renderHelperMap.computeIfAbsent(dimension, dimensionType -> new DimensionRenderHelper((World)this.getWorld(dimension)));
        Validate.isTrue((result.world.func_234923_W_() == dimension ? 1 : 0) != 0);
        return result;
    }

    private void initializeIfNeeded() {
        if (!this.isInitialized) {
            Validate.isTrue((this.client.field_71441_e != null ? 1 : 0) != 0);
            Validate.isTrue((this.client.field_71438_f != null ? 1 : 0) != 0);
            Validate.notNull((Object)this.client.field_71439_g);
            Validate.isTrue((this.client.field_71439_g.field_70170_p == this.client.field_71441_e ? 1 : 0) != 0);
            RegistryKey playerDimension = this.client.field_71441_e.func_234923_W_();
            this.clientWorldMap.put((RegistryKey<World>)playerDimension, this.client.field_71441_e);
            this.worldRendererMap.put((RegistryKey<World>)playerDimension, this.client.field_71438_f);
            this.renderHelperMap.put((RegistryKey<World>)this.client.field_71441_e.func_234923_W_(), new DimensionRenderHelper((World)this.client.field_71441_e));
            this.isHardCore = this.client.field_71441_e.func_72912_H().func_76093_s();
            this.isInitialized = true;
        }
    }

    private ClientWorld createFakedClientWorld(RegistryKey<World> dimension) {
        ClientWorld newWorld;
        Validate.isTrue((this.client.field_71439_g.field_70170_p.func_234923_W_() != dimension ? 1 : 0) != 0);
        this.isLoadingFakedWorld = true;
        this.client.func_213239_aq().func_76320_a("create_world");
        int chunkLoadDistance = 3;
        WorldRenderer worldRenderer = new WorldRenderer(this.client, this.client.func_228019_au_());
        try {
            ClientPlayNetHandler newNetworkHandler = new ClientPlayNetHandler(this.client, (Screen)new ChatScreen("You should not be seeing me. I'm just a faked screen."), new NetworkManager(PacketDirection.CLIENTBOUND), new GameProfile(null, "faked_profiler_id"));
            ClientPlayNetHandler mainNetHandler = this.client.field_71439_g.field_71174_a;
            ((IEClientPlayNetworkHandler)newNetworkHandler).setPlayerListEntries(((IEClientPlayNetworkHandler)mainNetHandler).getPlayerListEntries());
            RegistryKey<DimensionType> dimensionTypeKey = DimensionTypeSync.getDimensionTypeKey(dimension);
            ClientWorld.ClientWorldInfo currentProperty = (ClientWorld.ClientWorldInfo)((IEWorld)this.client.field_71441_e).myGetProperties();
            DynamicRegistries dimensionTracker = mainNetHandler.func_239165_n_();
            ((IEClientPlayNetworkHandler)newNetworkHandler).portal_setRegistryManager(dimensionTracker);
            DimensionType dimensionType = (DimensionType)dimensionTracker.func_230520_a_().func_230516_a_(dimensionTypeKey);
            ClientWorld.ClientWorldInfo properties = new ClientWorld.ClientWorldInfo(currentProperty.func_176130_y(), currentProperty.func_76093_s(), currentProperty.func_239159_f_() < 1.0);
            newWorld = new ClientWorld(newNetworkHandler, properties, dimension, dimensionType, chunkLoadDistance, () -> this.client.func_213239_aq(), worldRenderer, this.client.field_71441_e.func_234925_Z_(), this.client.field_71441_e.func_225523_d_().field_226833_b_);
        }
        catch (Exception e) {
            throw new IllegalStateException("Creating Faked World " + dimension + " " + this.clientWorldMap.keySet(), e);
        }
        worldRenderer.func_72732_a(newWorld);
        worldRenderer.func_195410_a(this.client.func_195551_G());
        ((IEClientPlayNetworkHandler)((IEClientWorld)newWorld).getNetHandler()).setWorld(newWorld);
        this.clientWorldMap.put(dimension, newWorld);
        this.worldRendererMap.put(dimension, worldRenderer);
        Helper.log("Faked World Created " + dimension.func_240901_a_());
        this.isLoadingFakedWorld = false;
        this.client.func_213239_aq().func_76319_b();
        return newWorld;
    }
}

