/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals;

import com.google.common.collect.Streams;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.ducks.IEClientWorld;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class CHelper {
    private static int reportedErrorNum = 0;

    public static NetworkPlayerInfo getClientPlayerListEntry() {
        return Minecraft.func_71410_x().func_147114_u().func_175102_a(Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId());
    }

    public static boolean shouldDisableFog() {
        return OFInterface.shouldDisableFog.getAsBoolean();
    }

    public static World getClientWorld(RegistryKey<World> dimension) {
        return CGlobal.clientWorldLoader.getWorld(dimension);
    }

    public static List<GlobalTrackedPortal> getClientGlobalPortal(World world) {
        if (world instanceof ClientWorld) {
            return ((IEClientWorld)world).getGlobalPortals();
        }
        return null;
    }

    public static Stream<Portal> getClientNearbyPortals(double range) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        List<GlobalTrackedPortal> globalPortals = ((IEClientWorld)player.field_70170_p).getGlobalPortals();
        List<Portal> nearbyPortals = McHelper.findEntitiesRough(Portal.class, player.field_70170_p, player.func_213303_ch(), (int)(range / 16.0), p -> true);
        if (globalPortals == null) {
            return nearbyPortals.stream();
        }
        return Streams.concat((Stream[])new Stream[]{globalPortals.stream().filter(p -> p.getDistanceToNearestPointInPortal(player.func_213303_ch()) < range * 2.0), nearbyPortals.stream()});
    }

    public static void checkGlError() {
        if (!Global.doCheckGlError) {
            return;
        }
        if (reportedErrorNum > 100) {
            return;
        }
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            Helper.err("OpenGL Error" + errorCode);
            new Throwable().printStackTrace();
            ++reportedErrorNum;
        }
    }

    public static void printChat(String str) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(str));
    }

    public static void layout(int from, int to, LayoutElement ... elements) {
        int totalEscalateWeight = Arrays.stream(elements).filter(e -> !e.fixedLength).mapToInt(e -> e.length).sum();
        int totalFixedLen = Arrays.stream(elements).filter(e -> e.fixedLength).mapToInt(e -> e.length).sum();
        int totalEscalateLen = to - from - totalFixedLen;
        int currCoordinate = from;
        for (LayoutElement element : elements) {
            int currLen = element.fixedLength ? element.length : element.length * totalEscalateLen / totalEscalateWeight;
            element.apply.apply(currCoordinate, currCoordinate + currLen);
            currCoordinate += currLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withWorldSwitched(Entity entity, Portal portal, Supplier<T> func) {
        World oldWorld = entity.field_70170_p;
        Vector3d eyePos = McHelper.getEyePos(entity);
        Vector3d lastTickEyePos = McHelper.getLastTickEyePos(entity);
        entity.field_70170_p = portal.getDestinationWorld();
        McHelper.setEyePos(entity, portal.transformPoint(eyePos), portal.transformPoint(lastTickEyePos));
        try {
            T result;
            T t = result = func.get();
            return t;
        }
        finally {
            entity.field_70170_p = oldWorld;
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
        }
    }

    public static Iterable<Entity> getWorldEntityList(World world) {
        if (!(world instanceof ClientWorld)) {
            return (Iterable)((Object)Collections.emptyList().iterator());
        }
        ClientWorld clientWorld = (ClientWorld)world;
        return clientWorld.func_217416_b();
    }

    public static void executeOnRenderThread(Runnable runnable) {
        Minecraft client = Minecraft.func_71410_x();
        if (client.func_213162_bc()) {
            runnable.run();
        } else {
            client.execute(runnable);
        }
    }

    public static class LayoutElement {
        public boolean fixedLength;
        public int length;
        public LayoutFunc apply;

        public LayoutElement(boolean fixedLength, int length, LayoutFunc apply) {
            this.fixedLength = fixedLength;
            this.length = length;
            this.apply = apply;
        }

        public static LayoutElement blankSpace(int length) {
            return new LayoutElement(true, length, (a, b) -> {});
        }

        public static LayoutElement layoutX(Button widget, int widthRatio) {
            return new LayoutElement(false, widthRatio, (a, b) -> {
                widget.field_230690_l_ = a;
                widget.func_230991_b_(b - a);
            });
        }

        public static LayoutElement layoutY(Button widget, int height) {
            return new LayoutElement(true, height, (a, b) -> {
                widget.field_230691_m_ = a;
            });
        }
    }

    public static interface LayoutFunc {
        public void apply(int var1, int var2);
    }

    public static class Rect {
        public float xMin;
        public float yMin;
        public float xMax;
        public float yMax;

        public Rect(float xMin, float yMin, float xMax, float yMax) {
            this.xMin = xMin;
            this.yMin = yMin;
            this.xMax = xMax;
            this.yMax = yMax;
        }

        public void grow(float delta) {
            this.xMin -= delta;
            this.xMax += delta;
            this.yMin -= delta;
            this.yMax += delta;
        }

        public static Rect of(Screen screen) {
            return new Rect(0.0f, 0.0f, screen.field_230708_k_, screen.field_230709_l_);
        }
    }
}

