/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes.network;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import com.qouteall.immersive_portals.ducks.IEClientWorld;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class StcUpdateGlobalPortals {
    private CompoundNBT data;
    private RegistryKey<World> dimensionType;

    public StcUpdateGlobalPortals(CompoundNBT data, RegistryKey<World> dimensionType) {
        this.data = data;
        this.dimensionType = dimensionType;
    }

    public StcUpdateGlobalPortals(PacketBuffer buf) {
        this.dimensionType = DimId.readWorldId(buf, true);
        this.data = buf.func_150793_b();
    }

    public void encode(PacketBuffer buf) {
        DimId.writeWorldId(buf, this.dimensionType, false);
        buf.func_150786_a(this.data);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        this.clientOnlyHandle();
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientOnlyHandle() {
        Minecraft.func_71410_x().execute(() -> {
            ClientWorld world = CGlobal.clientWorldLoader.getWorld(this.dimensionType);
            List<GlobalTrackedPortal> portals = GlobalPortalStorage.getPortalsFromTag(this.data, (World)world);
            ((IEClientWorld)world).setGlobalPortals(portals);
        });
    }
}

