/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes.network;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import com.qouteall.immersive_portals.portal.Portal;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class StcSpawnEntity {
    String entityType;
    int entityId;
    RegistryKey<World> dimension;
    CompoundNBT tag;

    public StcSpawnEntity(String entityType, int entityId, RegistryKey<World> dimension, CompoundNBT tag) {
        this.entityType = entityType;
        this.entityId = entityId;
        this.dimension = dimension;
        this.tag = tag;
    }

    public StcSpawnEntity(PacketBuffer buf) {
        this.entityType = buf.func_218666_n();
        this.entityId = buf.readInt();
        this.dimension = DimId.readWorldId(buf, true);
        this.tag = buf.func_150793_b();
    }

    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.entityType);
        buf.writeInt(this.entityId);
        DimId.writeWorldId(buf, this.dimension, false);
        buf.func_150786_a(this.tag);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(this::clientHandle);
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientHandle() {
        String entityTypeString = this.entityType;
        int entityId = this.entityId;
        Optional entityType = EntityType.func_220327_a((String)entityTypeString);
        if (!entityType.isPresent()) {
            Helper.err("unknown entity type " + entityTypeString);
            return;
        }
        ClientWorld world = CGlobal.clientWorldLoader.getWorld(this.dimension);
        Entity entity = ((EntityType)entityType.get()).func_200721_a((World)world);
        entity.func_70020_e(this.tag);
        entity.func_145769_d(entityId);
        entity.func_213312_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        world.func_217411_a(entityId, entity);
        if (entity instanceof Portal) {
            CGlobal.clientWorldLoader.getWorld(((Portal)entity).dimensionTo);
        }
    }
}

