/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes.network;

import com.qouteall.hiding_in_the_bushes.network.NetworkMain;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.chunk_loading.MyClientChunkManager;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import com.qouteall.immersive_portals.ducks.IEClientPlayNetworkHandler;
import com.qouteall.immersive_portals.ducks.IEClientWorld;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class StcRedirected {
    public RegistryKey<World> dimension;
    public int packetId;
    public IPacket packet;
    private static int reportedErrors = 0;

    public StcRedirected(RegistryKey<World> dimensionType, IPacket packet) {
        this.dimension = dimensionType;
        Validate.notNull(dimensionType);
        this.packet = packet;
        try {
            this.packetId = ProtocolType.PLAY.func_179246_a(PacketDirection.CLIENTBOUND, packet);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public StcRedirected(PacketBuffer buf) {
        this.dimension = DimId.readWorldId(buf, true);
        this.packetId = buf.readInt();
        this.packet = NetworkMain.createEmptyPacketByType(this.packetId);
        try {
            this.packet.func_148837_a(buf);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcessRedirectedPacket(RegistryKey<World> dimension, IPacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld packetWorld = CGlobal.clientWorldLoader.getWorld(dimension);
        assert (packetWorld != null);
        assert (packetWorld.func_72863_F() instanceof MyClientChunkManager);
        ClientPlayNetHandler netHandler = ((IEClientWorld)packetWorld).getNetHandler();
        if (netHandler.func_195514_j() != packetWorld) {
            ((IEClientPlayNetworkHandler)netHandler).setWorld(packetWorld);
            Helper.err("The world field of client net handler is wrong");
        }
        ClientWorld originalWorld = mc.field_71441_e;
        mc.field_71441_e = packetWorld;
        try {
            packet.func_148833_a((INetHandler)netHandler);
        }
        catch (Throwable e) {
            if (reportedErrors < 200) {
                ++reportedErrors;
                throw new IllegalStateException("handling packet in " + dimension, e);
            }
        }
        finally {
            mc.field_71441_e = originalWorld;
        }
    }

    public void encode(PacketBuffer buf) {
        DimId.writeWorldId(buf, this.dimension, false);
        buf.writeInt(this.packetId);
        try {
            this.packet.func_148840_b(buf);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        if (this.dimension == null) {
            throw new IllegalStateException("Redirected Packet without Dimension info " + this.packet);
        }
        context.get().enqueueWork(() -> StcRedirected.doProcessRedirectedPacket(this.dimension, this.packet));
        context.get().setPacketHandled(true);
    }
}

