/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes.network;

import com.qouteall.hiding_in_the_bushes.network.CtsPlayerAction;
import com.qouteall.hiding_in_the_bushes.network.CtsRightClick;
import com.qouteall.hiding_in_the_bushes.network.CtsTeleport;
import com.qouteall.hiding_in_the_bushes.network.StcDimensionConfirm;
import com.qouteall.hiding_in_the_bushes.network.StcDimensionSync;
import com.qouteall.hiding_in_the_bushes.network.StcRedirected;
import com.qouteall.hiding_in_the_bushes.network.StcSpawnEntity;
import com.qouteall.hiding_in_the_bushes.network.StcUpdateGlobalPortals;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkMain {
    private static final String protocol_version = "1";
    public static final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("imm_ptl", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        channel.registerMessage(0, StcRedirected.class, StcRedirected::encode, StcRedirected::new, StcRedirected::handle);
        channel.registerMessage(1, StcDimensionConfirm.class, StcDimensionConfirm::encode, StcDimensionConfirm::new, StcDimensionConfirm::handle);
        channel.registerMessage(2, StcDimensionSync.class, StcDimensionSync::encode, StcDimensionSync::new, StcDimensionSync::handle);
        channel.registerMessage(3, CtsTeleport.class, CtsTeleport::encode, CtsTeleport::new, CtsTeleport::handle);
        channel.registerMessage(4, StcUpdateGlobalPortals.class, StcUpdateGlobalPortals::encode, StcUpdateGlobalPortals::new, StcUpdateGlobalPortals::handle);
        channel.registerMessage(6, StcSpawnEntity.class, StcSpawnEntity::encode, StcSpawnEntity::new, StcSpawnEntity::handle);
        channel.registerMessage(7, CtsPlayerAction.class, CtsPlayerAction::encode, CtsPlayerAction::new, CtsPlayerAction::handle);
        channel.registerMessage(8, CtsRightClick.class, CtsRightClick::encode, CtsRightClick::new, CtsRightClick::handle);
    }

    public static <T> void sendToServer(T t) {
        channel.sendToServer(t);
    }

    public static <T> void sendToPlayer(ServerPlayerEntity player, T t) {
        channel.send(PacketDistributor.PLAYER.with(() -> player), t);
    }

    public static void sendRedirected(ServerPlayerEntity player, RegistryKey<World> dimension, IPacket t) {
        NetworkMain.sendToPlayer(player, new StcRedirected(dimension, t));
    }

    public static IPacket getRedirectedPacket(RegistryKey<World> dimension, IPacket t) {
        return channel.toVanillaPacket((Object)new StcRedirected(dimension, t), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static IPacket createEmptyPacketByType(int messageType) {
        return ProtocolType.PLAY.func_179244_a(PacketDirection.CLIENTBOUND, messageType);
    }
}

