/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes.network;

import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class CtsTeleport {
    RegistryKey<World> dimensionBefore;
    Vector3d posBefore;
    UUID portalEntityId;

    public CtsTeleport(RegistryKey<World> dimensionBefore, Vector3d posBefore, UUID portalEntityId) {
        this.dimensionBefore = dimensionBefore;
        this.posBefore = posBefore;
        this.portalEntityId = portalEntityId;
    }

    public CtsTeleport(PacketBuffer buf) {
        this.dimensionBefore = DimId.readWorldId(buf, false);
        this.posBefore = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.portalEntityId = buf.func_179253_g();
    }

    public void encode(PacketBuffer buf) {
        DimId.writeWorldId(buf, this.dimensionBefore, true);
        buf.writeDouble(this.posBefore.field_72450_a);
        buf.writeDouble(this.posBefore.field_72448_b);
        buf.writeDouble(this.posBefore.field_72449_c);
        buf.func_179252_a(this.portalEntityId);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> Global.serverTeleportationManager.onPlayerTeleportedInClient(((NetworkEvent.Context)context.get()).getSender(), this.dimensionBefore, this.posBefore, this.portalEntityId));
        context.get().setPacketHandled(true);
    }
}

