/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes;

import com.qouteall.hiding_in_the_bushes.ConfigClient;
import com.qouteall.hiding_in_the_bushes.ConfigServer;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ModMainClient;
import com.qouteall.immersive_portals.block_manipulation.HandReachTweak;
import com.qouteall.immersive_portals.portal.BreakableMirror;
import com.qouteall.immersive_portals.portal.EndPortalEntity;
import com.qouteall.immersive_portals.portal.LoadingIndicatorEntity;
import com.qouteall.immersive_portals.portal.Mirror;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalPlaceholderBlock;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import com.qouteall.immersive_portals.portal.global_portals.VerticalConnectingPortal;
import com.qouteall.immersive_portals.portal.global_portals.WorldWrappingPortal;
import com.qouteall.immersive_portals.portal.nether_portal.GeneralBreakablePortal;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalEntity;
import com.qouteall.immersive_portals.render.LoadingIndicatorRenderer;
import com.qouteall.immersive_portals.render.PortalEntityRenderer;
import com.qouteall.immersive_portals.render.context_management.RenderDimensionRedirect;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="immersive_portals")
public class ModMainForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean isServerMixinApplied = false;
    public static boolean enableModelDataFix = false;

    public ModMainForge() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigClient.init();
        ConfigServer.init();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void initPortalRenderers() {
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        Arrays.stream(new EntityType[]{Portal.entityType, NetherPortalEntity.entityType, EndPortalEntity.entityType, Mirror.entityType, BreakableMirror.entityType, GlobalTrackedPortal.entityType, WorldWrappingPortal.entityType, VerticalConnectingPortal.entityType, GeneralBreakablePortal.entityType}).peek(Validate::notNull).forEach(entityType -> manager.func_229087_a_(entityType, (EntityRenderer)new PortalEntityRenderer(manager)));
        manager.func_229087_a_(LoadingIndicatorEntity.entityType, (EntityRenderer)new LoadingIndicatorRenderer(manager));
    }

    private void setup(FMLCommonSetupEvent event) {
        ModMain.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModMainClient.init();
        Minecraft.func_71410_x().execute(() -> {
            if (((Boolean)ConfigClient.instance.compatibilityRenderMode.get()).booleanValue()) {
                Global.renderMode = Global.RenderMode.compatibility;
                Helper.log("Initially Switched to Compatibility Render Mode");
            }
            Global.doCheckGlError = (Boolean)ConfigClient.instance.doCheckGlError.get();
            Helper.log("Do Check Gl Error: " + Global.doCheckGlError);
            Global.renderYourselfInPortal = (Boolean)ConfigClient.instance.renderYourselfInPortal.get();
            Global.maxPortalLayer = (Integer)ConfigClient.instance.maxPortalLayer.get();
            Global.correctCrossPortalEntityRendering = (Boolean)ConfigClient.instance.correctCrossPortalEntityRendering.get();
            Global.edgelessSky = (Boolean)ConfigClient.instance.edgelessSky.get();
            Global.pureMirror = (Boolean)ConfigClient.instance.pureMirror.get();
            Global.lagAttackProof = (Boolean)ConfigClient.instance.lagAttackProof.get();
            enableModelDataFix = (Boolean)ConfigClient.instance.modelDataFix.get();
            RenderDimensionRedirect.updateIdMap(ConfigClient.listToMap(Arrays.asList(((String)ConfigClient.instance.renderDimensionRedirect.get()).split("\n"))));
        });
        ModMainForge.initPortalRenderers();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        Global.netherPortalFindingRadius = (Integer)ConfigServer.instance.portalSearchingRange.get();
        Global.activeLoading = (Boolean)ConfigServer.instance.activeLoadRemoteChunks.get();
        Global.teleportationDebugEnabled = (Boolean)ConfigServer.instance.teleportationDebug.get();
        Global.loadFewerChunks = (Boolean)ConfigServer.instance.loadFewerChunks.get();
        Global.multiThreadedNetherPortalSearching = (Boolean)ConfigServer.instance.multiThreadedNetherPortalSearching.get();
        Global.looseMovementCheck = (Boolean)ConfigServer.instance.looseMovementCheck.get();
        Global.enableAlternateDimensions = (Boolean)ConfigServer.instance.enableAlternateDimensions.get();
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
    }

    public static void checkMixinState() {
        if (!isServerMixinApplied) {
            String message = "Mixin is missing. Install the latest Forge";
            try {
                Class.forName("org.spongepowered.asm.launch.Phases");
                Helper.err("What? Mixin is in classpath???");
            }
            catch (ClassNotFoundException e) {
                Helper.err("Mixin is not in classpath");
            }
            Helper.err(message);
            throw new IllegalStateException(message);
        }
    }

    public static boolean isMixinInClasspath() {
        try {
            Class.forName("org.spongepowered.asm.launch.Phases");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ModMainForge.checkMixinState();
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player;
        if (!Global.serverTeleportationManager.isFiringMyChangeDimensionEvent && (player = event.getPlayer()) instanceof ServerPlayerEntity) {
            GlobalPortalStorage.onPlayerLoggedIn((ServerPlayerEntity)player);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            IForgeRegistry registry = blockRegistryEvent.getRegistry();
            PortalPlaceholderBlock.instance = new PortalPlaceholderBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200947_a(SoundType.field_185853_f).func_200948_a(99999.0f, 0.0f).func_235838_a_(s -> 15));
            PortalPlaceholderBlock.instance.setRegistryName(new ResourceLocation("immersive_portals", "portal_placeholder"));
            registry.register((IForgeRegistryEntry)PortalPlaceholderBlock.instance);
            ModMain.portalHelperBlock = new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f));
            ModMain.portalHelperBlock.setRegistryName(new ResourceLocation("immersive_portals", "portal_helper"));
            registry.register((IForgeRegistryEntry)ModMain.portalHelperBlock);
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            ModMain.portalHelperBlockItem = new BlockItem(ModMain.portalHelperBlock, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
            ModMain.portalHelperBlockItem.setRegistryName(new ResourceLocation("immersive_portals", "portal_helper"));
            registry.register((IForgeRegistryEntry)ModMain.portalHelperBlockItem);
        }

        private static <T extends Entity> void registerEntity(Consumer<EntityType<T>> setEntityType, Supplier<EntityType<T>> getEntityType, String id, EntityType.IFactory<T> constructor, IForgeRegistry<EntityType<?>> registry) {
            BiFunction<FMLPlayMessages.SpawnEntity, World, Entity> biFunction = (a, world) -> constructor.create((EntityType)getEntityType.get(), world);
            EntityType entityType = EntityType.Builder.func_220322_a(constructor, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_220320_c().setCustomClientFactory(biFunction).setTrackingRange(96).func_206830_a(id);
            setEntityType.accept(entityType);
            registry.register(entityType.setRegistryName(id));
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            RegistryEvents.registerEntity(o -> {
                Portal.entityType = o;
            }, () -> Portal.entityType, "immersive_portals:portal", Portal::new, registry);
            RegistryEvents.registerEntity(o -> {
                NetherPortalEntity.entityType = o;
            }, () -> NetherPortalEntity.entityType, "immersive_portals:nether_portal_new", NetherPortalEntity::new, registry);
            RegistryEvents.registerEntity(o -> {
                EndPortalEntity.entityType = o;
            }, () -> EndPortalEntity.entityType, "immersive_portals:end_portal", EndPortalEntity::new, registry);
            RegistryEvents.registerEntity(o -> {
                Mirror.entityType = o;
            }, () -> Mirror.entityType, "immersive_portals:mirror", Mirror::new, registry);
            RegistryEvents.registerEntity(o -> {
                BreakableMirror.entityType = o;
            }, () -> BreakableMirror.entityType, "immersive_portals:breakable_mirror", BreakableMirror::new, registry);
            RegistryEvents.registerEntity(o -> {
                GlobalTrackedPortal.entityType = o;
            }, () -> GlobalTrackedPortal.entityType, "immersive_portals:global_tracked_portal", GlobalTrackedPortal::new, registry);
            RegistryEvents.registerEntity(o -> {
                WorldWrappingPortal.entityType = o;
            }, () -> WorldWrappingPortal.entityType, "immersive_portals:border_portal", WorldWrappingPortal::new, registry);
            RegistryEvents.registerEntity(o -> {
                VerticalConnectingPortal.entityType = o;
            }, () -> VerticalConnectingPortal.entityType, "immersive_portals:end_floor_portal", VerticalConnectingPortal::new, registry);
            RegistryEvents.registerEntity(o -> {
                GeneralBreakablePortal.entityType = o;
            }, () -> GeneralBreakablePortal.entityType, "immersive_portals:general_breakable_portal", GeneralBreakablePortal::new, registry);
            LoadingIndicatorEntity.entityType = EntityType.Builder.func_220322_a(LoadingIndicatorEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_220320_c().setCustomClientFactory((a, world) -> new LoadingIndicatorEntity((EntityType)LoadingIndicatorEntity.entityType, (World)world)).func_206830_a("immersive_portals:loading_indicator");
            event.getRegistry().register(LoadingIndicatorEntity.entityType.setRegistryName("immersive_portals:loading_indicator"));
        }

        @SubscribeEvent
        public static void onEffectRegistry(RegistryEvent.Register<Effect> event) {
            Effect.class.hashCode();
            if (HandReachTweak.statusEffectConstructor == null) {
                Helper.err("Status Effect Constructor is null");
                return;
            }
            HandReachTweak.longerReachEffect = HandReachTweak.statusEffectConstructor.apply(EffectType.BENEFICIAL, 0).func_220304_a(HandReachTweak.handReachMultiplierAttribute, "91AEAA56-2333-2333-2333-2F7F68070635", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
            Registry.func_218322_a((Registry)Registry.field_212631_t, (ResourceLocation)new ResourceLocation("immersive_portals", "longer_reach"), (Object)HandReachTweak.longerReachEffect);
        }

        @SubscribeEvent
        public static void onPotionRegistry(RegistryEvent.Register<Potion> event) {
            if (HandReachTweak.longerReachEffect == null) {
                return;
            }
            HandReachTweak.longerReachPotion = new Potion(new EffectInstance[]{new EffectInstance(HandReachTweak.longerReachEffect, 7200, 1)});
            Registry.func_218322_a((Registry)Registry.field_212621_j, (ResourceLocation)new ResourceLocation("immersive_portals", "longer_reach_potion"), (Object)HandReachTweak.longerReachPotion);
        }
    }
}

