/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.hiding_in_the_bushes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigClient {
    public static final ConfigClient instance;
    public static final ForgeConfigSpec spec;
    public final ForgeConfigSpec.BooleanValue compatibilityRenderMode;
    public final ForgeConfigSpec.BooleanValue doCheckGlError;
    public final ForgeConfigSpec.IntValue maxPortalLayer;
    public final ForgeConfigSpec.BooleanValue renderYourselfInPortal;
    public final ForgeConfigSpec.BooleanValue correctCrossPortalEntityRendering;
    public final ForgeConfigSpec.BooleanValue edgelessSky;
    public final ForgeConfigSpec.BooleanValue pureMirror;
    public final ForgeConfigSpec.BooleanValue lagAttackProof;
    public final ForgeConfigSpec.BooleanValue modelDataFix;
    public final ForgeConfigSpec.ConfigValue<String> renderDimensionRedirect;
    public final String defaultDimRedirect = "immersive_portals:alternate1->minecraft:overworld\nimmersive_portals:alternate2->minecraft:overworld\nimmersive_portals:alternate3->minecraft:overworld\nimmersive_portals:alternate4->minecraft:overworld\nimmersive_portals:alternate5->minecraft:overworld\n";
    public static final String splitter = "->";

    public ConfigClient(ForgeConfigSpec.Builder builder) {
        this.compatibilityRenderMode = builder.comment("With this you can't see portal-in-portal").define("compatibility_render_mode", false);
        this.doCheckGlError = builder.comment("With this the performance may drop").define("check_gl_error", false);
        this.maxPortalLayer = builder.comment("Max Portal-in-portal Render Layer").defineInRange("max_portal_layer", 5, 1, 10);
        this.renderYourselfInPortal = builder.comment("Render Yourself In Portal").define("render_yourself_in_portal", true);
        this.correctCrossPortalEntityRendering = builder.comment("This May Decrease FPS").define("correct_cross_portal_entity_rendering", true);
        this.edgelessSky = builder.comment("Remove Sky Edge in Dimension Stack").define("edgeless_sky", false);
        this.pureMirror = builder.comment("Remove the glass texture on mirrors").define("pure_mirror", false);
        this.lagAttackProof = builder.comment("Render Fewer Portals When Laggy").define("lag_attack_proof", true);
        this.modelDataFix = builder.comment("Fix Compatibility with Other Mod's Block Model. May Decrease FPS").define("model_data_fix", false);
        this.renderDimensionRedirect = builder.comment("See the Wiki to Know How to Configure it").define("dimension_render_redirect", (Object)"immersive_portals:alternate1->minecraft:overworld\nimmersive_portals:alternate2->minecraft:overworld\nimmersive_portals:alternate3->minecraft:overworld\nimmersive_portals:alternate4->minecraft:overworld\nimmersive_portals:alternate5->minecraft:overworld\n");
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, spec);
    }

    public static Map<String, String> listToMap(List<String> redirectList) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : redirectList) {
            int i = s.indexOf(splitter);
            if (i != -1) {
                result.put(s.substring(0, i), s.substring(i + 2));
                continue;
            }
            result.put(s, "???");
        }
        return result;
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ConfigClient::new);
        instance = (ConfigClient)pair.getKey();
        spec = (ForgeConfigSpec)pair.getValue();
    }
}

