/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WoodlandMansionStructure
extends Structure<NoFeatureConfig> {
    public WoodlandMansionStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    protected boolean func_230365_b_() {
        return false;
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long l, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        Set<Biome> set = biomeProvider.func_225530_a_(n * 16 + 9, chunkGenerator.func_230356_f_(), n2 * 16 + 9, 32);
        for (Biome biome2 : set) {
            if (biome2.func_242440_e().func_242493_a(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome, NoFeatureConfig noFeatureConfig) {
            Rotation rotation = Rotation.func_222466_a(this.field_214631_d);
            int \u26032 = 5;
            int \u26033 = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                \u26032 = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                \u26032 = -5;
                \u26033 = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                \u26033 = -5;
            }
            int \u26034 = (n << 4) + 7;
            int \u26035 = (n2 << 4) + 7;
            int \u26036 = chunkGenerator.func_222531_c(\u26034, \u26035, Heightmap.Type.WORLD_SURFACE_WG);
            int \u26037 = chunkGenerator.func_222531_c(\u26034, \u26035 + \u26033, Heightmap.Type.WORLD_SURFACE_WG);
            int \u26038 = chunkGenerator.func_222531_c(\u26034 + \u26032, \u26035, Heightmap.Type.WORLD_SURFACE_WG);
            int \u26039 = chunkGenerator.func_222531_c(\u26034 + \u26032, \u26035 + \u26033, Heightmap.Type.WORLD_SURFACE_WG);
            int \u260310 = Math.min(Math.min(\u26036, \u26037), Math.min(\u26038, \u26039));
            if (\u260310 < 60) {
                return;
            }
            BlockPos \u260311 = new BlockPos(n * 16 + 8, \u260310 + 1, n2 * 16 + 8);
            LinkedList \u260312 = Lists.newLinkedList();
            WoodlandMansionPieces.func_191152_a(templateManager, \u260311, rotation, \u260312, this.field_214631_d);
            this.field_75075_a.addAll(\u260312);
            this.func_202500_a();
        }

        @Override
        public void func_230366_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            super.func_230366_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos);
            int n = this.field_75074_b.field_78895_b;
            for (\u2603 = mutableBoundingBox.field_78897_a; \u2603 <= mutableBoundingBox.field_78893_d; ++\u2603) {
                for (\u2603 = mutableBoundingBox.field_78896_c; \u2603 <= mutableBoundingBox.field_78892_f; ++\u2603) {
                    BlockPos blockPos = new BlockPos(\u2603, n, \u2603);
                    if (iSeedReader.func_175623_d(blockPos) || !this.field_75074_b.func_175898_b(blockPos)) continue;
                    boolean \u26032 = false;
                    for (Object object : this.field_75075_a) {
                        if (!((StructurePiece)object).func_74874_b().func_175898_b(blockPos)) continue;
                        \u26032 = true;
                        break;
                    }
                    if (!\u26032) continue;
                    for (int i = n - 1; i > 1 && (iSeedReader.func_175623_d((BlockPos)(object = new BlockPos(\u2603, i, \u2603))) || iSeedReader.func_180495_p((BlockPos)object).func_185904_a().func_76224_d()); --i) {
                        iSeedReader.func_180501_a((BlockPos)object, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

