/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class StructureStart<C extends IFeatureConfig> {
    public static final StructureStart<?> field_214630_a = new StructureStart<MineshaftConfig>(Structure.field_236367_c_, 0, 0, MutableBoundingBox.func_78887_a(), 0, 0L){

        @Override
        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome, MineshaftConfig mineshaftConfig) {
        }
    };
    private final Structure<C> field_214632_e;
    protected final List<StructurePiece> field_75075_a = Lists.newArrayList();
    protected MutableBoundingBox field_75074_b;
    private final int field_143024_c;
    private final int field_143023_d;
    private int field_212688_f;
    protected final SharedSeedRandom field_214631_d;

    public StructureStart(Structure<C> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
        this.field_214632_e = structure;
        this.field_143024_c = n;
        this.field_143023_d = n2;
        this.field_212688_f = n3;
        this.field_214631_d = new SharedSeedRandom();
        this.field_214631_d.func_202425_c(l, n, n2);
        this.field_75074_b = mutableBoundingBox;
    }

    public abstract void func_230364_a_(DynamicRegistries var1, ChunkGenerator var2, TemplateManager var3, int var4, int var5, Biome var6, C var7);

    public MutableBoundingBox func_75071_a() {
        return this.field_75074_b;
    }

    public List<StructurePiece> func_186161_c() {
        return this.field_75075_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_230366_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
        List<StructurePiece> list = this.field_75075_a;
        synchronized (list) {
            if (this.field_75075_a.isEmpty()) {
                return;
            }
            MutableBoundingBox mutableBoundingBox2 = this.field_75075_a.get((int)0).field_74887_e;
            Vector3i \u26032 = mutableBoundingBox2.func_215126_f();
            BlockPos \u26033 = new BlockPos(\u26032.func_177958_n(), mutableBoundingBox2.field_78895_b, \u26032.func_177952_p());
            Iterator<StructurePiece> \u26034 = this.field_75075_a.iterator();
            while (\u26034.hasNext()) {
                StructurePiece structurePiece = \u26034.next();
                if (!structurePiece.func_74874_b().func_78884_a(mutableBoundingBox) || structurePiece.func_230383_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos, \u26033)) continue;
                \u26034.remove();
            }
            this.func_202500_a();
        }
    }

    protected void func_202500_a() {
        this.field_75074_b = MutableBoundingBox.func_78887_a();
        for (StructurePiece structurePiece : this.field_75075_a) {
            this.field_75074_b.func_78888_b(structurePiece.func_74874_b());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundNBT func_143021_a(int n, int n2) {
        CompoundNBT compoundNBT = new CompoundNBT();
        if (!this.func_75069_d()) {
            compoundNBT.func_74778_a("id", "INVALID");
            return compoundNBT;
        }
        compoundNBT.func_74778_a("id", Registry.field_218361_B.func_177774_c(this.func_214627_k()).toString());
        compoundNBT.func_74768_a("ChunkX", n);
        compoundNBT.func_74768_a("ChunkZ", n2);
        compoundNBT.func_74768_a("references", this.field_212688_f);
        compoundNBT.func_218657_a("BB", this.field_75074_b.func_151535_h());
        ListNBT \u26032 = new ListNBT();
        List<StructurePiece> list = this.field_75075_a;
        synchronized (list) {
            for (StructurePiece structurePiece : this.field_75075_a) {
                \u26032.add(structurePiece.func_143010_b());
            }
        }
        compoundNBT.func_218657_a("Children", \u26032);
        return compoundNBT;
    }

    protected void func_214628_a(int n, Random random, int n2) {
        \u2603 = n - n2;
        \u2603 = this.field_75074_b.func_78882_c() + 1;
        if (\u2603 < \u2603) {
            \u2603 += random.nextInt(\u2603 - \u2603);
        }
        \u2603 = \u2603 - this.field_75074_b.field_78894_e;
        this.field_75074_b.func_78886_a(0, \u2603, 0);
        for (StructurePiece structurePiece : this.field_75075_a) {
            structurePiece.func_181138_a(0, \u2603, 0);
        }
    }

    protected void func_214626_a(Random random, int n, int n2) {
        \u2603 = n2 - n + 1 - this.field_75074_b.func_78882_c();
        \u2603 = \u2603 > 1 ? n + random.nextInt(\u2603) : n;
        \u2603 = \u2603 - this.field_75074_b.field_78895_b;
        this.field_75074_b.func_78886_a(0, \u2603, 0);
        for (StructurePiece structurePiece : this.field_75075_a) {
            structurePiece.func_181138_a(0, \u2603, 0);
        }
    }

    public boolean func_75069_d() {
        return !this.field_75075_a.isEmpty();
    }

    public int func_143019_e() {
        return this.field_143024_c;
    }

    public int func_143018_f() {
        return this.field_143023_d;
    }

    public BlockPos func_204294_a() {
        return new BlockPos(this.field_143024_c << 4, 0, this.field_143023_d << 4);
    }

    public boolean func_212687_g() {
        return this.field_212688_f < this.func_212686_i();
    }

    public void func_212685_h() {
        ++this.field_212688_f;
    }

    public int func_227457_j_() {
        return this.field_212688_f;
    }

    protected int func_212686_i() {
        return 1;
    }

    public Structure<?> func_214627_k() {
        return this.field_214632_e;
    }
}

