/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeSpliterator;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.border.WorldBorder;

public interface ICollisionReader
extends IBlockReader {
    public WorldBorder func_175723_af();

    @Nullable
    public IBlockReader func_225522_c_(int var1, int var2);

    default public boolean func_195585_a(@Nullable Entity entity, VoxelShape voxelShape) {
        return true;
    }

    default public boolean func_226663_a_(BlockState blockState, BlockPos blockPos, ISelectionContext iSelectionContext) {
        VoxelShape voxelShape = blockState.func_215685_b(this, blockPos, iSelectionContext);
        return voxelShape.func_197766_b() || this.func_195585_a(null, voxelShape.func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
    }

    default public boolean func_226668_i_(Entity entity) {
        return this.func_195585_a(entity, VoxelShapes.func_197881_a(entity.func_174813_aQ()));
    }

    default public boolean func_226664_a_(AxisAlignedBB axisAlignedBB) {
        return this.func_234865_b_(null, axisAlignedBB, entity -> true);
    }

    default public boolean func_226669_j_(Entity entity2) {
        return this.func_234865_b_(entity2, entity2.func_174813_aQ(), entity -> true);
    }

    default public boolean func_226665_a__(Entity entity2, AxisAlignedBB axisAlignedBB) {
        return this.func_234865_b_(entity2, axisAlignedBB, entity -> true);
    }

    default public boolean func_234865_b_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Predicate<Entity> predicate) {
        return this.func_234867_d_(entity, axisAlignedBB, predicate).allMatch(VoxelShape::func_197766_b);
    }

    public Stream<VoxelShape> func_230318_c_(@Nullable Entity var1, AxisAlignedBB var2, Predicate<Entity> var3);

    default public Stream<VoxelShape> func_234867_d_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Predicate<Entity> predicate) {
        return Stream.concat(this.func_226666_b_(entity, axisAlignedBB), this.func_230318_c_(entity, axisAlignedBB, predicate));
    }

    default public Stream<VoxelShape> func_226666_b_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        return StreamSupport.stream(new VoxelShapeSpliterator(this, entity, axisAlignedBB), false);
    }

    default public Stream<VoxelShape> func_241457_a_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, BiPredicate<BlockState, BlockPos> biPredicate) {
        return StreamSupport.stream(new VoxelShapeSpliterator(this, entity, axisAlignedBB, biPredicate), false);
    }
}

