/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.BlockStateFlatteningMap;
import net.minecraft.util.datafix.fixes.BlockStateFlatternEntities;
import org.apache.commons.lang3.math.NumberUtils;

public class BlockStateFlattenGenOptions
extends DataFix {
    private static final Splitter field_199181_a = Splitter.on((char)';').limit(5);
    private static final Splitter field_199182_b = Splitter.on((char)',');
    private static final Splitter field_199183_c = Splitter.on((char)'x').limit(2);
    private static final Splitter field_199184_d = Splitter.on((char)'*').limit(2);
    private static final Splitter field_199185_e = Splitter.on((char)':').limit(3);

    public BlockStateFlattenGenOptions(Schema schema, boolean bl) {
        super(schema, bl);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelFlatGeneratorInfoFix", this.getInputSchema().getType(TypeReferences.field_211285_a), typed -> typed.update(DSL.remainderFinder(), this::func_209636_a));
    }

    private Dynamic<?> func_209636_a(Dynamic<?> dynamic2) {
        if (dynamic2.get("generatorName").asString("").equalsIgnoreCase("flat")) {
            return dynamic2.update("generatorOptions", dynamic -> (Dynamic)DataFixUtils.orElse((Optional)dynamic.asString().map(this::func_199180_a).map(arg_0 -> ((Dynamic)dynamic).createString(arg_0)).result(), (Object)dynamic));
        }
        return dynamic2;
    }

    @VisibleForTesting
    String func_199180_a(String string2) {
        String \u26033;
        if (string2.isEmpty()) {
            return "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;1;village";
        }
        Iterator iterator = field_199181_a.split((CharSequence)string2).iterator();
        String \u26032 = (String)iterator.next();
        if (iterator.hasNext()) {
            int n = NumberUtils.toInt((String)\u26032, (int)0);
            \u26033 = (String)iterator.next();
        } else {
            n = 0;
            \u26033 = \u26032;
        }
        if (n < 0 || n > 3) {
            return "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;1;village";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Splitter \u26034 = n < 3 ? field_199183_c : field_199184_d;
        stringBuilder.append(StreamSupport.stream(field_199182_b.split((CharSequence)\u26033).spliterator(), false).map(string -> {
            String \u26032;
            List list = \u26034.splitToList((CharSequence)string);
            if (list.size() == 2) {
                int n2 = NumberUtils.toInt((String)((String)list.get(0)));
                \u26032 = (String)list.get(1);
            } else {
                n2 = 1;
                \u26032 = (String)list.get(0);
            }
            List list2 = field_199185_e.splitToList((CharSequence)\u26032);
            int \u26033 = ((String)list2.get(0)).equals("minecraft") ? 1 : 0;
            String \u26034 = (String)list2.get(\u26033);
            int \u26035 = n == 3 ? BlockStateFlatternEntities.func_199171_a("minecraft:" + \u26034) : NumberUtils.toInt((String)\u26034, (int)0);
            int \u26036 = \u26033 + 1;
            int \u26037 = list2.size() > \u26036 ? NumberUtils.toInt((String)((String)list2.get(\u26036)), (int)0) : 0;
            return (n2 == 1 ? "" : n2 + "*") + BlockStateFlatteningMap.func_210049_b(\u26035 << 4 | \u26037).get("Name").asString("");
        }).collect(Collectors.joining(",")));
        while (iterator.hasNext()) {
            stringBuilder.append(';').append((String)iterator.next());
        }
        return stringBuilder.toString();
    }
}

