/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;

public class TransportationHelper {
    public static int[][] func_234632_a_(Direction direction) {
        \u2603 = direction.func_176746_e();
        \u2603 = \u2603.func_176734_d();
        \u2603 = direction.func_176734_d();
        return new int[][]{{\u2603.func_82601_c(), \u2603.func_82599_e()}, {\u2603.func_82601_c(), \u2603.func_82599_e()}, {\u2603.func_82601_c() + \u2603.func_82601_c(), \u2603.func_82599_e() + \u2603.func_82599_e()}, {\u2603.func_82601_c() + \u2603.func_82601_c(), \u2603.func_82599_e() + \u2603.func_82599_e()}, {direction.func_82601_c() + \u2603.func_82601_c(), direction.func_82599_e() + \u2603.func_82599_e()}, {direction.func_82601_c() + \u2603.func_82601_c(), direction.func_82599_e() + \u2603.func_82599_e()}, {\u2603.func_82601_c(), \u2603.func_82599_e()}, {direction.func_82601_c(), direction.func_82599_e()}};
    }

    public static boolean func_234630_a_(double d) {
        return !Double.isInfinite(d) && d < 1.0;
    }

    public static boolean func_234631_a_(ICollisionReader iCollisionReader, LivingEntity livingEntity, AxisAlignedBB axisAlignedBB) {
        return iCollisionReader.func_226666_b_(livingEntity, axisAlignedBB).allMatch(VoxelShape::func_197766_b);
    }

    @Nullable
    public static Vector3d func_242381_a(ICollisionReader iCollisionReader, double d, double d2, double d3, LivingEntity livingEntity, Pose pose) {
        if (TransportationHelper.func_234630_a_(d2)) {
            Vector3d vector3d = new Vector3d(d, d2, d3);
            if (TransportationHelper.func_234631_a_(iCollisionReader, livingEntity, livingEntity.func_233648_f_(pose).func_191194_a(vector3d))) {
                return vector3d;
            }
        }
        return null;
    }

    public static VoxelShape func_242380_a(IBlockReader iBlockReader, BlockPos blockPos) {
        BlockState blockState = iBlockReader.func_180495_p(blockPos);
        if (blockState.func_235714_a_(BlockTags.field_232878_as_) || blockState.func_177230_c() instanceof TrapDoorBlock && blockState.func_177229_b(TrapDoorBlock.field_176283_b).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return blockState.func_196952_d(iBlockReader, blockPos);
    }

    public static double func_242383_a(BlockPos blockPos, int n, Function<BlockPos, VoxelShape> function) {
        BlockPos.Mutable mutable = blockPos.func_239590_i_();
        for (int i = 0; i < n; ++i) {
            VoxelShape voxelShape = function.apply(mutable);
            if (!voxelShape.func_197766_b()) {
                return (double)(blockPos.func_177956_o() + i) + voxelShape.func_197762_b(Direction.Axis.Y);
            }
            mutable.func_189536_c(Direction.UP);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Nullable
    public static Vector3d func_242379_a(EntityType<?> entityType, ICollisionReader iCollisionReader, BlockPos blockPos, boolean bl) {
        if (bl && entityType.func_233597_a_(iCollisionReader.func_180495_p(blockPos))) {
            return null;
        }
        double d = iCollisionReader.func_242402_a(TransportationHelper.func_242380_a(iCollisionReader, blockPos), () -> TransportationHelper.func_242380_a(iCollisionReader, blockPos.func_177977_b()));
        if (!TransportationHelper.func_234630_a_(d)) {
            return null;
        }
        if (bl && d <= 0.0 && entityType.func_233597_a_(iCollisionReader.func_180495_p(blockPos.func_177977_b()))) {
            return null;
        }
        Vector3d \u26032 = Vector3d.func_237490_a_(blockPos, d);
        if (iCollisionReader.func_226666_b_(null, entityType.func_220334_j().func_242286_a(\u26032)).allMatch(VoxelShape::func_197766_b)) {
            return \u26032;
        }
        return null;
    }
}

