/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassInheritanceMultiMap<T>
extends AbstractCollection<T> {
    private final Map<Class<?>, List<T>> field_180218_a = Maps.newHashMap();
    private final Class<T> field_180217_c;
    private final List<T> field_181745_e = Lists.newArrayList();

    public ClassInheritanceMultiMap(Class<T> clazz) {
        this.field_180217_c = clazz;
        this.field_180218_a.put(clazz, this.field_181745_e);
    }

    @Override
    public boolean add(T t) {
        boolean bl = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.field_180218_a.entrySet()) {
            if (!entry.getKey().isInstance(t)) continue;
            bl |= entry.getValue().add(t);
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.field_180218_a.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            List<T> list = entry.getValue();
            bl |= list.remove(object);
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.func_219790_a(object.getClass()).contains(object);
    }

    public <S> Collection<S> func_219790_a(Class<S> clazz2) {
        if (!this.field_180217_c.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Don't know how to search for " + clazz2);
        }
        List list = this.field_180218_a.computeIfAbsent(clazz2, clazz -> this.field_181745_e.stream().filter(clazz::isInstance).collect(Collectors.toList()));
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.field_181745_e.isEmpty()) {
            return Collections.emptyIterator();
        }
        return Iterators.unmodifiableIterator(this.field_181745_e.iterator());
    }

    public List<T> func_241289_a_() {
        return ImmutableList.copyOf(this.field_181745_e);
    }

    @Override
    public int size() {
        return this.field_181745_e.size();
    }
}

