/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.google.common.collect.Lists;
import com.mojang.util.QueueLogAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.PlayerListComponent;
import net.minecraft.server.gui.StatsComponent;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftServerGui
extends JComponent {
    private static final Font field_164249_a = new Font("Monospaced", 0, 12);
    private static final Logger field_164248_b = LogManager.getLogger();
    private final DedicatedServer field_120021_b;
    private Thread field_206932_d;
    private final Collection<Runnable> field_219051_e = Lists.newArrayList();
    private final AtomicBoolean field_219052_f = new AtomicBoolean();

    public static MinecraftServerGui func_219048_a(final DedicatedServer dedicatedServer) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame jFrame = new JFrame("Minecraft server");
        final MinecraftServerGui \u26032 = new MinecraftServerGui(dedicatedServer);
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(\u26032);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!\u26032.field_219052_f.getAndSet(true)) {
                    jFrame.setTitle("Minecraft server - shutting down!");
                    dedicatedServer.func_71263_m(true);
                    \u26032.func_219046_f();
                }
            }
        });
        \u26032.func_219045_a(jFrame::dispose);
        \u26032.func_206931_a();
        return \u26032;
    }

    private MinecraftServerGui(DedicatedServer dedicatedServer) {
        this.field_120021_b = dedicatedServer;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.func_120018_d(), "Center");
            this.add((Component)this.func_120019_b(), "West");
        }
        catch (Exception exception) {
            field_164248_b.error("Couldn't build server GUI", (Throwable)exception);
        }
    }

    public void func_219045_a(Runnable runnable) {
        this.field_219051_e.add(runnable);
    }

    private JComponent func_120019_b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        StatsComponent \u26032 = new StatsComponent(this.field_120021_b);
        this.field_219051_e.add(\u26032::func_219053_a);
        jPanel.add((Component)\u26032, "North");
        jPanel.add((Component)this.func_120020_c(), "Center");
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jPanel;
    }

    private JComponent func_120020_c() {
        PlayerListComponent playerListComponent = new PlayerListComponent(this.field_120021_b);
        JScrollPane \u26032 = new JScrollPane(playerListComponent, 22, 30);
        \u26032.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return \u26032;
    }

    private JComponent func_120018_d() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea \u26032 = new JTextArea();
        JScrollPane \u26033 = new JScrollPane(\u26032, 22, 30);
        \u26032.setEditable(false);
        \u26032.setFont(field_164249_a);
        JTextField \u26034 = new JTextField();
        \u26034.addActionListener(actionEvent -> {
            String string = \u26034.getText().trim();
            if (!string.isEmpty()) {
                this.field_120021_b.func_195581_a(string, this.field_120021_b.func_195573_aM());
            }
            \u26034.setText("");
        });
        \u26032.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        jPanel.add((Component)\u26033, "Center");
        jPanel.add((Component)\u26034, "South");
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.field_206932_d = new Thread(() -> {
            while ((\u2603 = QueueLogAppender.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                this.func_164247_a(\u26032, \u26033, \u2603);
            }
        });
        this.field_206932_d.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_164248_b));
        this.field_206932_d.setDaemon(true);
        return jPanel;
    }

    public void func_206931_a() {
        this.field_206932_d.start();
    }

    public void func_219050_b() {
        if (!this.field_219052_f.getAndSet(true)) {
            this.func_219046_f();
        }
    }

    private void func_219046_f() {
        this.field_219051_e.forEach(Runnable::run);
    }

    public void func_164247_a(JTextArea jTextArea, JScrollPane jScrollPane, String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.func_164247_a(jTextArea, jScrollPane, string));
            return;
        }
        Document document = jTextArea.getDocument();
        JScrollBar \u26032 = jScrollPane.getVerticalScrollBar();
        boolean \u26033 = false;
        if (jScrollPane.getViewport().getView() == jTextArea) {
            \u26033 = (double)\u26032.getValue() + \u26032.getSize().getHeight() + (double)(field_164249_a.getSize() * 4) > (double)\u26032.getMaximum();
        }
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (\u26033) {
            \u26032.setValue(Integer.MAX_VALUE);
        }
    }
}

