/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.profiler.FilledProfileResult;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfilerSection;
import net.minecraft.profiler.IResultableProfiler;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class Profiler
implements IResultableProfiler {
    private static final long field_219907_a = Duration.ofMillis(100L).toNanos();
    private static final Logger field_151234_b = LogManager.getLogger();
    private final List<String> field_76325_b = Lists.newArrayList();
    private final LongList field_76326_c = new LongArrayList();
    private final Map<String, Section> field_230078_e_ = Maps.newHashMap();
    private final IntSupplier field_219912_f;
    private final LongSupplier field_233501_g_;
    private final long field_219913_g;
    private final int field_219914_h;
    private String field_219915_i = "";
    private boolean field_219916_j;
    @Nullable
    private Section field_230079_k_;
    private final boolean field_226230_l_;

    public Profiler(LongSupplier longSupplier, IntSupplier intSupplier, boolean bl) {
        this.field_219913_g = longSupplier.getAsLong();
        this.field_233501_g_ = longSupplier;
        this.field_219914_h = intSupplier.getAsInt();
        this.field_219912_f = intSupplier;
        this.field_226230_l_ = bl;
    }

    @Override
    public void func_219894_a() {
        if (this.field_219916_j) {
            field_151234_b.error("Profiler tick already started - missing endTick()?");
            return;
        }
        this.field_219916_j = true;
        this.field_219915_i = "";
        this.field_76325_b.clear();
        this.func_76320_a("root");
    }

    @Override
    public void func_219897_b() {
        if (!this.field_219916_j) {
            field_151234_b.error("Profiler tick already ended - missing startTick()?");
            return;
        }
        this.func_76319_b();
        this.field_219916_j = false;
        if (!this.field_219915_i.isEmpty()) {
            field_151234_b.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", new Supplier[]{() -> IProfileResult.func_225434_b(this.field_219915_i)});
        }
    }

    @Override
    public void func_76320_a(String string) {
        if (!this.field_219916_j) {
            field_151234_b.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)string);
            return;
        }
        if (!this.field_219915_i.isEmpty()) {
            this.field_219915_i = this.field_219915_i + '\u001e';
        }
        this.field_219915_i = this.field_219915_i + string;
        this.field_76325_b.add(this.field_219915_i);
        this.field_76326_c.add(Util.func_211178_c());
        this.field_230079_k_ = null;
    }

    @Override
    public void func_194340_a(java.util.function.Supplier<String> supplier) {
        this.func_76320_a(supplier.get());
    }

    @Override
    public void func_76319_b() {
        if (!this.field_219916_j) {
            field_151234_b.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
            return;
        }
        if (this.field_76326_c.isEmpty()) {
            field_151234_b.error("Tried to pop one too many times! Mismatched push() and pop()?");
            return;
        }
        long l = Util.func_211178_c();
        \u2603 = this.field_76326_c.removeLong(this.field_76326_c.size() - 1);
        this.field_76325_b.remove(this.field_76325_b.size() - 1);
        \u2603 = l - \u2603;
        Section \u26032 = this.func_230081_e_();
        \u26032.field_230082_a_ = \u26032.field_230082_a_ + \u2603;
        \u26032.field_230083_b_ = \u26032.field_230083_b_ + 1L;
        if (this.field_226230_l_ && \u2603 > field_219907_a) {
            field_151234_b.warn("Something's taking too long! '{}' took aprox {} ms", new Supplier[]{() -> IProfileResult.func_225434_b(this.field_219915_i), () -> (double)\u2603 / 1000000.0});
        }
        this.field_219915_i = this.field_76325_b.isEmpty() ? "" : this.field_76325_b.get(this.field_76325_b.size() - 1);
        this.field_230079_k_ = null;
    }

    @Override
    public void func_219895_b(String string) {
        this.func_76319_b();
        this.func_76320_a(string);
    }

    private Section func_230081_e_() {
        if (this.field_230079_k_ == null) {
            this.field_230079_k_ = this.field_230078_e_.computeIfAbsent(this.field_219915_i, string -> new Section());
        }
        return this.field_230079_k_;
    }

    @Override
    public void func_230035_c_(String string) {
        this.func_230081_e_().field_230084_c_.addTo((Object)string, 1L);
    }

    @Override
    public void func_230036_c_(java.util.function.Supplier<String> supplier) {
        this.func_230081_e_().field_230084_c_.addTo((Object)supplier.get(), 1L);
    }

    @Override
    public IProfileResult func_219905_d() {
        return new FilledProfileResult(this.field_230078_e_, this.field_219913_g, this.field_219914_h, this.field_233501_g_.getAsLong(), this.field_219912_f.getAsInt());
    }

    static class Section
    implements IProfilerSection {
        private long field_230082_a_;
        private long field_230083_b_;
        private Object2LongOpenHashMap<String> field_230084_c_ = new Object2LongOpenHashMap();

        private Section() {
        }

        @Override
        public long func_230037_a_() {
            return this.field_230082_a_;
        }

        @Override
        public long func_230038_b_() {
            return this.field_230083_b_;
        }

        @Override
        public Object2LongMap<String> func_230039_c_() {
            return Object2LongMaps.unmodifiable(this.field_230084_c_);
        }
    }
}

