/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.login;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.IServerLoginNetHandler;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerLoginNetHandler
implements IServerLoginNetHandler {
    private static final AtomicInteger field_147331_b = new AtomicInteger(0);
    private static final Logger field_147332_c = LogManager.getLogger();
    private static final Random field_147329_d = new Random();
    private final byte[] field_147330_e = new byte[4];
    private final MinecraftServer field_147327_f;
    public final NetworkManager field_147333_a;
    private State field_147328_g = State.HELLO;
    private int field_147336_h;
    private GameProfile field_147337_i;
    private final String field_147334_j = "";
    private SecretKey field_147335_k;
    private ServerPlayerEntity field_181025_l;

    public ServerLoginNetHandler(MinecraftServer minecraftServer, NetworkManager networkManager) {
        this.field_147327_f = minecraftServer;
        this.field_147333_a = networkManager;
        field_147329_d.nextBytes(this.field_147330_e);
    }

    public void func_73660_a() {
        ServerPlayerEntity serverPlayerEntity;
        if (this.field_147328_g == State.READY_TO_ACCEPT) {
            this.func_147326_c();
        } else if (this.field_147328_g == State.DELAY_ACCEPT && (serverPlayerEntity = this.field_147327_f.func_184103_al().func_177451_a(this.field_147337_i.getId())) == null) {
            this.field_147328_g = State.READY_TO_ACCEPT;
            this.field_147327_f.func_184103_al().func_72355_a(this.field_147333_a, this.field_181025_l);
            this.field_181025_l = null;
        }
        if (this.field_147336_h++ == 600) {
            this.func_194026_b(new TranslationTextComponent("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public NetworkManager func_147298_b() {
        return this.field_147333_a;
    }

    public void func_194026_b(ITextComponent iTextComponent) {
        try {
            field_147332_c.info("Disconnecting {}: {}", (Object)this.func_147317_d(), (Object)iTextComponent.getString());
            this.field_147333_a.func_179290_a(new SDisconnectLoginPacket(iTextComponent));
            this.field_147333_a.func_150718_a(iTextComponent);
        }
        catch (Exception exception) {
            field_147332_c.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void func_147326_c() {
        ITextComponent iTextComponent;
        if (!this.field_147337_i.isComplete()) {
            this.field_147337_i = this.func_152506_a(this.field_147337_i);
        }
        if ((iTextComponent = this.field_147327_f.func_184103_al().func_206258_a(this.field_147333_a.func_74430_c(), this.field_147337_i)) != null) {
            this.func_194026_b(iTextComponent);
        } else {
            this.field_147328_g = State.ACCEPTED;
            if (this.field_147327_f.func_175577_aI() >= 0 && !this.field_147333_a.func_150731_c()) {
                this.field_147333_a.func_201058_a(new SEnableCompressionPacket(this.field_147327_f.func_175577_aI()), (GenericFutureListener<? extends Future<? super Void>>)((ChannelFutureListener)channelFuture -> this.field_147333_a.func_179289_a(this.field_147327_f.func_175577_aI())));
            }
            this.field_147333_a.func_179290_a(new SLoginSuccessPacket(this.field_147337_i));
            ServerPlayerEntity serverPlayerEntity = this.field_147327_f.func_184103_al().func_177451_a(this.field_147337_i.getId());
            if (serverPlayerEntity != null) {
                this.field_147328_g = State.DELAY_ACCEPT;
                this.field_181025_l = this.field_147327_f.func_184103_al().func_148545_a(this.field_147337_i);
            } else {
                this.field_147327_f.func_184103_al().func_72355_a(this.field_147333_a, this.field_147327_f.func_184103_al().func_148545_a(this.field_147337_i));
            }
        }
    }

    @Override
    public void func_147231_a(ITextComponent iTextComponent) {
        field_147332_c.info("{} lost connection: {}", (Object)this.func_147317_d(), (Object)iTextComponent.getString());
    }

    public String func_147317_d() {
        if (this.field_147337_i != null) {
            return this.field_147337_i + " (" + this.field_147333_a.func_74430_c() + ")";
        }
        return String.valueOf(this.field_147333_a.func_74430_c());
    }

    @Override
    public void func_147316_a(CLoginStartPacket cLoginStartPacket) {
        Validate.validState((this.field_147328_g == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.field_147337_i = cLoginStartPacket.func_149304_c();
        if (this.field_147327_f.func_71266_T() && !this.field_147333_a.func_150731_c()) {
            this.field_147328_g = State.KEY;
            this.field_147333_a.func_179290_a(new SEncryptionRequestPacket("", this.field_147327_f.func_71250_E().getPublic(), this.field_147330_e));
        } else {
            this.field_147328_g = State.READY_TO_ACCEPT;
        }
    }

    @Override
    public void func_147315_a(CEncryptionResponsePacket cEncryptionResponsePacket) {
        Validate.validState((this.field_147328_g == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        PrivateKey privateKey = this.field_147327_f.func_71250_E().getPrivate();
        if (!Arrays.equals(this.field_147330_e, cEncryptionResponsePacket.func_149299_b(privateKey))) {
            throw new IllegalStateException("Invalid nonce!");
        }
        this.field_147335_k = cEncryptionResponsePacket.func_149300_a(privateKey);
        this.field_147328_g = State.AUTHENTICATING;
        this.field_147333_a.func_150727_a(this.field_147335_k);
        Thread \u26032 = new Thread("User Authenticator #" + field_147331_b.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameProfile = ServerLoginNetHandler.this.field_147337_i;
                try {
                    String string = new BigInteger(CryptManager.func_75895_a("", ServerLoginNetHandler.this.field_147327_f.func_71250_E().getPublic(), ServerLoginNetHandler.this.field_147335_k)).toString(16);
                    ServerLoginNetHandler.this.field_147337_i = ServerLoginNetHandler.this.field_147327_f.func_147130_as().hasJoinedServer(new GameProfile(null, gameProfile.getName()), string, this.func_191235_a());
                    if (ServerLoginNetHandler.this.field_147337_i != null) {
                        field_147332_c.info("UUID of player {} is {}", (Object)ServerLoginNetHandler.this.field_147337_i.getName(), (Object)ServerLoginNetHandler.this.field_147337_i.getId());
                        ServerLoginNetHandler.this.field_147328_g = State.READY_TO_ACCEPT;
                    } else if (ServerLoginNetHandler.this.field_147327_f.func_71264_H()) {
                        field_147332_c.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginNetHandler.this.field_147337_i = ServerLoginNetHandler.this.func_152506_a(gameProfile);
                        ServerLoginNetHandler.this.field_147328_g = State.READY_TO_ACCEPT;
                    } else {
                        ServerLoginNetHandler.this.func_194026_b(new TranslationTextComponent("multiplayer.disconnect.unverified_username"));
                        field_147332_c.error("Username '{}' tried to join with an invalid session", (Object)gameProfile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationUnavailableException) {
                    if (ServerLoginNetHandler.this.field_147327_f.func_71264_H()) {
                        field_147332_c.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginNetHandler.this.field_147337_i = ServerLoginNetHandler.this.func_152506_a(gameProfile);
                        ServerLoginNetHandler.this.field_147328_g = State.READY_TO_ACCEPT;
                    }
                    ServerLoginNetHandler.this.func_194026_b(new TranslationTextComponent("multiplayer.disconnect.authservers_down"));
                    field_147332_c.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress func_191235_a() {
                SocketAddress socketAddress = ServerLoginNetHandler.this.field_147333_a.func_74430_c();
                return ServerLoginNetHandler.this.field_147327_f.func_190518_ac() && socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress() : null;
            }
        };
        \u26032.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147332_c));
        \u26032.start();
    }

    @Override
    public void func_209526_a(CCustomPayloadLoginPacket cCustomPayloadLoginPacket) {
        this.func_194026_b(new TranslationTextComponent("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile func_152506_a(GameProfile gameProfile) {
        UUID uUID = PlayerEntity.func_175147_b(gameProfile.getName());
        return new GameProfile(uUID, gameProfile.getName());
    }

    static enum State {
        HELLO,
        KEY,
        AUTHENTICATING,
        NEGOTIATING,
        READY_TO_ACCEPT,
        DELAY_ACCEPT,
        ACCEPTED;

    }
}

