/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.merchant.villager;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.INPC;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractVillagerEntity
extends AgeableEntity
implements INPC,
IMerchant {
    private static final DataParameter<Integer> field_222820_bA = EntityDataManager.func_187226_a(AbstractVillagerEntity.class, DataSerializers.field_187192_b);
    @Nullable
    private PlayerEntity field_213725_bA;
    @Nullable
    protected MerchantOffers field_213724_bz;
    private final Inventory field_213722_bB = new Inventory(8);

    public AbstractVillagerEntity(EntityType<? extends AbstractVillagerEntity> entityType, World world) {
        super((EntityType<? extends AgeableEntity>)entityType, world);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld2, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        IServerWorld iServerWorld2;
        if (iLivingEntityData2 == null) {
            ILivingEntityData iLivingEntityData2 = new AgeableEntity.AgeableData(false);
        }
        return super.func_213386_a(iServerWorld2, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
    }

    public int func_213719_ec() {
        return this.field_70180_af.func_187225_a(field_222820_bA);
    }

    public void func_213720_r(int n) {
        this.field_70180_af.func_187227_b(field_222820_bA, n);
    }

    @Override
    public int func_213708_dV() {
        return 0;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        if (this.func_70631_g_()) {
            return 0.81f;
        }
        return 1.62f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_222820_bA, 0);
    }

    @Override
    public void func_70932_a_(@Nullable PlayerEntity playerEntity) {
        this.field_213725_bA = playerEntity;
    }

    @Override
    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.field_213725_bA;
    }

    public boolean func_213716_dX() {
        return this.field_213725_bA != null;
    }

    @Override
    public MerchantOffers func_213706_dY() {
        if (this.field_213724_bz == null) {
            this.field_213724_bz = new MerchantOffers();
            this.func_213712_ef();
        }
        return this.field_213724_bz;
    }

    @Override
    public void func_213702_q(int n) {
    }

    @Override
    public void func_213704_a(MerchantOffer merchantOffer) {
        merchantOffer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.func_213713_b(merchantOffer);
        if (this.field_213725_bA instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192138_r.func_215114_a((ServerPlayerEntity)this.field_213725_bA, this, merchantOffer.func_222200_d());
        }
    }

    protected abstract void func_213713_b(MerchantOffer var1);

    @Override
    public boolean func_213705_dZ() {
        return true;
    }

    @Override
    public void func_110297_a_(ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.func_213721_r(!itemStack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    protected SoundEvent func_213721_r(boolean bl) {
        return bl ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm;
    }

    public void func_213711_eb() {
        this.func_184185_a(SoundEvents.field_219721_mv, this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        MerchantOffers merchantOffers = this.func_213706_dY();
        if (!merchantOffers.isEmpty()) {
            compoundNBT.func_218657_a("Offers", merchantOffers.func_222199_a());
        }
        compoundNBT.func_218657_a("Inventory", this.field_213722_bB.func_70487_g());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compoundNBT.func_74775_l("Offers"));
        }
        this.field_213722_bB.func_70486_a(compoundNBT.func_150295_c("Inventory", 10));
    }

    @Override
    @Nullable
    public Entity func_241206_a_(ServerWorld serverWorld) {
        this.func_213750_eg();
        return super.func_241206_a_(serverWorld);
    }

    protected void func_213750_eg() {
        this.func_70932_a_(null);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.func_213750_eg();
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return false;
    }

    public Inventory func_213715_ed() {
        return this.field_213722_bB;
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        if (super.func_174820_d(n, itemStack)) {
            return true;
        }
        int n2 = n - 300;
        if (n2 >= 0 && n2 < this.field_213722_bB.func_70302_i_()) {
            this.field_213722_bB.func_70299_a(n2, itemStack);
            return true;
        }
        return false;
    }

    @Override
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    protected abstract void func_213712_ef();

    protected void func_213717_a(MerchantOffers merchantOffers, VillagerTrades.ITrade[] iTradeArray, int n) {
        HashSet hashSet = Sets.newHashSet();
        if (iTradeArray.length > n) {
            while (hashSet.size() < n) {
                hashSet.add(this.field_70146_Z.nextInt(iTradeArray.length));
            }
        } else {
            for (int i = 0; i < iTradeArray.length; ++i) {
                hashSet.add(i);
            }
        }
        for (Integer \u26032 : hashSet) {
            VillagerTrades.ITrade iTrade = iTradeArray[\u26032];
            MerchantOffer \u26033 = iTrade.func_221182_a(this, this.field_70146_Z);
            if (\u26033 == null) continue;
            merchantOffers.add(\u26033);
        }
    }
}

