/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class WitherEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Integer> field_184741_a = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184742_b = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184743_c = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private static final List<DataParameter<Integer>> field_184745_bv = ImmutableList.of(field_184741_a, field_184742_b, field_184743_c);
    private static final DataParameter<Integer> field_184746_bw = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private final float[] field_82220_d = new float[2];
    private final float[] field_82221_e = new float[2];
    private final float[] field_82217_f = new float[2];
    private final float[] field_82218_g = new float[2];
    private final int[] field_82223_h = new int[2];
    private final int[] field_82224_i = new int[2];
    private int field_82222_j;
    private final ServerBossInfo field_184744_bE = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final Predicate<LivingEntity> field_82219_bJ = livingEntity -> livingEntity.func_70668_bt() != CreatureAttribute.field_223223_b_ && livingEntity.func_190631_cK();
    private static final EntityPredicate field_213798_bB = new EntityPredicate().func_221013_a(20.0).func_221012_a(field_82219_bJ);

    public WitherEntity(EntityType<? extends WitherEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.func_70606_j(this.func_110138_aP());
        this.func_70661_as().func_212239_d(true);
        this.field_70728_aV = 50;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, new RangedAttackGoal(this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<MobEntity>(this, MobEntity.class, 0, false, false, field_82219_bJ));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184741_a, 0);
        this.field_70180_af.func_187214_a(field_184742_b, 0);
        this.field_70180_af.func_187214_a(field_184743_c, 0);
        this.field_70180_af.func_187214_a(field_184746_bw, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Invul", this.func_82212_n());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_82215_s(compoundNBT.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.field_184744_bE.func_186739_a(this.func_145748_c_());
        }
    }

    @Override
    public void func_200203_b(@Nullable ITextComponent iTextComponent) {
        super.func_200203_b(iTextComponent);
        this.field_184744_bE.func_186739_a(this.func_145748_c_());
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187925_gy;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187851_gB;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    @Override
    public void func_70636_d() {
        int n;
        Vector3d \u26032 = this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0);
        if (!this.field_70170_p.field_72995_K && this.func_82203_t(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.func_82203_t(0))) != null) {
            Entity entity;
            double d = \u26032.field_72448_b;
            if (this.func_226278_cu_() < entity.func_226278_cu_() || !this.func_225509_J__() && this.func_226278_cu_() < entity.func_226278_cu_() + 5.0) {
                d = Math.max(0.0, d);
                d += 0.3 - d * (double)0.6f;
            }
            \u26032 = new Vector3d(\u26032.field_72450_a, d, \u26032.field_72449_c);
            Vector3d \u26033 = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), 0.0, entity.func_226281_cx_() - this.func_226281_cx_());
            if (WitherEntity.func_213296_b(\u26033) > 9.0) {
                Vector3d vector3d = \u26033.func_72432_b();
                \u26032 = \u26032.func_72441_c(vector3d.field_72450_a * 0.3 - \u26032.field_72450_a * 0.6, 0.0, vector3d.field_72449_c * 0.3 - \u26032.field_72449_c * 0.6);
            }
        }
        this.func_213317_d(\u26032);
        if (WitherEntity.func_213296_b(\u26032) > 0.05) {
            this.field_70177_z = (float)MathHelper.func_181159_b(\u26032.field_72449_c, \u26032.field_72450_a) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (n = 0; n < 2; ++n) {
            this.field_82218_g[n] = this.field_82221_e[n];
            this.field_82217_f[n] = this.field_82220_d[n];
        }
        for (n = 0; n < 2; ++n) {
            \u2603 = this.func_82203_t(n + 1);
            Entity entity = null;
            if (\u2603 > 0) {
                entity = this.field_70170_p.func_73045_a(\u2603);
            }
            if (entity != null) {
                double d = this.func_82214_u(n + 1);
                \u2603 = this.func_82208_v(n + 1);
                \u2603 = this.func_82213_w(n + 1);
                \u2603 = entity.func_226277_ct_() - d;
                \u2603 = entity.func_226280_cw_() - \u2603;
                \u2603 = entity.func_226281_cx_() - \u2603;
                \u2603 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603);
                float \u26034 = (float)(MathHelper.func_181159_b(\u2603, \u2603) * 57.2957763671875) - 90.0f;
                float \u26035 = (float)(-(MathHelper.func_181159_b(\u2603, \u2603) * 57.2957763671875));
                this.field_82220_d[n] = this.func_82204_b(this.field_82220_d[n], \u26035, 40.0f);
                this.field_82221_e[n] = this.func_82204_b(this.field_82221_e[n], \u26034, 10.0f);
                continue;
            }
            this.field_82221_e[n] = this.func_82204_b(this.field_82221_e[n], this.field_70761_aq, 10.0f);
        }
        n = this.func_225509_J__() ? 1 : 0;
        for (i = 0; i < 3; ++i) {
            double d = this.func_82214_u(i);
            \u2603 = this.func_82208_v(i);
            \u2603 = this.func_82213_w(i);
            this.field_70170_p.func_195594_a(ParticleTypes.field_197601_L, d + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (n == 0 || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_195594_a(ParticleTypes.field_197625_r, d + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.func_82212_n() > 0) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a(ParticleTypes.field_197625_r, this.func_226277_ct_() + this.field_70146_Z.nextGaussian(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.func_226281_cx_() + this.field_70146_Z.nextGaussian(), 0.7f, 0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        int n;
        if (this.func_82212_n() > 0) {
            int n2 = this.func_82212_n() - 1;
            if (n2 <= 0) {
                Explosion.Mode mode = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                this.field_70170_p.func_217398_a(this, this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), 7.0f, false, mode);
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_175669_a(1023, this.func_233580_cy_(), 0);
                }
            }
            this.func_82215_s(n2);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
            return;
        }
        super.func_70619_bc();
        block0: for (n = 1; n < 3; ++n) {
            Object object;
            if (this.field_70173_aa < this.field_82223_h[n - 1]) continue;
            this.field_82223_h[n - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                int n3 = n - 1;
                int n4 = this.field_82224_i[n3];
                this.field_82224_i[n3] = n4 + 1;
                if (n4 > 15) {
                    float f = 10.0f;
                    \u2603 = 5.0f;
                    double \u26032 = MathHelper.func_82716_a(this.field_70146_Z, this.func_226277_ct_() - 10.0, this.func_226277_ct_() + 10.0);
                    double \u26033 = MathHelper.func_82716_a(this.field_70146_Z, this.func_226278_cu_() - 5.0, this.func_226278_cu_() + 5.0);
                    double \u26034 = MathHelper.func_82716_a(this.field_70146_Z, this.func_226281_cx_() - 10.0, this.func_226281_cx_() + 10.0);
                    this.func_82209_a(n + 1, \u26032, \u26033, \u26034, true);
                    this.field_82224_i[n - 1] = 0;
                }
            }
            if ((\u2603 = this.func_82203_t(n)) > 0) {
                object = this.field_70170_p.func_73045_a(\u2603);
                if (object == null || !((Entity)object).func_70089_S() || this.func_70068_e((Entity)object) > 900.0 || !this.func_70685_l((Entity)object)) {
                    this.func_82211_c(n, 0);
                    continue;
                }
                if (object instanceof PlayerEntity && ((PlayerEntity)object).field_71075_bZ.field_75102_a) {
                    this.func_82211_c(n, 0);
                    continue;
                }
                this.func_82216_a(n + 1, (LivingEntity)object);
                this.field_82223_h[n - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                this.field_82224_i[n - 1] = 0;
                continue;
            }
            object = this.field_70170_p.func_217374_a(LivingEntity.class, field_213798_bB, this, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0));
            for (int i = 0; i < 10 && !object.isEmpty(); ++i) {
                LivingEntity livingEntity = (LivingEntity)object.get(this.field_70146_Z.nextInt(object.size()));
                if (livingEntity != this && livingEntity.func_70089_S() && this.func_70685_l(livingEntity)) {
                    if (livingEntity instanceof PlayerEntity) {
                        if (((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a) continue block0;
                        this.func_82211_c(n, livingEntity.func_145782_y());
                        continue block0;
                    }
                    this.func_82211_c(n, livingEntity.func_145782_y());
                    continue block0;
                }
                object.remove(livingEntity);
            }
        }
        if (this.func_70638_az() != null) {
            this.func_82211_c(0, this.func_70638_az().func_145782_y());
        } else {
            this.func_82211_c(0, 0);
        }
        if (this.field_82222_j > 0) {
            --this.field_82222_j;
            if (this.field_82222_j == 0 && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                n = MathHelper.func_76128_c(this.func_226278_cu_());
                \u2603 = MathHelper.func_76128_c(this.func_226277_ct_());
                \u2603 = MathHelper.func_76128_c(this.func_226281_cx_());
                boolean \u26035 = false;
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                        for (\u2603 = 0; \u2603 <= 3; ++\u2603) {
                            \u2603 = \u2603 + \u2603;
                            \u2603 = n + \u2603;
                            \u2603 = \u2603 + \u2603;
                            BlockPos blockPos = new BlockPos(\u2603, \u2603, \u2603);
                            BlockState \u26036 = this.field_70170_p.func_180495_p(blockPos);
                            if (!WitherEntity.func_181033_a(\u26036)) continue;
                            \u26035 = this.field_70170_p.func_225521_a_(blockPos, true, this) || \u26035;
                        }
                    }
                }
                if (\u26035) {
                    this.field_70170_p.func_217378_a(null, 1022, this.func_233580_cy_(), 0);
                }
            }
        }
        if (this.field_70173_aa % 20 == 0) {
            this.func_70691_i(1.0f);
        }
        this.field_184744_bE.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public static boolean func_181033_a(BlockState blockState) {
        return !blockState.func_196958_f() && !BlockTags.field_219755_X.func_230235_a_(blockState.func_177230_c());
    }

    public void func_82206_m() {
        this.func_82215_s(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    @Override
    public void func_213295_a(BlockState blockState, Vector3d vector3d) {
    }

    @Override
    public void func_184178_b(ServerPlayerEntity serverPlayerEntity) {
        super.func_184178_b(serverPlayerEntity);
        this.field_184744_bE.func_186760_a(serverPlayerEntity);
    }

    @Override
    public void func_184203_c(ServerPlayerEntity serverPlayerEntity) {
        super.func_184203_c(serverPlayerEntity);
        this.field_184744_bE.func_186761_b(serverPlayerEntity);
    }

    private double func_82214_u(int n) {
        if (n <= 0) {
            return this.func_226277_ct_();
        }
        float f = (this.field_70761_aq + (float)(180 * (n - 1))) * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76134_b(f);
        return this.func_226277_ct_() + (double)\u2603 * 1.3;
    }

    private double func_82208_v(int n) {
        if (n <= 0) {
            return this.func_226278_cu_() + 3.0;
        }
        return this.func_226278_cu_() + 2.2;
    }

    private double func_82213_w(int n) {
        if (n <= 0) {
            return this.func_226281_cx_();
        }
        float f = (this.field_70761_aq + (float)(180 * (n - 1))) * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76126_a(f);
        return this.func_226281_cx_() + (double)\u2603 * 1.3;
    }

    private float func_82204_b(float f, float f2, float f3) {
        \u2603 = MathHelper.func_76142_g(f2 - f);
        if (\u2603 > f3) {
            \u2603 = f3;
        }
        if (\u2603 < -f3) {
            \u2603 = -f3;
        }
        return f + \u2603;
    }

    private void func_82216_a(int n, LivingEntity livingEntity) {
        this.func_82209_a(n, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + (double)livingEntity.func_70047_e() * 0.5, livingEntity.func_226281_cx_(), n == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void func_82209_a(int n, double d, double d2, double d3, boolean bl) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_217378_a(null, 1024, this.func_233580_cy_(), 0);
        }
        double d4 = this.func_82214_u(n);
        \u2603 = this.func_82208_v(n);
        \u2603 = this.func_82213_w(n);
        \u2603 = d - d4;
        \u2603 = d2 - \u2603;
        \u2603 = d3 - \u2603;
        WitherSkullEntity \u26032 = new WitherSkullEntity(this.field_70170_p, this, \u2603, \u2603, \u2603);
        \u26032.func_212361_a(this);
        if (bl) {
            \u26032.func_82343_e(true);
        }
        \u26032.func_226288_n_(d4, \u2603, \u2603);
        this.field_70170_p.func_217376_c(\u26032);
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        this.func_82216_a(0, livingEntity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (damageSource == DamageSource.field_76369_e || damageSource.func_76346_g() instanceof WitherEntity) {
            return false;
        }
        if (this.func_82212_n() > 0 && damageSource != DamageSource.field_76380_i) {
            return false;
        }
        if (this.func_225509_J__() && (entity = damageSource.func_76364_f()) instanceof AbstractArrowEntity) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (entity != null && !(entity instanceof PlayerEntity) && entity instanceof LivingEntity && ((LivingEntity)entity).func_70668_bt() == this.func_70668_bt()) {
            return false;
        }
        if (this.field_82222_j <= 0) {
            this.field_82222_j = 20;
        }
        int \u26032 = 0;
        while (\u26032 < this.field_82224_i.length) {
            int n = \u26032++;
            this.field_82224_i[n] = this.field_82224_i[n] + 3;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
        super.func_213333_a(damageSource, n, bl);
        ItemEntity itemEntity = this.func_199703_a(Items.field_151156_bN);
        if (itemEntity != null) {
            itemEntity.func_174873_u();
        }
    }

    @Override
    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
            return;
        }
        this.field_70708_bq = 0;
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        return false;
    }

    @Override
    public boolean func_195064_c(EffectInstance effectInstance) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute func_234258_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, 0.6f).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public int func_82212_n() {
        return this.field_70180_af.func_187225_a(field_184746_bw);
    }

    public void func_82215_s(int n) {
        this.field_70180_af.func_187227_b(field_184746_bw, n);
    }

    public int func_82203_t(int n) {
        return this.field_70180_af.func_187225_a(field_184745_bv.get(n));
    }

    public void func_82211_c(int n, int n2) {
        this.field_70180_af.func_187227_b(field_184745_bv.get(n), n2);
    }

    public boolean func_225509_J__() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return false;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public boolean func_70687_e(EffectInstance effectInstance) {
        if (effectInstance.func_188419_a() == Effects.field_82731_v) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return WitherEntity.this.func_82212_n() > 0;
        }
    }
}

