/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Memory;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Brain<E extends LivingEntity> {
    private static final Logger field_233688_a_ = LogManager.getLogger();
    private final Supplier<Codec<Brain<E>>> field_233689_b_;
    private final Map<MemoryModuleType<?>, Optional<? extends Memory<?>>> field_218230_a = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> field_218231_b = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<Task<? super E>>>> field_218232_c = Maps.newTreeMap();
    private Schedule field_218233_d = Schedule.field_221383_a;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>> field_218234_e = Maps.newHashMap();
    private final Map<Activity, Set<MemoryModuleType<?>>> field_233691_h_ = Maps.newHashMap();
    private Set<Activity> field_218235_f = Sets.newHashSet();
    private final Set<Activity> field_218236_g = Sets.newHashSet();
    private Activity field_218237_h = Activity.field_221366_b;
    private long field_218238_i = -9999L;

    public static <E extends LivingEntity> BrainCodec<E> func_233705_a_(Collection<? extends MemoryModuleType<?>> collection, Collection<? extends SensorType<? extends Sensor<? super E>>> collection2) {
        return new BrainCodec(collection, collection2);
    }

    public static <E extends LivingEntity> Codec<Brain<E>> func_233710_b_(final Collection<? extends MemoryModuleType<?>> collection, final Collection<? extends SensorType<? extends Sensor<? super E>>> collection2) {
        final MutableObject mutableObject = new MutableObject();
        mutableObject.setValue((Object)new MapCodec<Brain<E>>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return collection.stream().flatMap(memoryModuleType -> Util.func_215081_a(memoryModuleType.func_234107_a_().map(codec -> Registry.field_218372_N.func_177774_c((MemoryModuleType<?>)memoryModuleType)))).map(resourceLocation -> dynamicOps.createString(resourceLocation.toString()));
            }

            public <T> DataResult<Brain<E>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                MutableObject mutableObject2 = new MutableObject((Object)DataResult.success((Object)ImmutableList.builder()));
                mapLike.entries().forEach(pair -> {
                    DataResult dataResult = Registry.field_218372_N.parse(dynamicOps, pair.getFirst());
                    \u2603 = dataResult.flatMap(memoryModuleType -> this.func_233728_a_((MemoryModuleType)memoryModuleType, dynamicOps, (Object)pair.getSecond()));
                    mutableObject2.setValue((Object)((DataResult)mutableObject2.getValue()).apply2(ImmutableList.Builder::add, \u2603));
                });
                ImmutableList \u26032 = ((DataResult)mutableObject2.getValue()).resultOrPartial(arg_0 -> ((Logger)field_233688_a_).error(arg_0)).map(ImmutableList.Builder::build).orElseGet(ImmutableList::of);
                return DataResult.success(new Brain(collection, collection2, \u26032, () -> ((MutableObject)mutableObject).getValue()));
            }

            private <T, U> DataResult<MemoryCodec<U>> func_233728_a_(MemoryModuleType<U> memoryModuleType, DynamicOps<T> dynamicOps, T t) {
                return memoryModuleType.func_234107_a_().map(DataResult::success).orElseGet(() -> DataResult.error((String)("No codec for memory: " + memoryModuleType))).flatMap(codec -> codec.parse(dynamicOps, t)).map(memory -> new MemoryCodec(memoryModuleType, Optional.of(memory)));
            }

            public <T> RecordBuilder<T> encode(Brain<E> brain, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                brain.func_233720_j_().forEach(memoryCodec -> memoryCodec.func_233740_a_(dynamicOps, recordBuilder));
                return recordBuilder;
            }

            public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
                return this.encode((Brain)object, dynamicOps, recordBuilder);
            }
        }.fieldOf("memories").codec());
        return (Codec)mutableObject.getValue();
    }

    public Brain(Collection<? extends MemoryModuleType<?>> collection, Collection<? extends SensorType<? extends Sensor<? super E>>> collection2, ImmutableList<MemoryCodec<?>> immutableList2, Supplier<Codec<Brain<E>>> supplier) {
        ImmutableList<MemoryCodec<?>> immutableList2;
        this.field_233689_b_ = supplier;
        for (MemoryModuleType<?> memoryModuleType : collection) {
            this.field_218230_a.put(memoryModuleType, Optional.empty());
        }
        for (SensorType sensorType : collection2) {
            this.field_218231_b.put(sensorType, (Sensor<E>)sensorType.func_220995_a());
        }
        for (Sensor sensor : this.field_218231_b.values()) {
            for (MemoryModuleType<?> memoryModuleType : sensor.func_220974_a()) {
                this.field_218230_a.put(memoryModuleType, Optional.empty());
            }
        }
        for (MemoryCodec memoryCodec : immutableList2) {
            memoryCodec.func_233738_a_(this);
        }
    }

    public <T> DataResult<T> func_233702_a_(DynamicOps<T> dynamicOps) {
        return this.field_233689_b_.get().encodeStart(dynamicOps, (Object)this);
    }

    private Stream<MemoryCodec<?>> func_233720_j_() {
        return this.field_218230_a.entrySet().stream().map(entry -> MemoryCodec.func_233743_b_((MemoryModuleType)entry.getKey(), (Optional)entry.getValue()));
    }

    public boolean func_218191_a(MemoryModuleType<?> memoryModuleType) {
        return this.func_218196_a(memoryModuleType, MemoryModuleStatus.VALUE_PRESENT);
    }

    public <U> void func_218189_b(MemoryModuleType<U> memoryModuleType) {
        this.func_218226_a(memoryModuleType, Optional.empty());
    }

    public <U> void func_218205_a(MemoryModuleType<U> memoryModuleType, @Nullable U u) {
        this.func_218226_a(memoryModuleType, Optional.ofNullable(u));
    }

    public <U> void func_233696_a_(MemoryModuleType<U> memoryModuleType, U u, long l) {
        this.func_233709_b_(memoryModuleType, Optional.of(Memory.func_234069_a_(u, l)));
    }

    public <U> void func_218226_a(MemoryModuleType<U> memoryModuleType, Optional<? extends U> optional) {
        this.func_233709_b_(memoryModuleType, optional.map(Memory::func_234068_a_));
    }

    private <U> void func_233709_b_(MemoryModuleType<U> memoryModuleType, Optional<? extends Memory<?>> optional) {
        if (this.field_218230_a.containsKey(memoryModuleType)) {
            if (optional.isPresent() && this.func_218213_a(optional.get().func_234072_c_())) {
                this.func_218189_b(memoryModuleType);
            } else {
                this.field_218230_a.put(memoryModuleType, optional);
            }
        }
    }

    public <U> Optional<U> func_218207_c(MemoryModuleType<U> memoryModuleType) {
        return this.field_218230_a.get(memoryModuleType).map(Memory::func_234072_c_);
    }

    public <U> boolean func_233708_b_(MemoryModuleType<U> memoryModuleType, U u) {
        if (!this.func_218191_a(memoryModuleType)) {
            return false;
        }
        return this.func_218207_c(memoryModuleType).filter(object2 -> object2.equals(u)).isPresent();
    }

    public boolean func_218196_a(MemoryModuleType<?> memoryModuleType, MemoryModuleStatus memoryModuleStatus) {
        Optional<Memory<?>> optional = this.field_218230_a.get(memoryModuleType);
        if (optional == null) {
            return false;
        }
        return memoryModuleStatus == MemoryModuleStatus.REGISTERED || memoryModuleStatus == MemoryModuleStatus.VALUE_PRESENT && optional.isPresent() || memoryModuleStatus == MemoryModuleStatus.VALUE_ABSENT && !optional.isPresent();
    }

    public Schedule func_218198_b() {
        return this.field_218233_d;
    }

    public void func_218203_a(Schedule schedule) {
        this.field_218233_d = schedule;
    }

    public void func_218199_a(Set<Activity> set) {
        this.field_218235_f = set;
    }

    @Deprecated
    public List<Task<? super E>> func_233712_d_() {
        ObjectArrayList objectArrayList = new ObjectArrayList();
        for (Map<Activity, Set<Task<E>>> map : this.field_218232_c.values()) {
            for (Set<Task<E>> set : map.values()) {
                for (Task<E> task : set) {
                    if (task.func_220376_b() != Task.Status.RUNNING) continue;
                    objectArrayList.add(task);
                }
            }
        }
        return objectArrayList;
    }

    public void func_233714_e_() {
        this.func_233713_d_(this.field_218237_h);
    }

    public Optional<Activity> func_233716_f_() {
        for (Activity activity : this.field_218236_g) {
            if (this.field_218235_f.contains(activity)) continue;
            return Optional.of(activity);
        }
        return Optional.empty();
    }

    public void func_218202_a(Activity activity) {
        if (this.func_218217_d(activity)) {
            this.func_233713_d_(activity);
        } else {
            this.func_233714_e_();
        }
    }

    private void func_233713_d_(Activity activity) {
        if (this.func_218214_c(activity)) {
            return;
        }
        this.func_233715_e_(activity);
        this.field_218236_g.clear();
        this.field_218236_g.addAll(this.field_218235_f);
        this.field_218236_g.add(activity);
    }

    private void func_233715_e_(Activity activity) {
        for (Activity activity2 : this.field_218236_g) {
            if (activity2 == activity || (\u2603 = this.field_233691_h_.get(activity2)) == null) continue;
            for (MemoryModuleType<?> memoryModuleType : \u2603) {
                this.func_218189_b(memoryModuleType);
            }
        }
    }

    public void func_218211_a(long l, long l2) {
        if (l2 - this.field_218238_i > 20L) {
            this.field_218238_i = l2;
            Activity activity = this.func_218198_b().func_221377_a((int)(l % 24000L));
            if (!this.field_218236_g.contains(activity)) {
                this.func_218202_a(activity);
            }
        }
    }

    public void func_233706_a_(List<Activity> list) {
        for (Activity activity : list) {
            if (!this.func_218217_d(activity)) continue;
            this.func_233713_d_(activity);
            break;
        }
    }

    public void func_218200_b(Activity activity) {
        this.field_218237_h = activity;
    }

    public void func_233698_a_(Activity activity, int n, ImmutableList<? extends Task<? super E>> immutableList) {
        this.func_218208_a(activity, this.func_233692_a_(n, immutableList));
    }

    public void func_233699_a_(Activity activity, int n, ImmutableList<? extends Task<? super E>> immutableList, MemoryModuleType<?> memoryModuleType) {
        ImmutableSet immutableSet = ImmutableSet.of((Object)Pair.of(memoryModuleType, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT)));
        \u2603 = ImmutableSet.of(memoryModuleType);
        this.func_233701_a_(activity, (ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>>)this.func_233692_a_(n, immutableList), (Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>)immutableSet, (Set<MemoryModuleType<?>>)\u2603);
    }

    public void func_218208_a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> immutableList) {
        this.func_233701_a_(activity, immutableList, (Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>)ImmutableSet.of(), Sets.newHashSet());
    }

    public void func_233700_a_(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> immutableList, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> set) {
        this.func_233701_a_(activity, immutableList, set, Sets.newHashSet());
    }

    private void func_233701_a_(Activity activity2, ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> immutableList, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> set, Set<MemoryModuleType<?>> set2) {
        this.field_218234_e.put(activity2, set);
        if (!set2.isEmpty()) {
            this.field_233691_h_.put(activity2, set2);
        }
        for (Pair pair : immutableList) {
            this.field_218232_c.computeIfAbsent((Integer)pair.getFirst(), n -> Maps.newHashMap()).computeIfAbsent(activity2, activity -> Sets.newLinkedHashSet()).add(pair.getSecond());
        }
    }

    public boolean func_218214_c(Activity activity) {
        return this.field_218236_g.contains(activity);
    }

    public Brain<E> func_218185_f() {
        Brain<E> brain = new Brain<E>(this.field_218230_a.keySet(), this.field_218231_b.keySet(), ImmutableList.of(), this.field_233689_b_);
        for (Map.Entry<MemoryModuleType<?>, Optional<Memory<?>>> entry : this.field_218230_a.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            if (!entry.getValue().isPresent()) continue;
            brain.field_218230_a.put(memoryModuleType, entry.getValue());
        }
        return brain;
    }

    public void func_218210_a(ServerWorld serverWorld, E e) {
        this.func_233721_k_();
        this.func_233711_c_(serverWorld, e);
        this.func_218218_d(serverWorld, e);
        this.func_218222_e(serverWorld, e);
    }

    private void func_233711_c_(ServerWorld serverWorld, E e) {
        for (Sensor<E> sensor : this.field_218231_b.values()) {
            sensor.func_220973_b(serverWorld, e);
        }
    }

    private void func_233721_k_() {
        for (Map.Entry<MemoryModuleType<?>, Optional<Memory<?>>> entry : this.field_218230_a.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            Memory<?> memory = entry.getValue().get();
            memory.func_234064_a_();
            if (!memory.func_234073_d_()) continue;
            this.func_218189_b(entry.getKey());
        }
    }

    public void func_218227_b(ServerWorld serverWorld, E e) {
        long l = ((LivingEntity)e).field_70170_p.func_82737_E();
        for (Task<E> task : this.func_233712_d_()) {
            task.func_220380_e(serverWorld, e, l);
        }
    }

    private void func_218218_d(ServerWorld serverWorld, E e) {
        long l = serverWorld.func_82737_E();
        for (Map<Activity, Set<Task<E>>> map : this.field_218232_c.values()) {
            for (Map.Entry<Activity, Set<Task<E>>> entry : map.entrySet()) {
                Activity activity = entry.getKey();
                if (!this.field_218236_g.contains(activity)) continue;
                Set<Task<E>> \u26032 = entry.getValue();
                for (Task<E> task : \u26032) {
                    if (task.func_220376_b() != Task.Status.STOPPED) continue;
                    task.func_220378_b(serverWorld, e, l);
                }
            }
        }
    }

    private void func_218222_e(ServerWorld serverWorld, E e) {
        long l = serverWorld.func_82737_E();
        for (Task<E> task : this.func_233712_d_()) {
            task.func_220377_c(serverWorld, e, l);
        }
    }

    private boolean func_218217_d(Activity activity) {
        if (!this.field_218234_e.containsKey(activity)) {
            return false;
        }
        for (Pair<MemoryModuleType<?>, MemoryModuleStatus> pair : this.field_218234_e.get(activity)) {
            MemoryModuleType memoryModuleType = (MemoryModuleType)pair.getFirst();
            if (this.func_218196_a(memoryModuleType, \u2603 = (MemoryModuleStatus)((Object)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean func_218213_a(Object object) {
        return object instanceof Collection && ((Collection)object).isEmpty();
    }

    ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> func_233692_a_(int n, ImmutableList<? extends Task<? super E>> immutableList) {
        int n2 = n;
        ImmutableList.Builder \u26032 = ImmutableList.builder();
        for (Task task : immutableList) {
            \u26032.add((Object)Pair.of((Object)n2++, (Object)task));
        }
        return \u26032.build();
    }

    static final class MemoryCodec<U> {
        private final MemoryModuleType<U> field_233735_a_;
        private final Optional<? extends Memory<U>> field_233736_b_;

        private static <U> MemoryCodec<U> func_233743_b_(MemoryModuleType<U> memoryModuleType, Optional<? extends Memory<?>> optional) {
            return new MemoryCodec<U>(memoryModuleType, optional);
        }

        private MemoryCodec(MemoryModuleType<U> memoryModuleType, Optional<? extends Memory<U>> optional) {
            this.field_233735_a_ = memoryModuleType;
            this.field_233736_b_ = optional;
        }

        private void func_233738_a_(Brain<?> brain) {
            ((Brain)brain).func_233709_b_(this.field_233735_a_, this.field_233736_b_);
        }

        public <T> void func_233740_a_(DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            this.field_233735_a_.func_234107_a_().ifPresent(codec -> this.field_233736_b_.ifPresent(memory -> recordBuilder.add(Registry.field_218372_N.encodeStart(dynamicOps, this.field_233735_a_), codec.encodeStart(dynamicOps, memory))));
        }
    }

    public static final class BrainCodec<E extends LivingEntity> {
        private final Collection<? extends MemoryModuleType<?>> field_233744_a_;
        private final Collection<? extends SensorType<? extends Sensor<? super E>>> field_233745_b_;
        private final Codec<Brain<E>> field_233746_c_;

        private BrainCodec(Collection<? extends MemoryModuleType<?>> collection, Collection<? extends SensorType<? extends Sensor<? super E>>> collection2) {
            this.field_233744_a_ = collection;
            this.field_233745_b_ = collection2;
            this.field_233746_c_ = Brain.func_233710_b_(collection, collection2);
        }

        public Brain<E> func_233748_a_(Dynamic<?> dynamic) {
            return this.field_233746_c_.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)field_233688_a_).error(arg_0)).orElseGet(() -> new Brain(this.field_233744_a_, this.field_233745_b_, ImmutableList.of(), () -> this.field_233746_c_));
        }
    }
}

