/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.server.ServerWorld;

public class EntitySelector {
    private final int field_197354_a;
    private final boolean field_197355_b;
    private final boolean field_197356_c;
    private final Predicate<Entity> field_197357_d;
    private final MinMaxBounds.FloatBound field_197358_e;
    private final Function<Vector3d, Vector3d> field_197359_f;
    @Nullable
    private final AxisAlignedBB field_197360_g;
    private final BiConsumer<Vector3d, List<? extends Entity>> field_197361_h;
    private final boolean field_197362_i;
    @Nullable
    private final String field_197363_j;
    @Nullable
    private final UUID field_197364_k;
    @Nullable
    private final EntityType<?> field_201957_l;
    private final boolean field_210325_m;

    public EntitySelector(int n, boolean bl, boolean bl2, Predicate<Entity> predicate, MinMaxBounds.FloatBound floatBound, Function<Vector3d, Vector3d> function, @Nullable AxisAlignedBB axisAlignedBB, BiConsumer<Vector3d, List<? extends Entity>> biConsumer, boolean bl3, @Nullable String string, @Nullable UUID uUID, @Nullable EntityType<?> entityType, boolean bl4) {
        this.field_197354_a = n;
        this.field_197355_b = bl;
        this.field_197356_c = bl2;
        this.field_197357_d = predicate;
        this.field_197358_e = floatBound;
        this.field_197359_f = function;
        this.field_197360_g = axisAlignedBB;
        this.field_197361_h = biConsumer;
        this.field_197362_i = bl3;
        this.field_197363_j = string;
        this.field_197364_k = uUID;
        this.field_201957_l = entityType;
        this.field_210325_m = bl4;
    }

    public int func_197346_a() {
        return this.field_197354_a;
    }

    public boolean func_197351_b() {
        return this.field_197355_b;
    }

    public boolean func_197352_c() {
        return this.field_197362_i;
    }

    public boolean func_197353_d() {
        return this.field_197356_c;
    }

    private void func_210324_e(CommandSource commandSource) throws CommandSyntaxException {
        if (this.field_210325_m && !commandSource.func_197034_c(2)) {
            throw EntityArgument.field_210323_f.create();
        }
    }

    public Entity func_197340_a(CommandSource commandSource) throws CommandSyntaxException {
        this.func_210324_e(commandSource);
        List<? extends Entity> list = this.func_197341_b(commandSource);
        if (list.isEmpty()) {
            throw EntityArgument.field_197101_d.create();
        }
        if (list.size() > 1) {
            throw EntityArgument.field_197098_a.create();
        }
        return list.get(0);
    }

    public List<? extends Entity> func_197341_b(CommandSource commandSource2) throws CommandSyntaxException {
        CommandSource commandSource2;
        this.func_210324_e(commandSource2);
        if (!this.field_197355_b) {
            return this.func_197342_d(commandSource2);
        }
        if (this.field_197363_j != null) {
            ServerPlayerEntity serverPlayerEntity = commandSource2.func_197028_i().func_184103_al().func_152612_a(this.field_197363_j);
            if (serverPlayerEntity == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new ServerPlayerEntity[]{serverPlayerEntity});
        }
        if (this.field_197364_k != null) {
            for (ServerWorld \u26032 : commandSource2.func_197028_i().func_212370_w()) {
                Entity entity = \u26032.func_217461_a(this.field_197364_k);
                if (entity == null) continue;
                return Lists.newArrayList((Object[])new Entity[]{entity});
            }
            return Collections.emptyList();
        }
        Vector3d \u26033 = this.field_197359_f.apply(commandSource2.func_197036_d());
        Predicate<Entity> \u26034 = this.func_197349_a(\u26033);
        if (this.field_197362_i) {
            if (commandSource2.func_197022_f() != null && \u26034.test(commandSource2.func_197022_f())) {
                return Lists.newArrayList((Object[])new Entity[]{commandSource2.func_197022_f()});
            }
            return Collections.emptyList();
        }
        ArrayList \u26035 = Lists.newArrayList();
        if (this.func_197353_d()) {
            this.func_197348_a(\u26035, commandSource2.func_197023_e(), \u26033, \u26034);
        } else {
            for (ServerWorld serverWorld : commandSource2.func_197028_i().func_212370_w()) {
                this.func_197348_a(\u26035, serverWorld, \u26033, \u26034);
            }
        }
        return this.func_197345_a(\u26033, \u26035);
    }

    private void func_197348_a(List<Entity> list, ServerWorld serverWorld, Vector3d vector3d, Predicate<Entity> predicate) {
        if (this.field_197360_g != null) {
            list.addAll(serverWorld.func_217394_a(this.field_201957_l, this.field_197360_g.func_191194_a(vector3d), predicate));
        } else {
            list.addAll(serverWorld.func_217482_a(this.field_201957_l, predicate));
        }
    }

    public ServerPlayerEntity func_197347_c(CommandSource commandSource) throws CommandSyntaxException {
        this.func_210324_e(commandSource);
        List<ServerPlayerEntity> list = this.func_197342_d(commandSource);
        if (list.size() != 1) {
            throw EntityArgument.field_197102_e.create();
        }
        return list.get(0);
    }

    public List<ServerPlayerEntity> func_197342_d(CommandSource commandSource2) throws CommandSyntaxException {
        List<Object> list;
        this.func_210324_e(commandSource2);
        if (this.field_197363_j != null) {
            ServerPlayerEntity serverPlayerEntity = commandSource2.func_197028_i().func_184103_al().func_152612_a(this.field_197363_j);
            if (serverPlayerEntity == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new ServerPlayerEntity[]{serverPlayerEntity});
        }
        if (this.field_197364_k != null) {
            CommandSource commandSource2;
            ServerPlayerEntity \u26032 = commandSource2.func_197028_i().func_184103_al().func_177451_a(this.field_197364_k);
            if (\u26032 == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new ServerPlayerEntity[]{\u26032});
        }
        Vector3d vector3d = this.field_197359_f.apply(commandSource2.func_197036_d());
        Predicate<Entity> \u26033 = this.func_197349_a(vector3d);
        if (this.field_197362_i) {
            if (commandSource2.func_197022_f() instanceof ServerPlayerEntity && \u26033.test(\u2603 = (ServerPlayerEntity)commandSource2.func_197022_f())) {
                return Lists.newArrayList((Object[])new ServerPlayerEntity[]{\u2603});
            }
            return Collections.emptyList();
        }
        if (this.func_197353_d()) {
            list = commandSource2.func_197023_e().func_217490_a(\u26033::test);
        } else {
            list = Lists.newArrayList();
            for (ServerPlayerEntity serverPlayerEntity : commandSource2.func_197028_i().func_184103_al().func_181057_v()) {
                if (!\u26033.test(serverPlayerEntity)) continue;
                list.add(serverPlayerEntity);
            }
        }
        return this.func_197345_a(vector3d, list);
    }

    private Predicate<Entity> func_197349_a(Vector3d vector3d) {
        Predicate<Entity> \u26032 = this.field_197357_d;
        if (this.field_197360_g != null) {
            AxisAlignedBB axisAlignedBB = this.field_197360_g.func_191194_a(vector3d);
            \u26032 = \u26032.and(entity -> axisAlignedBB.func_72326_a(entity.func_174813_aQ()));
        }
        if (!this.field_197358_e.func_211335_c()) {
            \u26032 = \u26032.and(entity -> this.field_197358_e.func_211351_a(entity.func_195048_a(vector3d)));
        }
        return \u26032;
    }

    private <T extends Entity> List<T> func_197345_a(Vector3d vector3d, List<T> list) {
        if (list.size() > 1) {
            this.field_197361_h.accept(vector3d, list);
        }
        return list.subList(0, Math.min(this.field_197354_a, list.size()));
    }

    public static IFormattableTextComponent func_197350_a(List<? extends Entity> list) {
        return TextComponentUtils.func_240649_b_(list, Entity::func_145748_c_);
    }
}

