/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JsonReloadListener
extends ReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger field_223380_a = LogManager.getLogger();
    private static final int field_223381_b = ".json".length();
    private final Gson field_223382_c;
    private final String field_223383_d;

    public JsonReloadListener(Gson gson, String string) {
        this.field_223382_c = gson;
        this.field_223383_d = string;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
        HashMap hashMap = Maps.newHashMap();
        int \u26032 = this.field_223383_d.length() + 1;
        for (ResourceLocation resourceLocation : iResourceManager.func_199003_a(this.field_223383_d, string -> string.endsWith(".json"))) {
            String string2 = resourceLocation.func_110623_a();
            ResourceLocation \u26033 = new ResourceLocation(resourceLocation.func_110624_b(), string2.substring(\u26032, string2.length() - field_223381_b));
            try {
                IResource iResource = iResourceManager.func_199002_a(resourceLocation);
                Throwable throwable = null;
                try {
                    InputStream inputStream = iResource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonElement jsonElement = JSONUtils.func_193839_a(this.field_223382_c, bufferedReader, JsonElement.class);
                            if (jsonElement != null) {
                                \u2603 = hashMap.put(\u26033, jsonElement);
                                if (\u2603 == null) continue;
                                throw new IllegalStateException("Duplicate data file ignored with ID " + \u26033);
                            }
                            field_223380_a.error("Couldn't load data file {} from {} as it's null or empty", (Object)\u26033, (Object)resourceLocation);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (bufferedReader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)bufferedReader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)bufferedReader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iResource == null) continue;
                    if (throwable != null) {
                        try {
                            iResource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iResource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException throwable) {
                field_223380_a.error("Couldn't parse data file {} from {}", (Object)\u26033, (Object)resourceLocation, (Object)throwable);
            }
        }
        return hashMap;
    }

    @Override
    protected /* synthetic */ Object func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
        return this.func_212854_a_(iResourceManager, iProfiler);
    }
}

