/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import ironfurnaces.items.ItemAugmentBlasting;
import ironfurnaces.items.ItemAugmentFuel;
import ironfurnaces.items.ItemAugmentSmoking;
import ironfurnaces.items.ItemAugmentSpeed;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import ironfurnaces.tileentity.TileEntityInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.FurnaceFuelSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class BlockIronFurnaceTileBase
extends TileEntityInventory
implements ITickableTileEntity,
IRecipeHolder,
IRecipeHelperPopulator {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    private int timer;
    private int currentAugment = 0;
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime = this.getCookTime();
    private final Map<ResourceLocation, Integer> recipeUseCounts = Maps.newHashMap();
    protected IRecipeType<? extends AbstractCookingRecipe> recipeType;
    public final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BlockIronFurnaceTileBase.this.furnaceBurnTime;
                }
                case 1: {
                    return BlockIronFurnaceTileBase.this.currentItemBurnTime;
                }
                case 2: {
                    return BlockIronFurnaceTileBase.this.cookTime;
                }
                case 3: {
                    return BlockIronFurnaceTileBase.this.totalCookTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    BlockIronFurnaceTileBase.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    BlockIronFurnaceTileBase.this.currentItemBurnTime = value;
                    break;
                }
                case 2: {
                    BlockIronFurnaceTileBase.this.cookTime = value;
                    break;
                }
                case 3: {
                    BlockIronFurnaceTileBase.this.totalCookTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public Map<ResourceLocation, Integer> getRecipeUseCounts() {
        return this.recipeUseCounts;
    }

    public BlockIronFurnaceTileBase(TileEntityType<?> tileentitytypeIn) {
        super(tileentitytypeIn, 4);
        this.recipeType = IRecipeType.field_222150_b;
    }

    protected int getCookTime() {
        ItemStack stack = this.func_70301_a(3);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemAugmentSpeed || stack.func_77973_b() instanceof ItemAugmentBlasting || stack.func_77973_b() instanceof ItemAugmentSmoking) {
                return this.getCookTimeConfig() / 2;
            }
            if (stack.func_77973_b() instanceof ItemAugmentFuel) {
                return (int)((double)this.getCookTimeConfig() * 1.25);
            }
        }
        return this.getCookTimeConfig();
    }

    protected int getCookTimeConfig() {
        return 200;
    }

    private int getAugment(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAugmentBlasting) {
            return 1;
        }
        if (stack.func_77973_b() instanceof ItemAugmentSmoking) {
            return 2;
        }
        if (stack.func_77973_b() instanceof ItemAugmentSpeed) {
            return 3;
        }
        if (stack.func_77973_b() instanceof ItemAugmentFuel) {
            return 4;
        }
        return 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (this.currentAugment != this.getAugment(this.func_70301_a(3))) {
            this.currentAugment = this.getAugment(this.func_70301_a(3));
            this.furnaceBurnTime = 0;
        }
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockState state;
            ++this.timer;
            if (this.totalCookTime != this.getCookTime()) {
                this.totalCookTime = this.getCookTime();
            }
            if (!this.func_70301_a(3).func_190926_b()) {
                if (this.func_70301_a(3).func_77973_b() instanceof ItemAugmentBlasting) {
                    if (this.recipeType != IRecipeType.field_222151_c) {
                        this.recipeType = IRecipeType.field_222151_c;
                    }
                } else if (this.func_70301_a(3).func_77973_b() instanceof ItemAugmentSmoking && this.recipeType != IRecipeType.field_222152_d) {
                    this.recipeType = IRecipeType.field_222152_d;
                }
            } else if (this.recipeType != IRecipeType.field_222150_b) {
                this.recipeType = IRecipeType.field_222150_b;
            }
            ItemStack itemstack = (ItemStack)this.inventory.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe)) {
                    if (itemstack.func_77973_b() instanceof ItemHeater) {
                        int energy;
                        int z;
                        int y;
                        int x;
                        TileEntity te;
                        if (itemstack.func_77942_o() && (te = this.field_145850_b.func_175625_s(new BlockPos(x = itemstack.func_77978_p().func_74762_e("X"), y = itemstack.func_77978_p().func_74762_e("Y"), z = itemstack.func_77978_p().func_74762_e("Z")))) instanceof BlockWirelessEnergyHeaterTile && (energy = ((BlockWirelessEnergyHeaterTile)te).getEnergy()) >= 16000) {
                            ((BlockWirelessEnergyHeaterTile)te).removeEnergy(16000);
                            this.furnaceBurnTime = !this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentFuel ? 3200 * this.getCookTime() / 200 : (!this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentSpeed ? 800 * this.getCookTime() / 200 : 1600 * this.getCookTime() / 200);
                            this.currentItemBurnTime = this.furnaceBurnTime;
                        }
                    } else {
                        this.furnaceBurnTime = !this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentFuel ? 2 * BlockIronFurnaceTileBase.getBurnTime(itemstack) * this.getCookTime() / 200 : (!this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentSpeed ? BlockIronFurnaceTileBase.getBurnTime(itemstack) / 2 * this.getCookTime() / 200 : BlockIronFurnaceTileBase.getBurnTime(itemstack) * this.getCookTime() / 200);
                        this.currentItemBurnTime = this.furnaceBurnTime;
                    }
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!(itemstack.func_77973_b() instanceof ItemHeater)) {
                            if (itemstack.hasContainerItem()) {
                                this.inventory.set(1, (Object)itemstack.getContainerItem());
                            } else if (!itemstack.func_190926_b()) {
                                Item item = itemstack.func_77973_b();
                                itemstack.func_190918_g(1);
                                if (itemstack.func_190926_b()) {
                                    Item item1 = item.func_77668_q();
                                    this.inventory.set(1, (Object)(item1 == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item1)));
                                }
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (this.timer % 24 == 0 && (Boolean)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((Property)BlockStateProperties.field_208190_q) != this.furnaceBurnTime > 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.furnaceBurnTime > 0)), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private boolean canSmelt(@Nullable IRecipe recipe) {
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && recipe != null) {
            ItemStack itemstack = recipe.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.inventory.get(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() < itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void smeltItem(@Nullable IRecipe recipe) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.inventory.get(0);
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)this.inventory.get(2);
            if (itemstack2.func_190926_b()) {
                this.inventory.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_201561_a(this.field_145850_b, null, recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.inventory.get(1)).func_190926_b() && ((ItemStack)this.inventory.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.inventory.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)this.inventory);
        this.furnaceBurnTime = tag.func_74762_e("BurnTime");
        this.cookTime = tag.func_74762_e("CookTime");
        this.totalCookTime = tag.func_74762_e("CookTimeTotal");
        this.timer = 0;
        this.currentAugment = tag.func_74762_e("Augment");
        this.currentItemBurnTime = BlockIronFurnaceTileBase.getBurnTime((ItemStack)this.inventory.get(1));
        int i = tag.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(tag.func_74779_i("RecipeLocation" + j));
            int k = tag.func_74762_e("RecipeAmount" + j);
            this.recipeUseCounts.put(resourcelocation, k);
        }
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        ItemStackHelper.func_191282_a((CompoundNBT)tag, (NonNullList)this.inventory);
        tag.func_74768_a("BurnTime", this.furnaceBurnTime);
        tag.func_74768_a("CookTime", this.cookTime);
        tag.func_74768_a("CookTimeTotal", this.totalCookTime);
        tag.func_74768_a("Augment", this.currentAugment);
        tag.func_74777_a("RecipesUsedSize", (short)this.recipeUseCounts.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeUseCounts.entrySet()) {
            tag.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            tag.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return super.func_189515_b(tag);
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(item, 0) : ret));
    }

    public static boolean isItemFuel(ItemStack stack) {
        return BlockIronFurnaceTileBase.getBurnTime(stack) > 0 || stack.func_77973_b() instanceof ItemHeater;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.func_194112_a(itemstack);
        }
    }

    public void func_193056_a(IRecipe recipe) {
        if (this.recipeUseCounts.containsKey(recipe.func_199560_c())) {
            this.recipeUseCounts.put(recipe.func_199560_c(), this.recipeUseCounts.get(recipe.func_199560_c()) + 1);
        } else {
            this.recipeUseCounts.put(recipe.func_199560_c(), 1);
        }
    }

    @Nullable
    public IRecipe func_193055_i() {
        return null;
    }

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.inventory.get(1);
        return FurnaceTileEntity.func_213991_b((ItemStack)stack) || FurnaceFuelSlot.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar || itemstack.func_77973_b() instanceof ItemHeater;
    }

    public void func_213995_d(PlayerEntity p_213995_1_) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeUseCounts.entrySet()) {
            p_213995_1_.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(p_213993_3_ -> {
                list.add(p_213993_3_);
                BlockIronFurnaceTileBase.func_214003_a(p_213995_1_, (Integer)entry.getValue(), ((AbstractCookingRecipe)p_213993_3_).func_222138_b());
            });
        }
        p_213995_1_.func_195065_a((Collection)list);
        this.recipeUseCounts.clear();
    }

    private static void func_214003_a(PlayerEntity p_214003_0_, int p_214003_1_, float p_214003_2_) {
        if (p_214003_2_ == 0.0f) {
            p_214003_1_ = 0;
        } else if (p_214003_2_ < 1.0f) {
            int i = MathHelper.func_76141_d((float)((float)p_214003_1_ * p_214003_2_));
            if (i < MathHelper.func_76123_f((float)((float)p_214003_1_ * p_214003_2_)) && Math.random() < (double)((float)p_214003_1_ * p_214003_2_ - (float)i)) {
                ++i;
            }
            p_214003_1_ = i;
        }
        while (p_214003_1_ > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)p_214003_1_);
            p_214003_1_ -= j;
            p_214003_0_.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(p_214003_0_.field_70170_p, p_214003_0_.field_70169_q, p_214003_0_.field_70167_r + 0.5, p_214003_0_.field_70166_s + 0.5, j));
        }
    }
}

