/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.items;

import ironfurnaces.init.ModSetup;
import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.BlockIronFurnaceTileBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemUpgrade
extends Item {
    private int[] available;

    public ItemUpgrade(int[] available) {
        super(new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP));
        this.available = available;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Sneak & right-click to upgrade"));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        boolean playSound = false;
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            BlockItemUseContext ctx2 = new BlockItemUseContext(ctx);
            if (te instanceof FurnaceTileEntity || te instanceof BlockIronFurnaceTileBase) {
                BlockState next;
                int cooktime = 0;
                int currentItemBurnTime = 0;
                int furnaceBurnTime = 0;
                if (te instanceof BlockIronFurnaceTileBase) {
                    furnaceBurnTime = ((BlockIronFurnaceTileBase)te).fields.func_221476_a(0);
                    currentItemBurnTime = ((BlockIronFurnaceTileBase)te).fields.func_221476_a(1);
                    cooktime = ((BlockIronFurnaceTileBase)te).fields.func_221476_a(2);
                }
                BlockState blockState = ItemUpgrade.getNextTierBlock(te, this.available).func_196258_a(ctx2) != Blocks.field_150350_a.func_196258_a(ctx2) ? ItemUpgrade.getNextTierBlock(te, this.available).func_196258_a(ctx2) : (next = world.func_180495_p(pos));
                if (next == world.func_180495_p(pos)) {
                    return ActionResultType.PASS;
                }
                ItemStack input = ((IInventory)te).func_70301_a(0).func_77946_l();
                ItemStack fuel = ((IInventory)te).func_70301_a(1).func_77946_l();
                ItemStack output = ((IInventory)te).func_70301_a(2).func_77946_l();
                ItemStack augment = ItemStack.field_190927_a;
                if (te instanceof BlockIronFurnaceTileBase) {
                    augment = ((IInventory)te).func_70301_a(3).func_77946_l();
                }
                world.func_175713_t(te.func_174877_v());
                world.func_180501_a(pos, next, 3);
                TileEntity newTe = world.func_175625_s(pos);
                ((IInventory)newTe).func_70299_a(0, input);
                ((IInventory)newTe).func_70299_a(1, fuel);
                ((IInventory)newTe).func_70299_a(2, output);
                if (newTe instanceof BlockIronFurnaceTileBase) {
                    ((IInventory)newTe).func_70299_a(3, augment);
                    ((BlockIronFurnaceTileBase)newTe).fields.func_221477_a(0, furnaceBurnTime);
                    ((BlockIronFurnaceTileBase)newTe).fields.func_221477_a(1, currentItemBurnTime);
                    ((BlockIronFurnaceTileBase)newTe).fields.func_221477_a(2, cooktime);
                }
                if (!ctx.func_195999_j().func_184812_l_()) {
                    ctx.func_195996_i().func_190918_g(1);
                }
            }
        }
        return super.func_195939_a(ctx);
    }

    public static Block getNextTierBlock(TileEntity te, int[] available) {
        Block block = te.func_195044_w().func_177230_c();
        if (block == Blocks.field_150460_al && available[0] == 1) {
            return (Block)Registration.IRON_FURNACE.get();
        }
        if (block == Registration.IRON_FURNACE.get() && available[1] == 1) {
            return (Block)Registration.GOLD_FURNACE.get();
        }
        if (block == Registration.GOLD_FURNACE.get() && available[2] == 1) {
            return (Block)Registration.DIAMOND_FURNACE.get();
        }
        if (block == Registration.DIAMOND_FURNACE.get() && available[3] == 1) {
            return (Block)Registration.EMERALD_FURNACE.get();
        }
        if (block == Registration.EMERALD_FURNACE.get() && available[4] == 1) {
            return (Block)Registration.OBSIDIAN_FURNACE.get();
        }
        if (block == Registration.DIAMOND_FURNACE.get() && available[5] == 1) {
            return (Block)Registration.CRYSTAL_FURNACE.get();
        }
        if (block == Registration.CRYSTAL_FURNACE.get() && available[6] == 1) {
            return (Block)Registration.OBSIDIAN_FURNACE.get();
        }
        if (block == Registration.OBSIDIAN_FURNACE.get() && available[7] == 1) {
            return (Block)Registration.NETHERITE_FURNACE.get();
        }
        return Blocks.field_150350_a;
    }
}

